/*!
*******************************************************************************
* \file              spi_tclExtCmdMediaDevInfo.h
* \brief             Message dispatcher for active media device info
*******************************************************************************
\verbatim
PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Message dispatcher for active media device info
AUTHOR:         Shiva Kumar Gurija
COPYRIGHT:      &copy; RBEI

HISTORY:
Date       |  Author                                   | Modifications
03.05.2018 |  Shiva Kumar Gurija                       | Initial Version
\endverbatim
******************************************************************************/
#ifndef _SPI_TCLEXTMEDIADEVINFODISPATCHER_H_
#define _SPI_TCLEXTMEDIADEVINFODISPATCHER_H_

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/
#include "SPITypes.h"
#include "RespRegister.h"
#include "ExtInterfacesTypes.h"


/**************Forward Declarations******************************************/
class spi_tclExtMediaDevInfoDispatcher;

/****************************************************************************/
/*!
 * \class MediaDevInfoMsgBase
 * \brief Message dispatcher for active media device info
 ****************************************************************************/
class MediaDevInfoMsgBase: public trMsgBase
{
   public:

   /***************************************************************************
    ** FUNCTION:  MediaDevInfoMsgBase::MediaDevInfoMsgBase
    ***************************************************************************/
   /*!
    * \fn      MediaDevInfoMsgBase()
    * \brief   Default constructor
    **************************************************************************/
	MediaDevInfoMsgBase();

   /***************************************************************************
    ** FUNCTION:  MediaDevInfoMsgBase::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclExtMediaDevInfoDispatcher* poMediaDevInfoDispatcher)
    * \brief   Pure virtual function to be overridden by inherited classes for
    *          dispatching the message
    * \param   poMediaDevInfoDispatcher : pointer to Message dispatcher for Bluetooth
    **************************************************************************/
   virtual t_Void vDispatchMsg(spi_tclExtMediaDevInfoDispatcher* poMediaDevInfoDispatcher)=0;

   /***************************************************************************
    ** FUNCTION:  MediaDevInfoMsgBase::~MediaDevInfoMsgBase
    ***************************************************************************/
   /*!
    * \fn      ~MediaDevInfoMsgBase()
    * \brief   Destructor
    **************************************************************************/
   virtual ~MediaDevInfoMsgBase() {}


   /***************************************************************************
    ** FUNCTION:  t_Void MediaDevInfoMsgBase::vAllocateMsg()
    ***************************************************************************/
   /*!
    * \fn      vAllocateMsg()
    * \brief   To allocate memory
    **************************************************************************/
   virtual t_Void vAllocateMsg() = 0;
   
   /***************************************************************************
    ** FUNCTION:  t_Void MediaDevInfoMsgBase::vDeAllocateMsg()
    ***************************************************************************/
   /*!
    * \fn      vDeAllocateMsg()
    * \brief   To deallocate memory
    **************************************************************************/
   virtual t_Void vDeAllocateMsg() = 0;
};

/****************************************************************************/
/*!
 * \class BTMediaDeviceInfoMsg
 * \brief Conflicts Trigger Msg to invoke the PrepareSetup
 ****************************************************************************/
class BTMediaDeviceInfoMsg: public MediaDevInfoMsgBase
{
   public:
	t_Char szBTMACAddress[256]={0};
	t_Bool bIsConnected = false;
	t_Bool bIsMediaPlaying = false;
	t_U32 u32DevID = 0x0;
	
   /***************************************************************************
    ** FUNCTION:  BTMediaDeviceInfoMsg::BTMediaDeviceInfoMsg
    ***************************************************************************/
   /*!
    * \fn      BTMediaDeviceInfoMsg()
    **************************************************************************/
	BTMediaDeviceInfoMsg(const trMediaDeviceInfo& corfrMediaDeviceInfo);

   /***************************************************************************
    ** FUNCTION:  BTMediaDeviceInfoMsg::~BTMediaDeviceInfoMsg
    ***************************************************************************/
   /*!
    * \fn      ~BTMediaDeviceInfoMsg()
    * \brief   Destructor
    **************************************************************************/
   ~BTMediaDeviceInfoMsg() override{}

   /***************************************************************************
    ** FUNCTION:  BTMediaDeviceInfoMsg::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclExtMediaDevInfoDispatcher* poMediaDevInfoDispatcher)
    * \brief   virtual function for dispatching the message of 'this' type
    * \param   poMediaDevInfoDispatcher : pointer to Message dispatcher for OOBT
    **************************************************************************/
    t_Void vDispatchMsg(spi_tclExtMediaDevInfoDispatcher* poMediaDevInfoDispatcher) override;

   /***************************************************************************
    ** FUNCTION:  BTMediaDeviceInfoMsg(const BTMediaDeviceInfoMsg& corfrBTMediaDeviceInfoMsg)
    ***************************************************************************/
   /*!
    * \fn      BTMediaDeviceInfoMsg(const BTMediaDeviceInfoMsg& corfrBTMediaDeviceInfoMsg)
    * \brief   copy constructor
    **************************************************************************/
    BTMediaDeviceInfoMsg(const BTMediaDeviceInfoMsg& corfrBTMediaDeviceInfoMsg);


    BTMediaDeviceInfoMsg& operator=(const BTMediaDeviceInfoMsg& corfrBTMediaDeviceInfoMsg)=delete;


   /***************************************************************************
    ** FUNCTION:  BTMediaDeviceInfoMsg::vAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vAllocateMsg()
    * \brief   Allocates memory for non trivial datatypes (ex STL containers)
    * \sa      vDeAllocateMsg
    **************************************************************************/
   t_Void vAllocateMsg() override;

   /***************************************************************************
    ** FUNCTION:  BTMediaDeviceInfoMsg::vDeAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vDeAllocateMsg()
    * \brief   Destroys memory allocated by vAllocateMsg()
    * \sa      vAllocateMsg
    **************************************************************************/
   t_Void vDeAllocateMsg() override;

};

/****************************************************************************/
/*!
 * \class spi_tclExtMediaDevInfoDispatcher
 * \brief Message Dispatcher for OOBT Messages
 ****************************************************************************/
class spi_tclExtMediaDevInfoDispatcher
{
   public:
   /***************************************************************************
    ** FUNCTION:  spi_tclExtMediaDevInfoDispatcher::spi_tclExtMediaDevInfoDispatcher
    ***************************************************************************/
   /*!
    * \fn      spi_tclExtMediaDevInfoDispatcher()
    * \brief   Default constructor
    **************************************************************************/
	spi_tclExtMediaDevInfoDispatcher();

   /***************************************************************************
    ** FUNCTION:  spi_tclExtMediaDevInfoDispatcher::~spi_tclExtMediaDevInfoDispatcher
    ***************************************************************************/
   /*!
    * \fn      ~spi_tclExtMediaDevInfoDispatcher()
    * \brief   Destructor
    **************************************************************************/
   ~spi_tclExtMediaDevInfoDispatcher();

   /***************************************************************************
    ** FUNCTION:  spi_tclExtMediaDevInfoDispatcher::vHandleMediaDevInfoMsg(BTMediaDeviceInfoMsg*...)
    ***************************************************************************/
   /*!
    * \fn      vHandleMediaDevInfoMsg(BTMediaDeviceInfoMsg* poBTMediaDeviceInfoMsg)
    * \brief   Handles Messages of BTMediaDeviceInfoMsg type
    * \param   poBTMediaDeviceInfoMsg : pointer to BTMediaDeviceInfoMsg.
    **************************************************************************/
   t_Void vHandleMediaDevInfoMsg(BTMediaDeviceInfoMsg* poBTMediaDeviceInfoMsg) const;

};
#endif /* _SPI_TCLEXTMEDIADEVINFODISPATCHER_H_ */
