/*!
*******************************************************************************
* \file              spi_tclExtCmdMediaDevInfo.h
* \brief             Adapter class for active media device info
*******************************************************************************
\verbatim
PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Adapter class for active media device info
AUTHOR:         Shiva Kumar Gurija
COPYRIGHT:      &copy; RBEI

HISTORY:
Date       |  Author                                   | Modifications
03.05.2018 |  Shiva Kumar Gurija                       | Initial Version
\endverbatim
******************************************************************************/

#ifndef _SPI_TCLCMDEXTCMDMEDIADEVINFO_H_
#define _SPI_TCLCMDEXTCMDMEDIADEVINFO_H_


/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "spi_tclExtCmdMediaDevInfoIntf.h"


/**
* \brief   Adapter class for active media device info
*/
class spi_tclExtCmdMediaDevInfo: public spi_tclExtCmdMediaDevInfoIntf
{
public:
   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/
   /***************************************************************************
   ** FUNCTION:  spi_tclExtCmdMediaDevInfo::spi_tclExtCmdMediaDevInfo()
   ***************************************************************************/
  /*!
   * \fn      spi_tclExtCmdMediaDevInfo()
   * \brief   Default constructor
   * \sa
   **************************************************************************/
	spi_tclExtCmdMediaDevInfo();

   /***************************************************************************
   ** FUNCTION:  spi_tclExtCmdMediaDevInfo::~spi_tclExtCmdMediaDevInfo()
   ***************************************************************************/
   /*!
   * \fn      ~spi_tclExtCmdMediaDevInfo()
   * \brief   Destructor
   * \sa
   **************************************************************************/
   ~spi_tclExtCmdMediaDevInfo() override;

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdMediaDevInfo::bInitialize()
    ***************************************************************************/
   /*!
    * \fn      bInitialize()
    * \brief   Method to Initialize
    * \sa      bInitialize()
    **************************************************************************/
   t_Bool bInitialize() override;

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdMediaDevInfo::bUnInitialize()
    ***************************************************************************/
   /*!
    * \fn      bUnInitialize()
    * \brief   Method to UnInitialize
    * \sa      bInitialize()
    **************************************************************************/
   t_Bool bUnInitialize() override;

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdMediaDevInfo::vMediaDeviceInfoUpdate()
    ***************************************************************************/
   /*!
    * \fn      t_Void vMediaDeviceInfoUpdate(const trMediaDeviceInfo& corfrMediaDeviceInfo)
    * \brief   Method to send the MediaDeviceInfo update
	* \param   corfrMediaDeviceInfo : [IN] Media Device Info update
    * \sa      t_Bool
    **************************************************************************/
   t_Void vMediaDeviceInfoUpdate(const trMediaDeviceInfo& corfrMediaDeviceInfo) override;


   /*************************************************************************
   ****************************END OF PUBLIC*********************************
   *************************************************************************/

protected:

   /***************************************************************************
   *********************************PROTECTED**********************************
   ***************************************************************************/

   /***************************************************************************
   ******************************END OF PROTECTED******************************
   ***************************************************************************/

private:
   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/


   /***************************************************************************
   *! Data members
   ***************************************************************************/

   /*************************************************************************
   ****************************END OF PRIVATE********************************
   *************************************************************************/

};
#endif // #define _SPI_TCLCMDEXTCMDMEDIADEVINFO_H_


