/*!
*******************************************************************************
* \file              spi_tclExtCmdAppleDiscovererIntf.h
* \brief             Apple Discoverer Adapter Interface class
*******************************************************************************
\verbatim
PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Class which provides interfaces to register/un-register
                with Apple Discoverer data provider.
COPYRIGHT:      &copy; RBEI

HISTORY:
Date       |  Author                      | Modifications
19.01.2017 |  Unmukt Jain                 | Initial Version

\endverbatim
******************************************************************************/

#ifndef _SPI_TCLEXTCMDAPPLEDISCOVERERINTF_H_
#define _SPI_TCLEXTCMDAPPLEDISCOVERERINTF_H_

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

#include "SPITypes.h"
/**
* \brief   Apple Discoverer Intf class
*/
class spi_tclExtCmdAppleDiscovererIntf
{
public:
   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  virtual spi_tclExtCmdAppleDiscovererIntf::
   **                      ~spi_tclExtCmdAppleDiscovererIntf()
   ***************************************************************************/
   /*!
   * \fn      ~spi_tclExtCmdAppleDiscovererIntf()
   * \brief   Destructor
   * \sa
   **************************************************************************/
   virtual ~spi_tclExtCmdAppleDiscovererIntf(){}

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdAppleDiscovererIntf::bInitialize()
    ***************************************************************************/
   /*!
    * \fn      bInitialize()
    * \brief   Method to Initialize
    * \sa      bInitialize()
    **************************************************************************/
   virtual t_Bool bInitialize() = 0;

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdAppleDiscovererIntf::bUnInitialize()
    ***************************************************************************/
   /*!
    * \fn      bUnInitialize()
    * \brief   Method to UnInitialize
    * \sa      bInitialize()
    **************************************************************************/
   virtual t_Bool bUnInitialize() = 0;
   
   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdAppleDiscovererIntf::vStartiAP2OverCarPlay()
    ***************************************************************************/
   /*!
    * \fn      vStartiAP2OverCarPlay()
    * \brief   Start iAP2 over carplay
    **************************************************************************/
   virtual t_Void vStartiAP2OverCarPlay(t_String szBTMACAddress) = 0;


   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdAppleDiscovererIntf::vStartDeviceDetection()
    ***************************************************************************/
   /*!
    * \fn      bInitialize()
    * \brief   Starts detecting Apple Devices
    **************************************************************************/
   virtual t_Void vStartDeviceDetection() = 0;

   /***************************************************************************
    ** FUNCTION: t_Void spi_tclExtCmdAppleDiscovererIntf::vClearDeviceDetails
    ***************************************************************************/
   /*!
    * \fn     vClearDeviceDetails
    * \brief  Deleting the Device
    * \param  corfrvecDeletedDevices : List of Devices to be Deleted
    **************************************************************************/
   virtual t_Void vClearDeviceDetails(const std::vector<t_U32> &corfrvecDeletedDevices){

   };




   /*************************************************************************
   ****************************END OF PUBLIC*********************************
   *************************************************************************/

private:
   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/

   /***************************************************************************
   *! Data members
   ***************************************************************************/

   /*************************************************************************
   ****************************END OF PRIVATE********************************
   *************************************************************************/

};

#endif // #define _SPI_TCLEXTCMDAPPLEDISCOVERERINTF_H_

