/***********************************************************************/
/*!
 * \file  spi_tclExtAppleDiscovererDispatcher.h
 * \brief Message Dispatcher for Apple Discoverer Messages. implemented using
 *        double dispatch mechanism
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Message Dispatcher for Apple Discoverer Messages
 AUTHOR:         Unmukt Jain
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 19.01.2017  | Unmukt Jain           | Initial Version

 \endverbatim
 *************************************************************************/
#ifndef _SPI_TCLEXTAPPLEDISCOVERERDISPATCHER_H_
#define _SPI_TCLEXTAPPLEDISCOVERERDISPATCHER_H_

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/
#include "SPITypes.h"
#include "ExtInterfacesTypes.h"
#include "RespRegister.h"
#include "spi_ConnMngrTypeDefines.h"

/**************Forward Declarations******************************************/
class spi_tclExtAppleDiscovererDispatcher;

/****************************************************************************/
/*!
 * \class AppleDiscovererMsgBase
 * \brief Base Message type for all Apple Discoverer messages
 ****************************************************************************/
class AppleDiscovererMsgBase: public trMsgBase
{
   public:

   /***************************************************************************
    ** FUNCTION:  AppleDiscovererMsgBase::AppleDiscovererMsgBase
    ***************************************************************************/
   /*!
    * \fn      AppleDiscovererMsgBase()
    * \brief   Default constructor
    **************************************************************************/
	AppleDiscovererMsgBase();

   /***************************************************************************
    ** FUNCTION:  AppleDiscovererMsgBase::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclExtAppleDiscovererDispatcher* poAppleDiscovererDispatcher)
    * \brief   Pure virtual function to be overridden by inherited classes for
    *          dispatching the message
    * \param   poAppleDiscovererDispatcher: pointer to Message dispatcher for Apple Discoverer
    **************************************************************************/
   virtual t_Void vDispatchMsg(spi_tclExtAppleDiscovererDispatcher *poAppleDiscovererDispatcher) = 0;

   /***************************************************************************
    ** FUNCTION:  AppleDiscovererMsgBase::~AppleDiscovererMsgBase
    ***************************************************************************/
   /*!
    * \fn      ~AppleDiscovererMsgBase()
    * \brief   Destructor
    **************************************************************************/
   virtual ~AppleDiscovererMsgBase()
   {

   }
};

/****************************************************************************/
/*!
 * \class DeviceConnectedMsg
 * \brief Device Connected msg
 ****************************************************************************/
class DeviceConnectedMsg: public AppleDiscovererMsgBase
{
   public:

	trDeviceInfo *m_prDeviceInfo;
	tenDiscovererType m_enDiscovererType;

   /***************************************************************************
   ** FUNCTION:  DeviceConnectedMsg::DeviceConnectedMsg
   ***************************************************************************/
  /*!
   * \fn      DeviceConnectedMsg(const trDeviceInfo &rfcoDeviceInfo, tenDiscovererType enDiscovererType)
   * \brief   Parameterized constructor
   **************************************************************************/
   DeviceConnectedMsg(const trDeviceInfo &rfcoDeviceInfo, tenDiscovererType enDiscovererType);

   /***************************************************************************
    ** FUNCTION:  DeviceConnectedMsg::~DeviceConnectedMsg
    ***************************************************************************/
   /*!
    * \fn      ~DeviceConnectedMsg()
    * \brief   Destructor
    **************************************************************************/
   virtual ~DeviceConnectedMsg(){}

   /***************************************************************************
    ** FUNCTION:  DeviceConnectedMsg::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclExtWiFiDispatcher* poWiFiDispatcher)
    * \brief   virtual function for dispatching the message of 'this' type
    * \param   poAppleDiscovererDispatcher : pointer to Message dispatcher for Apple Discoverer
    **************************************************************************/
   t_Void vDispatchMsg(spi_tclExtAppleDiscovererDispatcher *poAppleDiscovererDispatcher);

   /***************************************************************************
    ** FUNCTION:  DeviceConnectedMsg::vAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vAllocateMsg()
    * \brief   Allocates memory for non trivial datatypes (ex STL containers)
    * \sa      vDeAllocateMsg
    **************************************************************************/
   t_Void vAllocateMsg();

   /***************************************************************************
    ** FUNCTION:  DeviceConnectedMsg::vDeAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vDeAllocateMsg()
    * \brief   Destroys memory allocated by vAllocateMsg()
    * \sa      vAllocateMsg
    **************************************************************************/
   t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class DeviceDisconnectedMsg
 * \brief Device Disconnected msg
 ****************************************************************************/
class DeviceDisconnectedMsg: public AppleDiscovererMsgBase
{
   public:

	t_U32 m_u32DeviceHandle;
	tenDiscovererType m_enDiscovererType;
	tenDeviceConnectionType m_enDeviceConnectionType;
	tenSPISupport m_enCarplaySupport;

   /***************************************************************************
    ** FUNCTION:  DeviceDisconnectedMsg::DeviceDisconnectedMsg
    ***************************************************************************/
   /*!
    * \fn      DeviceDisconnectedMsg(t_U32 u32DeviceHandle, tenDiscovererType enDiscovererType)
    * \brief   Parameterized constructor
    **************************************************************************/
	DeviceDisconnectedMsg(t_U32 u32DeviceHandle, tenDiscovererType enDiscovererType,
            tenDeviceConnectionType enDeviceConnectionType, tenSPISupport enCarplaySupport);

   /***************************************************************************
    ** FUNCTION:  DeviceDisconnectedMsg::~DeviceDisconnectedMsg
    ***************************************************************************/
   /*!
    * \fn      ~DeviceDisconnectedMsg()
    * \brief   Destructor
    **************************************************************************/
   virtual ~DeviceDisconnectedMsg(){}

   /***************************************************************************
    ** FUNCTION:  DeviceDisconnectedMsg::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclExtAppleDiscovererDispatcher *poAppleDiscovererDispatcher)
    * \brief   virtual function for dispatching the message of 'this' type
    * \param   poAppleDiscovererDispatcher : pointer to Message dispatcher for Apple Discoverer
    **************************************************************************/
   t_Void vDispatchMsg(spi_tclExtAppleDiscovererDispatcher *poAppleDiscovererDispatcher);

   /***************************************************************************
    ** FUNCTION:  DeviceDisconnectedMsg::vAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vAllocateMsg()
    * \brief   Allocates memory for non trivial datatypes (ex STL containers)
    * \sa      vDeAllocateMsg
    **************************************************************************/
   t_Void vAllocateMsg();

   /***************************************************************************
    ** FUNCTION:  DeviceDisconnectedMsg::vDeAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vDeAllocateMsg()
    * \brief   Destroys memory allocated by vAllocateMsg()
    * \sa      vAllocateMsg
    **************************************************************************/
   t_Void vDeAllocateMsg();
};


/****************************************************************************/
/*!
 * \class DeviceListMsg
 * \brief DeviceList msg
 ****************************************************************************/
class DeviceListMsg: public AppleDiscovererMsgBase
{
   public:

   trDeviceInfo *m_prDeviceInfo;

   /***************************************************************************
   ** FUNCTION:  DeviceListMsg::DeviceListMsg
   ***************************************************************************/
  /*!
   * \fn      DeviceListMsg(const trDeviceInfo &rfcoDeviceInfo, tenDiscovererType enDiscovererType)
   * \brief   Parameterized constructor
   **************************************************************************/
   DeviceListMsg(const trDeviceInfo &rfcoDeviceInfo);

   /***************************************************************************
    ** FUNCTION:  DeviceListMsg::~DeviceListMsg
    ***************************************************************************/
   /*!
    * \fn      ~DeviceListMsg()
    * \brief   Destructor
    **************************************************************************/
   virtual ~DeviceListMsg(){}

   /***************************************************************************
    ** FUNCTION:  DeviceListMsg::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclExtWiFiDispatcher* poWiFiDispatcher)
    * \brief   virtual function for dispatching the message of 'this' type
    * \param   poAppleDiscovererDispatcher : pointer to Message dispatcher for Apple Discoverer
    **************************************************************************/
   t_Void vDispatchMsg(spi_tclExtAppleDiscovererDispatcher *poAppleDiscovererDispatcher);

   /***************************************************************************
    ** FUNCTION:  DeviceListMsg::vAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vAllocateMsg()
    * \brief   Allocates memory for non trivial datatypes (ex STL containers)
    * \sa      vDeAllocateMsg
    **************************************************************************/
   t_Void vAllocateMsg();

   /***************************************************************************
    ** FUNCTION:  DeviceListMsg::vDeAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vDeAllocateMsg()
    * \brief   Destroys memory allocated by vAllocateMsg()
    * \sa      vAllocateMsg
    **************************************************************************/
   t_Void vDeAllocateMsg();
};


/****************************************************************************/
/*!
 * \class spi_tclExtAppleDiscovererDispatcher
 * \brief Message Dispatcher for Apple Discoverer Messages
 ****************************************************************************/
class spi_tclExtAppleDiscovererDispatcher
{
   public:
   /***************************************************************************
    ** FUNCTION:  spi_tclExtAppleDiscovererDispatcher::
    **                spi_tclExtAppleDiscovererDispatcher()
    ***************************************************************************/
   /*!
    * \fn      spi_tclExtAppleDiscovererDispatcher()
    * \brief   Default constructor
    **************************************************************************/
	spi_tclExtAppleDiscovererDispatcher();

   /***************************************************************************
    ** FUNCTION:  spi_tclExtAppleDiscovererDispatcher::
    **               ~spi_tclExtAppleDiscovererDispatcher
    ***************************************************************************/
   /*!
    * \fn      ~spi_tclExtAppleDiscovererDispatcher()
    * \brief   Destructor
    **************************************************************************/
   ~spi_tclExtAppleDiscovererDispatcher();

   /***************************************************************************
    ** FUNCTION:  spi_tclExtAppleDiscovererDispatcher::
    **                vHandleAppleDiscovererMsg(DeviceConnectedMsg*...)
    ***************************************************************************/
   /*!
    * \fn      vHandleAppleDiscovererMsg(DeviceConnectedMsg* poDeviceConnectedMsg)
    * \brief   Handles Messages of DeviceConnectedMsg type
    * \param   poDeviceConnectedMsg : pointer to DeviceConnectedMsg.
    **************************************************************************/
   t_Void vHandleAppleDiscovererMsg(DeviceConnectedMsg *poDeviceConnectedMsg) const;

   /***************************************************************************
    ** FUNCTION:  spi_tclExtAppleDiscovererDispatcher::
    **                vHandleAppleDiscovererMsg(DeviceListMsg*...)
    ***************************************************************************/
   /*!
    * \fn      vHandleAppleDiscovererMsg(DeviceListMsg* poDeviceListMsg)
    * \brief   Handles Messages of DeviceListMsg type
    * \param   poDeviceListMsg : pointer to DeviceListMsg.
    **************************************************************************/
   t_Void vHandleAppleDiscovererMsg(DeviceListMsg *poDeviceListMsg) const;

   /***************************************************************************
    ** FUNCTION:  spi_tclExtAppleDiscovererDispatcher::
    **                vHandleAppleDiscovererMsg(DeviceDisconnectedMsg*...)
    ***************************************************************************/
   /*!
    * \fn      vHandleAppleDiscovererMsg(DeviceDisconnectedMsg* poDeviceDisconnectedMsg)
    * \brief   Handles Messages of DeviceDisconnectedMsg type
    * \param   poDeviceDisconnectedMsg : pointer to DeviceDisconnectedMsg.
    **************************************************************************/
   t_Void vHandleAppleDiscovererMsg(DeviceDisconnectedMsg *poDeviceDisconnectedMsg) const;

};

#endif /* _SPI_TCLEXTAPPLEDISCOVERERDISPATCHER_H_ */
