/***********************************************************************/
/*!
* \file  spi_tclDipoResourceMngrIntf.h
* \brief Dipo resource manager interface class 
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    
AUTHOR:         Chaitra Srinivasa
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
21.09.2018  | Chaitra Srinivasa     | Initial Version

\endverbatim
*************************************************************************/

#ifndef SPI_TCLDIPORESOURCEMNGRINTF_H
#define SPI_TCLDIPORESOURCEMNGRINTF_H

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "BaseTypes.h"
#include "DiPOTypes.h"

/****************************************************************************/
/*!
* \class spi_tclDipoResourceMngrIntf
* \brief Dipo resource manager interface class 
****************************************************************************/
class spi_tclDipoResourceMngrIntf 
{
public:
      /***************************************************************************
       *********************************PUBLIC************************************
       ***************************************************************************/
       
      /***************************************************************************
       ** FUNCTION:  spi_tclDipoResourceMngrIntf::~spi_tclDipoResourceMngrIntf()
       ***************************************************************************/
       /*!
       * \fn     ~spi_tclDipoResourceMngrIntf()
       * \brief  Destructor
       * \sa     spi_tclDipoResourceMngrIntf()
       **************************************************************************/
       virtual ~spi_tclDipoResourceMngrIntf(){};
       
       /***************************************************************************
        ** FUNCTION:  spi_tclDipoResourceMngrIntf::bGetAudioModechangeMsg()
        ***************************************************************************/
        /*!
        * \fn     bGetAudioModechangeMsg()
        * \brief  function to get a resource mode change message for audio context change 
        * \param  coenAudioCntxt        : [IN] Accessory audio context   
        * \param  bReqStatus            : [IN] Request status, True for request and False for release
        * \param  rfrDiPOAudioContext : [OUT] Audio context
        * \retVal t_Bool : True if successful, false otherwise
        * \sa    
        **************************************************************************/ 
        virtual t_Bool bGetAudioModechangeMsg(const tenAudioContext coenAudioCntxt,
           t_Bool bReqStatus,
           trDiPOAudioContext &rfrDiPOAudioContext) = 0;  
        
        /***************************************************************************
        ** FUNCTION:  spi_tclDipoResourceMngrIntf::bGetVideoModeChangeMsg()
        ***************************************************************************/
        /*!
        * \fn     bGetVideoModeChangeMsg()
        * \brief  Request for video mode change. This will trigger a 
        * \       ModeChangeRequest to the device, because of the change in accessory
        * \       display context.
        * \param  enDisplayContext    : [IN] Accessory display context 
        * \param  bDisplayFlag        : [IN] Display flag
        * \param  rfrDiPOVideoContext : [OUT] Video context update
        * \retVal  Bool, True if successfully create the context change request,
        *         False otherwise.
        * \sa    
        **************************************************************************/    
        virtual t_Bool bGetVideoModeChangeMsg(const tenDisplayContext enDisplayContext, 
             t_Bool bDisplayFlag, trDiPOVideoContext &rfrDiPOVideoContext) = 0;           
        
        /***************************************************************************
        ** FUNCTION: Static  t_Void spi_tclDipoResourceMngrIntf::vPostAudioContext()
        ***************************************************************************/
        /*!
        * \fn     t_Void vPostAudioContext(t_Bool bPlayStatus, t_U8 u8AudioCntxt,
        *                                  tenDiPOEntity enPermMainAudio)
        * \brief  To update the audio context
        * \param  bPlayStatus : Audio playing status
        * \param  u8AudioCntxt : Audio context
        * \param  enPermMainAudio : Permanent owner of audio resource
        * \retVal None
        **************************************************************************/      
        virtual t_Void vPostAudioContext(t_Bool bPlayStatus, t_U8 u8AudioCntxt, tenDiPOEntity enPermMainAudio) = 0;
        
        /***************************************************************************
        ** FUNCTION: Static  t_Void spi_tclDipoResourceMngrIntf::vPostDisplayContext()
        ***************************************************************************/
        /*!
        * \fn     t_Void vPostDisplayContext(t_Bool bRenderStatus, 
        *                           tenDisplayContextReason enDispCntxtReason,
        *                           tenDiPOEntity enPermScreen)
        * \brief  To update the display context
        * \param  bRenderStatus : Video rendering status
        * \param  enDispCntxtReason : Display context reason
        * \param  enPermScreen : Permanent owner of display resource
        * \retVal None
        **************************************************************************/      
        virtual t_Void vPostDisplayContext(t_Bool bRenderStatus, tenDisplayContextReason enDispCntxtReason, tenDiPOEntity enPermScreen) = 0;
        
        /***************************************************************************
        ** FUNCTION: t_Void spi_tclDipoResourceMngrIntf::vSetDisplayLastMode()
        ***************************************************************************/
        /*!
        * \fn     t_Void vSetDisplayLastMode(tenLastMode enLastDisplayMode)
        * \brief  To set the last mode of display
        * \param  enLastDisplayMode : To set last modes of video
        * \retVal None
        **************************************************************************/   
        virtual t_Void vSetDisplayLastMode(tenLastMode enLastDisplayMode) = 0;
        
        /***************************************************************************
        ** FUNCTION: t_Void spi_tclDipoResourceMngrIntf::enGetDisplayLastMode()
        ***************************************************************************/
        /*!
        * \fn     t_Void enGetDisplayLastMode()
        * \brief  To get the last mode of display
        * \retVal None
        **************************************************************************/   
        virtual tenLastMode enGetDisplayLastMode() = 0;
        
        /***************************************************************************
        ** FUNCTION: t_Void spi_tclDipoResourceMngrIntf::vSetAudioLastMode()
        ***************************************************************************/
        /*!
        * \fn     t_Void vSetAudioLastMode(tenLastMode enLastDisplayMode)
        * \brief  To set the last mode of audio
        * \param  enLastDisplayMode : To set last modes of video
        * \retVal None
        **************************************************************************/   
        virtual t_Void vSetAudioLastMode(tenLastMode enLastDisplayMode) = 0;
        
        /***************************************************************************
        ** FUNCTION: tenLastMode spi_tclDipoResourceMngrIntf::enGetAudioLastMode()
        ***************************************************************************/
        /*!
        * \fn     tenLastMode enGetAudioLastMode()
        * \brief  To get the last mode of audio
        * \retVal None
        **************************************************************************/   
        virtual tenLastMode enGetAudioLastMode() = 0;   
        
        /***************************************************************************
        ** FUNCTION: t_Void spi_tclDipoResourceMngrIntf::vSetCallStatus()
        ***************************************************************************/
        /*!
        * \fn     t_Void vSetCallStatus(t_Bool bIsCallActiveBeforeDisableBT)
        * \brief  To set the call status
        * \param  bIsCallActiveBeforeDisableBT : To set the call status
        * \retVal None
        **************************************************************************/    
        virtual t_Void vSetCallStatus(t_Bool bIsCallActiveBeforeDisableBT) = 0;   
        
        /***************************************************************************
        ** FUNCTION: t_Bool spi_tclDipoResourceMngrIntf::bGetCallStatus()
        ***************************************************************************/
        /*!
        * \fn     t_Bool bGetCallStatus()
        * \brief  To get the last mode of audio
        * \retVal None
        **************************************************************************/   
        virtual t_Bool bGetCallStatus() = 0;      
        
        /***************************************************************************
        ** FUNCTION: Static  t_Bool spi_tclDipoResourceMngrIntf::bIsSessionActive()
        ***************************************************************************/
        /*!
        * \fn     t_Bool bIsSessionActive()
        * \brief  To check whether session is active or not
        * \retVal t_Bool
        **************************************************************************/   
        virtual t_Bool bIsSessionActive() = 0;          
        
        /***************************************************************************
        ** FUNCTION: t_Void spi_tclDipoResourceMngrIntf::vProjVideoRenderingStatus(...
        ***************************************************************************/
        /*!
        * \fn      t_Void vProjVideoRenderingStatus(tenProjVideoRenderingStatus enProjRenderingStatus)
        * \brief   Method to update the projection video rendering status update
        * *        Projection stopped update from Phone.stop in IVideoAdapter.
        * \param   enProjRenderingStatus : [IN] CarPlay projection status
        * \retval  t_Void
        ***************************************************************************/
        virtual t_Void vProjVideoRenderingStatus(tenProjVideoRenderingStatus enProjRenderingStatus) = 0;         

        /***************************************************************************
        ** FUNCTION: t_Void spi_tclResourceMngr::vPostDeviceSpmSubState()
        ***************************************************************************/
        /*!
        * \fn     vPostDeviceSpmSubState()
        * \brief  This function used to update LCM about the SPM substate changes
        * \param  enSpmSubState  : [IN] Spm SubState type
        * \param  m_bSubStateData  : [IN] Spm SubState data
        **************************************************************************/
        virtual t_Void vPostDeviceSpmSubState(tenSpmSubState enSpmSubState, t_Bool m_bSubStateData)= 0;
       
};       
#endif /*SPI_TCLDIPORESOURCEMNGRINTF_H */       
      
