/***********************************************************************/
/*!
* \file  spi_tclDiPoVideoResourceMngr.h
* \brief Manages DiPo Video resource
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Manages DiPo Video resource
AUTHOR:         Anjan kumar sahu
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
17.08.2018  | Anjan kumar sahu      | Initial Version
27.08.2018  | Chaitra Srinivasa     | Improvements to add and remove methods and member variables

\endverbatim
*************************************************************************/

#ifndef SPI_TCLDIPOVIDEORESOURCEMNGR_H_
#define SPI_TCLDIPOVIDEORESOURCEMNGR_H_

/******************************************************************************
| includes:
|----------------------------------------------------------------------------*/

#include "DiPOTypes.h"
#include "Timer.h"
#include "Lock.h"
#include "spi_tclDiPORespVideo.h"
#include "spi_tclResourceMngrSettingsIntf.h"

class spi_tclDipoResourceMngrIntf;
class spi_tclDiPOCmdVideo;
class spi_tclDiPOCmdRsrcMngr;

/*!
* \class spi_tclDiPoVideoResourceMngr
* \brief Manages DiPo Video resource
*/
class spi_tclDiPoVideoResourceMngr: public spi_tclDiPORespVideo 
{
public:
    /***************************************************************************
    *********************************PUBLIC*************************************
    ***************************************************************************/

    /***************************************************************************
    ** FUNCTION:  spi_tclDiPoVideoResourceMngr::spi_tclDiPoVideoResourceMngr
    ***************************************************************************/
    /*!
    * \fn     spi_tclDiPoVideoResourceMngr(spi_tclDipoResourceMngrIntf* poDipoResrcMngrIntf)
    * \brief  Default Constructor
    * \sa      ~spi_tclDiPoVideoResourceMngr()
    **************************************************************************/
    spi_tclDiPoVideoResourceMngr(spi_tclDipoResourceMngrIntf* poDipoResrcMngrIntf);

    /***************************************************************************
    ** FUNCTION:  spi_tclDiPoVideoResourceMngr::~spi_tclDiPoVideoResourceMngr
    ***************************************************************************/
    /*!
    * \fn     ~spi_tclDiPoVideoResourceMngr()
    * \brief  destructor
    * \sa     spi_tclDiPoVideoResourceMngr()
    **************************************************************************/
    ~spi_tclDiPoVideoResourceMngr();

    /***************************************************************************
     ** FUNCTION:  spi_tclDiPoVideoResourceMngr::vOnSPISelectDeviceResult()
     ***************************************************************************/
     /*!
     * \fn     vOnSPISelectDeviceResult()
      * \brief   Interface to receive result of SPI device selection/deselection
     * \param   u32DevID : [IN] Resource Manager callbacks structure.
     * \param   enDeviceConnReq : [IN] Select/ deselect.
     * \param   enRespCode : [IN] Response code (success/failure)
     * \param   enErrorCode : [IN] Error
     * \retval  t_Void
     **************************************************************************/
     t_Void vOnSPISelectDeviceResult(t_U32 u32DevID,
           tenDeviceConnectionReq enDeviceConnReq,
           tenResponseCode enRespCode,
           tenErrorCode enErrorCode);

    /***************************************************************************
    ** FUNCTION: t_Void spi_tclDiPoVideoResourceMngr::vSetAccessoryDisplayMode(t_U32...
    ***************************************************************************/
    /*!
    * \fn     vSetAccessoryDisplayMode()
    * \brief  Accessory display mode update request.
    * \param  [IN] corDisplayContext : Display context info
    * \param  [IN] corDisplayConstraint : DiDisplay constraint info
    * \param  [IN] coenDisplayInfo      : Display info flag
    * \sa
    **************************************************************************/
    t_Void vSetAccessoryDisplayMode(const trDisplayContext corDisplayContext,
        const trDisplayConstraint corDisplayConstraint,
        const tenDisplayInfo coenDisplayInfo);
        
    /***************************************************************************
    ** FUNCTION:  t_Void spi_tclDiPoVideoResourceMngr::vSetAccessoryDisplayContext()
    ***************************************************************************/
    /*!
    * \fn      t_Void vSetAccessoryDisplayContext(
    *          t_Bool bDisplayFlag, tenDisplayContext enDisplayContext)
    * \brief   To send accessory display context related info .
    * \param   bDisplayFlag : [IN] Display flag
    * \param   enDisplayContext : [IN] Display context
    * \retval  t_Void
    **************************************************************************/
    t_Void vSetAccessoryDisplayContext(t_Bool bDisplayFlag, 
        tenDisplayContext enDisplayContext);

    /***************************************************************************
    ** FUNCTION: t_Void spi_tclDiPoVideoResourceMngr::vOnPluginLoaded(...
    ***************************************************************************/
    /*!
    * \fn     vOnPluginLoaded()
    * \brief  Used to set Accessory display context.
    * \sa
    **************************************************************************/
    t_Void vOnPluginLoaded();

    /***************************************************************************
    ** FUNCTION:  t_Void spi_tclDiPoVideoResourceMngr::vHandleDisplayLastMode(...
    ***************************************************************************/
    /*!
    * \fn      t_Void vHandleDisplayLastMode(trDiPOVideoContext& rfrDiPOVideoContext)
    * \brief   Sets the video context to be set based on the last mode
    * \param   rfrDiPOVideoContext: [OUT] video context that should be set based on last mode
    * \retval  t_Void
    ***************************************************************************/
    t_Void vHandleDisplayLastMode(trDiPOVideoContext& rfrDiPOVideoContext);

    /***************************************************************************
    ** FUNCTION:  spi_tclDiPoVideoResourceMngr::vUpdateInitialVideoSettings()
    ***************************************************************************/
    /*!
    * \fn     vUpdateInitialVideoSettings(t_Bool bIsLastModeSupported)
    * \brief  Function to set the initial video settings
    * \param  bIsLastModeSupported
    * \retval  t_Void
    **************************************************************************/
    t_Void vUpdateInitialVideoSettings(t_Bool bIsLastModeSupported);

    /***************************************************************************
    ** FUNCTION:  t_Void spi_tclDiPoVideoResourceMngr::bIsCallActive(...)
    ***************************************************************************/
    /*!
    * \fn      t_Bool bIsCallActive()
    * \brief   Method to get whether Call is active with the CarPlay device.
    * \retval  t_Bool
    ***************************************************************************/
    t_Bool bIsCallActive();

    /***************************************************************************
     ** FUNCTION:  t_Void spi_tclDiPoVideoResourceMngr::vUpdateDisplayContext()
     ***************************************************************************/
     /*!
     * \fn      t_Void vUpdateDisplayContext()
     * \brief   Function to examine the display resource ownership changes and,
     * \        update the HMI if required. 
     * \param   corfoDiPOModeState : [IN] CarPlay mode state
     * \retval  t_Void
     **************************************************************************/
     t_Void vUpdateDisplayContext(const trDiPOModeState &corfoDiPOModeState);
     
     /***************************************************************************
     ** FUNCTION: t_Void spi_tclDiPoVideoResourceMngr::vVideoPlaybackStatus(...
     ***************************************************************************/
     /*!
     * \fn      t_Void vVideoPlaybackStatus(t_Bool bIsPlaybackStarted)
     * \brief   Method to update the projection video rendering status update
     * *        Projection started update from Phone. (VideoPlaybackstarted in IcontrolAdapter)
     * \param   bIsPlaybackStarted : [IN] TRUE - CarPlay projection started
     * \retval  t_Void
     ***************************************************************************/
     t_Void vVideoPlaybackStatus(t_Bool bIsPlaybackStarted);    

     /***************************************************************************
     ** FUNCTION: t_Void spi_tclDiPoVideoResourceMngr::vOnRequestUI(...)
     ***************************************************************************/
     /*!
     * \fn      t_Void vOnRequestUI(t_String szRequestUIURL)
     * \brief   Method to update the notification from Phone to switch to native UI
     * \param   szRequestUIURL : [IN]Request UI URL.
     * \retval  t_Void
     ***************************************************************************/
     t_Void vOnRequestUI(t_String szRequestUIURL);     

     /***************************************************************************
      ** FUNCTION:  t_Void spi_tclDiPoVideoResourceMngr::vSetFeatureRestrictions()
      ***************************************************************************/
     /*!
      * \fn      t_Void vSetFeatureRestrictions(const t_U8 cou8ParkModeRestrictionInfo,
      *          const t_U8 cou8DriveModeRestrictionInfo)
      * \brief   Method to set Vehicle Park/Drive Mode Restriction
      *          cou8ParkModeRestrictionInfo : Park mode restriction
      *          cou8DriveModeRestrictionInfo : Drive mode restriction
      * \retval  t_Void
      **************************************************************************/
      t_Void vSetFeatureRestrictions(const t_U8 cou8ParkModeRestrictionInfo,
           const t_U8 cou8DriveModeRestrictionInfo);

      /***************************************************************************
      ** FUNCTION: t_Void spi_tclDiPoVideoResourceMngr::vOnSetNativeVideoRenderingStatus()
      ***************************************************************************/
      /*!
      * \fn     t_Void vOnSetNativeVideoRenderingStatus(tenNativeVideoRenderingStatus enNativeVideoRenderingStatus)
      * \brief  Method to inform the native video rendering status update.
      * \param  enNativeVideoRenderingStatus : Whether the video rendering has
      *                                        started or stopped.
      * \retval t_Void
      **************************************************************************/
      t_Void vOnSetNativeVideoRenderingStatus(tenNativeVideoRenderingStatus enNativeVideoRenderingStatus);
      
      /***************************************************************************
      ** FUNCTION: t_Void spi_tclDiPoVideoResourceMngr::vProjVideoRenderingStatus(...
      ***************************************************************************/
      /*!
      * \fn      t_Void vProjVideoRenderingStatus(tenProjVideoRenderingStatus enProjRenderingStatus)
      * \brief   Method to update the projection video rendering status update
      * *        Projection stopped update from Phone.stop in IVideoAdapter.
      * \param   enProjRenderingStatus : [IN] CarPlay projection status
      * \retval  t_Void
      ***************************************************************************/
      t_Void vProjVideoRenderingStatus(tenProjVideoRenderingStatus enProjRenderingStatus);       

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclDiPoVideoResourceMngr::vSetResourceMngrSettingsInstance(spi_tclResourceMngrSettingsIntf* poResourceMngrSettingsIntf)
       ***************************************************************************/
       /*!
       * \fn      t_Void vSetResourceMngrSettingsInstance()
       * \brief   Method to set Resource manager settings instance.
       * \param   poResourceMngrSettingsIntf : pointer to InputHandlerSettingsIntf.
       * \retval  t_Void
       **************************************************************************/
      t_Void vSetResourceMngrSettingsInstance(spi_tclResourceMngrSettingsIntf* poResourceMngrSettingsIntf);

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclDiPoVideoResourceMngr::vUpdateSpmSubState()
   ***************************************************************************/
   /*!
   * \fn      t_Void vUpdateAppState()
   * \brief   Function to determine the CarPlay device app state changes and,
   * \        update it to the LCM if required
   * \param   corfoDiPOModeState : [IN] mode state
   * \retval  t_Void
   **************************************************************************/
   t_Void vUpdateSpmSubState(const trDiPOModeState & corfoPrevDiPOModeState, const trDiPOModeState & corfoCurrDiPOModeState);

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclDiPoVideoResourceMngr::bIsDisplayOffActive(...)
   ***************************************************************************/
   /*!
   * \fn      t_Bool bIsDisplayOffActive()
   * \brief   Method to get whether display off mode is active with the CarPlay device.
   * \retval  t_Bool
   ***************************************************************************/
   t_Bool bIsDisplayOffActive();

private:

      /***************************************************************************
      ** FUNCTION:  t_Void spi_tclDiPoVideoResourceMngr::vUpdateLastDisplayMode(...
      ***************************************************************************/
      /*!
      * \fn      t_Void vUpdateLastDisplayMode(t_Bool bIsResetLastMode)
      * \brief   To store the last display mode
      * \param   bIsResetLastMode: [IN] Indicates whether last display mode should be reset
      * \retval  t_Void
      ***************************************************************************/
      t_Void vUpdateLastDisplayMode(t_Bool bIsResetLastMode);      

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclDiPoVideoResourceMngr::bSiriActivated()
   ***************************************************************************/
   /*!
   * \fn      t_Void bSiriActivated()
   * \brief   Function to determine if siri is activated
   * \param   corfoDiPOModeState : [IN] mode state
   * \retval  t_Bool
   **************************************************************************/
   t_Bool bSiriActivated(const trDiPOModeState & corfoPrevDiPOModeState, const trDiPOModeState & corfoCurrDiPOModeState);

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclDiPoVideoResourceMngr::bTempVideoResWithDevice()
   ***************************************************************************/
   /*!
   * \fn      t_Void bTempVideoResWithDevice()
   * \brief   Function to determine if any temporary state change happened - eg:- message
   * \param   corfoDiPOModeState : [IN] mode state
   * \retval  t_Bool
   **************************************************************************/
   t_Bool bTempVideoResWithDevice(const trDiPOModeState & corfoPrevDiPOModeState, const trDiPOModeState & corfoCurrDiPOModeState);

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclDiPoVideoResourceMngr::bStateRestored()
   ***************************************************************************/
   /*!
   * \fn      t_Void bStateRestored()
   * \brief   Function to determine if temporary state change is restored
   * \param   corfoDiPOModeState : [IN] mode state
   * \retval  t_Bool
   **************************************************************************/
   t_Bool bStateRestored(const trDiPOModeState & corfoPrevDiPOModeState, const trDiPOModeState & corfoCurrDiPOModeState);

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclDiPoVideoResourceMngr::bProcessModeStateEvent()
   ***************************************************************************/
   /*!
   * \fn      t_Void bProcessModeStateEvent()
   * \brief   Function to determine if temporary/permanent state change is to be set/reset
   * \param   corfoDiPOModeState : [IN] mode state
   * \retval  t_Bool
   **************************************************************************/
   t_Bool bProcessModeStateEvent(const trDiPOModeState & corfoPrevDiPOModeState, const trDiPOModeState & corfoCurrDiPOModeState);

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclDiPoVideoResourceMngr::vSetDisplayOffActive(...)
   ***************************************************************************/
   /*!
   * \fn      t_Bool vSetDisplayOffActive()
   * \brief   Method to set display off mode
   * \param   bIsDisplayOffActive : [IN] TRUE - display off mode activated
   * \retval  t_Void
   ***************************************************************************/
   t_Void vSetDisplayOffActive(t_Bool bIsDisplayOffActive);

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclDiPoVideoResourceMngr::vSetTempSpmSubState(...)
   ***************************************************************************/
   /*!
   * \fn      t_Bool vSetTempSpmSubState()
   * \brief   Method to set temporary property
   * \param   bSpmSubStateDataEnable : [IN] TRUE/FALSE
   * \retval  t_Void
   ***************************************************************************/
   t_Void vSetTempSpmSubState(t_Bool bSpmSubStateDataEnable);

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclDiPoVideoResourceMngr::vSetPermSpmSubState(...)
   ***************************************************************************/
   /*!
   * \fn      t_Bool vSetPermSpmSubState()
   * \brief   Method to set permanent property
   * \param   bSpmSubStateDataEnable : [IN] TRUE/FALSE
   * \retval  t_Void
   ***************************************************************************/
   t_Void vSetPermSpmSubState(t_Bool bSpmSubStateDataEnable);

      //! Indicates if last mode settings is enabled
      t_Bool m_bIsLastModeSupported;
      
      //! Indicates if request UI should be sent after unborrow
      t_Bool m_bIsRequestUIRequired;
      
      //! Current Display Context
      tenDisplayContext m_enCurDispCntxt;
          
      //! Stores the last take context for display resource
      trDiPOVideoContext m_rLastDispTakeContext;
      
      //! Indicates whether the resource management is handled by HMI or SPI.
      tenDisplayInfo m_enDisplayInfo;
      
      //! Status of the video playback for CarPlay.
      t_Bool m_bIsVideoPlaybackStarted;    
           
      //! Current display flag
      t_Bool m_bCurDispFlag;    

      //! whether display off mode is active
      t_Bool m_bDisplayOffActive; 

      //! spm substate based on user action
      tenSpmSubState m_enSpmSubState;

      //! spm substate data
      t_Bool m_bSubStateData;
      
      //! Stores the current display constraints
      trDisplayConstraint m_rCurDispConstraint;  
      
      //! Pointer to Dipo cmd resource manager
      spi_tclDiPOCmdRsrcMngr* m_poDiPOCmdRsrcMngr;
      
      //! Pointer to Dipo cmd Video
      spi_tclDiPOCmdVideo* m_poDiPOCmdVideo;
      
      //! Pointer to Dipo resrc mngr interface
      spi_tclDipoResourceMngrIntf* m_poDipoRsrcMngrIntf;
      
      //! To store current mode state
      trDiPOModeState m_rCurrModeState;
     
      //! To store Display last mode
      tenLastMode m_enLastDisplayMode;

      //! display flag to restore the previous display state
      t_Bool m_bStartupDispFlag;
      
      //! display flag to restore the previous display context state
      tenDisplayContext m_enStartupDispCntxt;      
      
      // sets resource manager settings pointer
      spi_tclResourceMngrSettingsIntf* m_poResourceMngrSettings;

};


#endif /* SPI_TCLDIPOVIDEORESOURCEMNGR_H_ */
