/*!
*******************************************************************************
* \file              spi_tclDiPoKeys.h
* \brief             DiPO Utils
*******************************************************************************
\verbatim
PROJECT:        G3G
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    DiPO Utils for Key Info
COPYRIGHT:      &copy; RBEI

HISTORY:
Date       |  Author                      | Modifications
29.04.2019 |  Ram Chaithanya S A          | Initial Version

\endverbatim
******************************************************************************/
#ifndef SPI_TCLDIPOKEYS_H
#define SPI_TCLDIPOKEYS_H

/******************************************************************************
| includes:
|----------------------------------------------------------------------------*/
#include "BaseTypes.h"
#include "DiPOTypes.h"

/****************************************************************************/
/*!
* \class spi_tclDiPoKeys
* \brief DiPOKeys class
*
* spi_tclDiPoKeys class is used to build Different Key decriptors and Bitmaps
****************************************************************************/
class spi_tclDiPoKeys
{
public:
  /***************************************************************************
   *********************************PUBLIC************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  spi_tclDiPoKeys::spi_tclDiPoKeys()
   ***************************************************************************/
   /*!
   * \fn     spi_tclDiPoKeys()
   * \brief  Constructor
   * \sa     ~spi_tclDiPoKeys()
   **************************************************************************/
   spi_tclDiPoKeys();

  /***************************************************************************
   ** FUNCTION:  spi_tclDiPoKeys::~spi_tclDiPoKeys()
   ***************************************************************************/
   /*!
   * \fn     ~spi_tclDiPoKeys()
   * \brief  Destructor
   * \sa     spi_tclDiPoKeys()
   **************************************************************************/
   ~spi_tclDiPoKeys();

   /***************************************************************************
   ** FUNCTION: t_Void spi_tclDiPoKeys::vGetKeySupported()
   ***************************************************************************/
   /*!
   * \fn        t_Void vGetKeySupported(std::vector<t_U8> &enConsumerKey,std::vector<t_U8> &enConsumerBit,
   *                       std::vector<t_U8> &vecu8PhoneKey,std::vector<t_U8> &vecu8PhoneKeyBitmap,
   *                       std::vector<t_U8> &vecu8KnobKey,std::vector<t_U8> &vecu8KnobKeyBitmap,
   *                       const std::set<tenKeyCode>& rsetKeyCodes);
   * \brief  method to get supported HardKeys for DiPo
   * \param  vecu8ConsumerKeys   : [OUT] ConsumerKeys supported for CarPlay.
   * \param  vecu8ConsumerBitMap : [OUT] Consumer BitMap  for CarPlay.
   * \param  vecu8PhoneKeys      : [OUT] PhoneKeys supported for CarPlay.
   * \param  vecu8PhoneKeyBitMap : [OUT] Phone Key BitMap CarPlay.
   * \param  vecu8KnobKeys       : [OUT] Knob Keys supported for CarPlay.
   * \param  vecu8KnobKeyBitMap  : [OUT] Knob Key BitMap.
   * \param  bITCommanderSuppport: [OUT] ITCommanderSupport
   * \retval t_Void
   **************************************************************************/
   t_Void vGetKeySupported(std::vector<t_U8> &vecu8ConsumerKey,std::vector<t_U8> &vecu8PhoneKey,
                           std::vector<t_U8> &vecu8KnobKey,std::vector<t_U8> &vecu8ConsumerBitmap,
                           std::vector<t_U8> &vecu8PhoneKeyBitmap,std::vector<t_U8> &vecu8KnobKeyBitmap,
                           const std::set<tenKeyCode>& rsetKeyCodes,t_Bool &bITCommanderSupport,
                           t_Bool &bRotaryKnobSupport);


   /***************************************************************************
   **************************END OF PUBLIC************************************
   ***************************************************************************/

private:

   /***************************************************************************
   ***************************PRIVATE*****************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION: t_Void spi_tclDiPoKeys::vBuildConsumerDescriptor()
   ***************************************************************************/
   /*!
   * \fn     t_Void vBuildConsumerDescriptor(const std::set<tenKeyCode> &corfsetKeyCodes,
                                             std::vector<t_U8> &enConsumerKeyTest);
   * \brief  method to Bulid Consumer Descriptor
   * \param  corfsetKeyCodes   : [IN] Set of KeyCodes supported for CarPlay.
   * \param  vecu8ConsumerKeys : [IN] ConsumerKeys supported for CarPlay.
   * \retval t_Void
   **************************************************************************/
   t_Void vBuildConsumerDescriptor(const std::set<tenKeyCode> &corfsetKeyCodes,std::vector<t_U8> &vecu8ConsumerKeys);

   /***************************************************************************
   ** FUNCTION: t_Void spi_tclDiPoKeys::vBuildConsumerBitmap()
   ***************************************************************************/
   /*!
   * \fn     t_Void vBuildConsumerBitmap(const std::set<tenKeyCode> &corfsetKeyCodes,
                                         std::vector<t_U8> &enConsumerBitTest);
   * \brief  method to Build Consumer Bitmap
   * \param  corfsetKeyCodes      : [IN] Set of KeyCodes supported for CarPlay.
   * \param  vecu8ConsumerBitMap  : [IN] Consumer BitMap  for CarPlay.
   * \retval t_Void
   **************************************************************************/
   t_Void vBuildConsumerBitmap(const std::set<tenKeyCode> &corfsetKeyCodes,std::vector<t_U8> &vecu8ConsumerBitMap);

   /***************************************************************************
   ** FUNCTION: t_Void spi_tclDiPoKeys::vBuildPhoneKeyDescriptor()
   ***************************************************************************/
   /*!
   * \fn     t_Void vBuildPhoneKeyDescriptor(const std::set<tenKeyCode> &corfrsetKeyCodes,
                                             std::vector<t_U8> &vecu8PhoneKeyTest);
   * \brief  method to Build phone key Descriptor
   * \param  corfsetKeyCodes   : [IN] Set of KeyCodes supported for CarPlay.
   * \param  vecu8PhoneKeys    : [IN] PhoneKeys supported for CarPlay.
   * \retval t_Void
   **************************************************************************/
   t_Void vBuildPhoneKeyDescriptor(const std::set<tenKeyCode> &corfrsetKeyCodes,std::vector<t_U8> &vecu8PhoneKeys);

   /***************************************************************************
   ** FUNCTION: t_Void spi_tclDiPoKeys::vBuildPhoneKeyBitmap()
   ***************************************************************************/
   /*!
   * \fn     t_Void vBuildPhoneKeyBitmap(const std::set<tenKeyCode> &corfrsetKeyCodes,
                                         std::vector<t_U8> &vecu8PhoneKeyBitmapTest);
   * \brief  method to Build Phone Key Bitmap
   * \param  corfsetKeyCodes      : [IN] Set of KeyCodes supported for CarPlay.
   * \param  vecu8PhoneKeyBitMap  : [IN] Phone Key BitMap CarPlay.
   * \retval t_Void
   **************************************************************************/
   t_Void vBuildPhoneKeyBitmap(const std::set<tenKeyCode> &corfrsetKeyCodes,std::vector<t_U8> &vecu8PhoneKeyBitMap);

   /***************************************************************************
   ** FUNCTION: t_Void spi_tclDiPoKeys::vBuildKnobKeyDescriptor()
   ***************************************************************************/
   /*!
   * \fn     t_Void vBuildKnobKeyDescriptor(const std::set<tenKeyCode> &corfsetKeyCodes,
   *                                        std::vector<t_U8> &vecu8KnobKeyTest);
   *
   * \brief  method to Build knob key Descriptor
   * \param  corfsetKeyCodes   : [IN] Set of KeyCodes supported for CarPlay.
   * \param  vecu8KnobKeys     : [OUT] Knob Keys supported for CarPlay.
   * \retval t_Void

   **************************************************************************/
   t_Void vBuildKnobKeyDescriptor(const std::set<tenKeyCode> &corfrsetKeyCodes,std::vector<t_U8> &vecu8KnobKeys,
                                  t_Bool bITCommanderSupport,t_Bool bRotaryKnobSupport);

   /***************************************************************************
   ** FUNCTION: t_Void spi_tclDiPoKeys::vBuildKnobKeyBitmap()
   ***************************************************************************/
   /*!
   * \fn    t_Void vBuildKnobKeyBitmap(const std::set<tenKeyCode> &corfsetKeyCodes,
                                       std::vector<t_U8> &vecu8KnobKeyBitmapTest);
   * \brief  method to build knob key bit map.
   * \param  corfsetKeyCodes    : [IN] Set of KeyCodes supported for CarPlay.
   * \param  vecu8KnobKeyBitMap : [OUT] Knob Key BitMap.
   * \retval t_Void
   **************************************************************************/
   t_Void vBuildKnobKeyBitmap(std::vector<t_U8> &vecu8KnobKeyBitmap,
                              t_Bool bITCommanderSupport,
                              t_Bool bRotaryKnobSupport);




   //! map for AllKeyCodes to Dipo Consumer KeyCodes
   std::map<tenKeyCode,tenDIPOConsumerkeyCodes> m_DIPOConsumerkeyCodeMap;

   //! map for AllKeyCodes to Dipo Phone KeyCodes
   std::map<tenKeyCode,tenDIPOPhonekeyCodes> m_DIPOPhonekeyCodeMap;

   // Consumer KeyCodes supported for DiPo
   std::vector<tenKeyCode> m_vecConsKeys;

   // Phone KeyCodes supported for DiPo
   std::vector<tenKeyCode> m_vecPhnKeys;

   // Knob KeyCodes Supported for DiPo
   std::vector<tenKeyCode> m_vecKnobKeys;

   /***************************************************************************
   **************************END OF PRIVATE************************************
   ***************************************************************************/
};

#endif

