/***********************************************************************/
/*!
* \file  spi_tclDiPOVideoDispatcher.cpp
* \brief Message Dispatcher for Discoverer Messages.
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Message Dispatcher for Discoverer Messages.   
AUTHOR:         Shiva Kumar Gurija
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
09.12.2016  | Shiva Kumar Gurija    | Initial Version

\endverbatim
*************************************************************************/


/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/
#include "SPITypes.h"
#include "DiPOTypes.h"
#include "StringHandler.h"
#include "RespRegister.h"
#include "spi_tclDiPOVideoDispatcher.h"
#include "spi_tclDiPORespVideo.h"

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_MSGQTHREADER
#include "trcGenProj/Header/spi_tclDiPOVideoDispatcher.cpp.trc.h"
#endif
#endif

/******************************************************************************
| typedefs (scope: module-global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: local)
|----------------------------------------------------------------------------*/
#define DEFINE_DISPATCH_MESSAGE_FUNCTION(COMMAND,DISPATCHER)\
t_Void COMMAND::vDispatchMsg(DISPATCHER* poDispatcher)      \
{                                                           \
   if (NULL != poDispatcher)                                \
   {                                                        \
      poDispatcher->vHandleVideoMsg(this);              \
   }                                                        \
   vDeAllocateMsg();                                        \
}                                                           \

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/***************************************************************************
 ** FUNCTION:  DiPOVideoMsgBase::DiPOVideoMsgBase()
 ***************************************************************************/
DiPOVideoMsgBase::DiPOVideoMsgBase(): m_u32DeviceHandle(0)
{
	vSetServiceID(e8_DIPO_WRAPPER_VIDEO);
}

/***************************************************************************
 ** FUNCTION:  DiPOVideoMsgBase::u32GetDeviceHandle()
 ***************************************************************************/
t_U32 DiPOVideoMsgBase::u32GetDeviceHandle()
{
   return m_u32DeviceHandle;
}
/***************************************************************************
 ** FUNCTION:  DiPOVideoMsgBase::vSetDeviceHandle()
 ***************************************************************************/
t_Void DiPOVideoMsgBase::vSetDeviceHandle(t_U32 u32DevHndle)
{
   m_u32DeviceHandle = u32DevHndle;
}

/***************************************************************************
** FUNCTION:  OnRequestUIMsg::OnRequestUIMsg()
***************************************************************************/
OnRequestUIMsg::OnRequestUIMsg()
{
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  DiPODeviceInfoMsg::vDispatchMsg()
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(OnRequestUIMsg, spi_tclDiPOVideoDispatcher)

/***************************************************************************
 ** FUNCTION:  DiPODeviceInfoMsg::vAllocateMsg()
 ***************************************************************************/
t_Void OnRequestUIMsg::vAllocateMsg(){}

/***************************************************************************
 ** FUNCTION:  OnRequestUIMsg::vDeAllocateMsg()
 ***************************************************************************/
t_Void OnRequestUIMsg::vDeAllocateMsg(){}


/***************************************************************************
** FUNCTION:  ProjVideoRenderingStatusMsg::ProjVideoRenderingStatusMsg()
***************************************************************************/
ProjVideoRenderingStatusMsg::ProjVideoRenderingStatusMsg():enProjRenderingStatus(e8_PROJECTION_VIDEO_RENDERING_STOPPED)
{
   vAllocateMsg();
}

/***************************************************************************
** FUNCTION:  ProjVideoRenderingStatusMsg::vDispatchMsg()
***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(ProjVideoRenderingStatusMsg, spi_tclDiPOVideoDispatcher)

/***************************************************************************
** FUNCTION:  ProjVideoRenderingStatusMsg::vAllocateMsg()
***************************************************************************/
t_Void ProjVideoRenderingStatusMsg::vAllocateMsg(){}

/***************************************************************************
** FUNCTION:  ProjVideoRenderingStatusMsg::vDeAllocateMsg()
***************************************************************************/
t_Void ProjVideoRenderingStatusMsg::vDeAllocateMsg(){}

/***************************************************************************
** FUNCTION:  VideoPlaybackStatusMsg::VideoPlaybackStatusMsg()
***************************************************************************/
VideoPlaybackStatusMsg::VideoPlaybackStatusMsg():bIsPlaybackStarted(false)
{
   vAllocateMsg();
}

/***************************************************************************
** FUNCTION:  VideoPlaybackStatusMsg::vDispatchMsg()
***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(VideoPlaybackStatusMsg, spi_tclDiPOVideoDispatcher)

/***************************************************************************
** FUNCTION:  VideoPlaybackStatusMsg::vAllocateMsg()
***************************************************************************/
t_Void VideoPlaybackStatusMsg::vAllocateMsg(){}

/***************************************************************************
** FUNCTION:  VideoPlaybackStatusMsg::vDeAllocateMsg()
***************************************************************************/
t_Void VideoPlaybackStatusMsg::vDeAllocateMsg(){}

/***************************************************************************
 ** FUNCTION:  spi_tclDiPOVideoDispatcher::spi_tclDiPOVideoDispatcher()
 ***************************************************************************/
spi_tclDiPOVideoDispatcher::spi_tclDiPOVideoDispatcher()
{
   ETG_TRACE_USR1((" spi_tclDiPOVideoDispatcher::spi_tclDiPOVideoDispatcher()"));
}

/***************************************************************************
 ** FUNCTION:  spi_tclDiPOVideoDispatcher::~spi_tclDiPOVideoDispatcher()
 ***************************************************************************/
spi_tclDiPOVideoDispatcher::~spi_tclDiPOVideoDispatcher()
{
   ETG_TRACE_USR1((" spi_tclDiPOVideoDispatcher::~spi_tclDiPOVideoDispatcher()"));
}

/***************************************************************************
 ** FUNCTION:  spi_tclDiPOVideoDispatcher::vHandleVideoMsg...
 ***************************************************************************/
t_Void spi_tclDiPOVideoDispatcher::vHandleVideoMsg(OnRequestUIMsg* poOnRequestUIMsg)const
{
   ETG_TRACE_USR1((" spi_tclDiPOVideoDispatcher::vHandleVideoMsg(spi_tclDiPOVideoDispatcher::vHandleVideoMsg))"));
   if (NULL != poOnRequestUIMsg)
   {
      CALL_REG_OBJECTS(spi_tclDiPORespVideo,
               e16DIPO_VIDEO_REGID,
               vOnRequestUI(poOnRequestUIMsg->cRequestUIURL));
   }
}

/***************************************************************************
** FUNCTION:  spi_tclDiPOVideoDispatcher::vHandleVideoMsg...
***************************************************************************/
t_Void spi_tclDiPOVideoDispatcher::vHandleVideoMsg(ProjVideoRenderingStatusMsg* poProjVideoRenderingStatusMsg)const
{
   ETG_TRACE_USR1((" spi_tclDiPOVideoDispatcher::vHandleVideoMsg(ProjVideoRenderingStatusMsg* poProjVideoRenderingStatusMsg)"));
   if (NULL != poProjVideoRenderingStatusMsg)
   {
      CALL_REG_OBJECTS(spi_tclDiPORespVideo,
         e16DIPO_VIDEO_REGID,
         vProjVideoRenderingStatus(poProjVideoRenderingStatusMsg->enProjRenderingStatus));
   }
}

/***************************************************************************
** FUNCTION:  spi_tclDiPOVideoDispatcher::vHandleVideoMsg...
***************************************************************************/
t_Void spi_tclDiPOVideoDispatcher::vHandleVideoMsg(VideoPlaybackStatusMsg* poVideoPlaybackStatusMsg)const
{
   ETG_TRACE_USR1((" spi_tclDiPOVideoDispatcher::vHandleVideoMsg(VideoPlaybackStatusMsg* poVideoPlaybackStatusMsg)"));
   if (NULL != poVideoPlaybackStatusMsg)
   {
      CALL_REG_OBJECTS(spi_tclDiPORespVideo,
         e16DIPO_VIDEO_REGID,
         vVideoPlaybackStatus(poVideoPlaybackStatusMsg->bIsPlaybackStarted));
   }
}

/////////////////////////////////////<EOF>//////////////////////////////////////////
