/***********************************************************************/
/*!
* \file  spi_tclDiPOCmdVideo.cpp
* \brief dapter class to send Video projection related to CarPlayd process.
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    dapter class to send Video projection related to CarPlayd process.
AUTHOR:         Shiva Kumar Gurija
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
09.12.2016  | Shiva Kumar Gurija    | Initial Version

\endverbatim
*************************************************************************/


/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "BaseTypes.h"
#include "SPITypes.h"
#include "IPCMessageQueue.h"
#include "DiPOTypes.h"
#include "DiPOWrapperTypes.h"
#include "spi_tclDiPOCmdVideo.h"


#include "spi_tclDiPOWrapperMsgQInterface.h"

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
   #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_DIPO
      #include "trcGenProj/Header/spi_tclDiPOCmdVideo.cpp.trc.h"
   #endif
#endif

/******************************************************************************
| typedefs (scope: module-global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/


/***************************************************************************
** FUNCTION:  spi_tclDiPOCmdVideo::spi_tclDiPOCmdVideo()
***************************************************************************/
spi_tclDiPOCmdVideo::spi_tclDiPOCmdVideo()
{
   ETG_TRACE_USR1(("spi_tclDiPOCmdVideo::spi_tclDiPOCmdVideo()"));
}

/***************************************************************************
** FUNCTION:  spi_tclDiPOCmdVideo::~spi_tclDiPOCmdVideo()
***************************************************************************/
spi_tclDiPOCmdVideo::~spi_tclDiPOCmdVideo()
{
   ETG_TRACE_USR1(("spi_tclDiPOCmdVideo::~spi_tclDiPOCmdVideo()"));
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclDiPOCmdVideo::vSetScreenConfig(const trVideoConfigData& corfrVideoConfig);
***************************************************************************/
t_Void spi_tclDiPOCmdVideo::vSetScreenConfig(const trVideoConfigData& corfrVideoConfig)
{
   ETG_TRACE_USR1(("spi_tclDiPOCmdVideo::vSetScreenConfig()"));	
   
   trDiPOVideoConfigMsg oVideoConfigMsg;
   oVideoConfigMsg.enMsgType = e8VIDEO_CONFIG_MESSAGE;
   oVideoConfigMsg.rVideoConfigData = corfrVideoConfig;
   spi_tclDiPOWrapperMsgQInterface* p_DiPOWrapperMsgQInterface = spi_tclDiPOWrapperMsgQInterface::getInstance();
   if(p_DiPOWrapperMsgQInterface)
   {
       t_Bool bMessageSentStatus = p_DiPOWrapperMsgQInterface->bWriteMsgToQ(&oVideoConfigMsg, sizeof(trDiPOVideoConfigMsg));
       ETG_TRACE_USR2(("[PARAM]:Message send status from spi_tclDiPOCmdVideo::vSetScreenConfig: %d", bMessageSentStatus));
   }
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclDiPOCmdVideo::vRequestUI(t_String szAppUrl)
***************************************************************************/
t_Void spi_tclDiPOCmdVideo::vRequestUI(t_String szAppUrl)
{
   ETG_TRACE_USR1(("spi_tclDiPOCmdVideo::vRequestUI:URL-%s",szAppUrl.c_str()));

   trRequestUIMsg oRequestUIMsg;
   oRequestUIMsg.enMsgType = e8REQUEST_UI_MESSAGE;
   strncpy(oRequestUIMsg.szAppUrl, szAppUrl.c_str(), MAX_STR_LEN);
   ETG_TRACE_USR2(("[PARAM]:spi_tclDiPOCmdVideo::vRequestUI:AppUrl-%s", oRequestUIMsg.szAppUrl));
   spi_tclDiPOWrapperMsgQInterface* p_DiPOWrapperMsgQInterface = spi_tclDiPOWrapperMsgQInterface::getInstance();
   if(p_DiPOWrapperMsgQInterface)
   {
       t_Bool bMessageSentStatus = p_DiPOWrapperMsgQInterface->bWriteMsgToQ(&oRequestUIMsg, sizeof(trRequestUIMsg));
       ETG_TRACE_USR2(("[PARAM]:Message send status from spi_tclDiPOCmdVideo::vRequestUI: %d", bMessageSentStatus));
   }
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclDiPOCmdVideo::vSetVehicleMode(tenVehicleConfiguration enVehicleConfig)
***************************************************************************/
t_Void spi_tclDiPOCmdVideo::vSetVehicleMode(tenVehicleConfiguration enVehicleConfig)
{
   ETG_TRACE_USR1(("spi_tclDiPOCmdVideo::vSetVehicleMode:VehicleConfig-%d",enVehicleConfig));

   trVehicleModeInfoMsg oVehicleModeMsg;
   oVehicleModeMsg.enMsgType = e8VEHICLE_MODE_MESSAGE;
   oVehicleModeMsg.enVehicleConfig = enVehicleConfig;
   spi_tclDiPOWrapperMsgQInterface* p_DiPOWrapperMsgQInterface = spi_tclDiPOWrapperMsgQInterface::getInstance();
   if(p_DiPOWrapperMsgQInterface)
   {
       t_Bool bMessageSentStatus = p_DiPOWrapperMsgQInterface->bWriteMsgToQ(&oVehicleModeMsg, sizeof(trVehicleModeInfoMsg));
       ETG_TRACE_USR2(("[PARAM]:Message send status from spi_tclDiPOCmdVideo::vSetVehicleConfig:%d", bMessageSentStatus));
   }
}
	
/***************************************************************************
** FUNCTION:  t_Void spi_tclDiPOCmdVideo::vSetFeatureResrictions(...
***************************************************************************/
t_Void spi_tclDiPOCmdVideo::vSetFeatureResrictions(t_U8 u8ParkModeRestrictions, 
                                                   t_U8 u8DriveModeRestrictions)
{
   ETG_TRACE_USR1(("spi_tclDiPOCmdVideo::vSetFeatureResrictions:Park Mode restrictions:%d, Drive Mode restrictions:%d",
   u8ParkModeRestrictions, u8DriveModeRestrictions));

   //@note - u8ParkModeRestrictions is not used. currently Park Mode feature restrictions are not set on CarPlayd.
   SPI_INTENTIONALLY_UNUSED(u8ParkModeRestrictions);
   
   trRestrictionsUpdateMsg oRestrictionsUpdateMsg;
   oRestrictionsUpdateMsg.enMsgType = e8RESTRICTIONS_UPDATE_MESSAGE;
   oRestrictionsUpdateMsg.u8DriveRestrictionInfo = u8DriveModeRestrictions;
   spi_tclDiPOWrapperMsgQInterface* p_DiPOWrapperMsgQInterface = spi_tclDiPOWrapperMsgQInterface::getInstance();
   if(p_DiPOWrapperMsgQInterface)
   {
       t_Bool bMessageSentStatus = p_DiPOWrapperMsgQInterface->bWriteMsgToQ(&oRestrictionsUpdateMsg, sizeof(trRestrictionsUpdateMsg));
       ETG_TRACE_USR2(("[PARAM]:vSetFeatureRestrictions - Message send status from vSetFeatureRestrictions: %d",
               ETG_ENUM(BOOL,bMessageSentStatus)));
   }
}
	
/***************************************************************************
 ** FUNCTION:  t_Void spi_tclDiPOCmdVideo::vSetNativeVideoRenderingStatus(...
***************************************************************************/
t_Void spi_tclDiPOCmdVideo::vSetNativeVideoRenderingStatus(tenNativeVideoRenderingStatus enNativeVideoRenderingStatus)
{
   ETG_TRACE_USR1(("spi_tclDiPOCmdVideo::vSetNativeVideoRenderingStatus:Native Video rendering status:%d",
            ETG_ENUM(NATIVE_VIDEO_RENDERING_STATUS,enNativeVideoRenderingStatus)));

   trNativeVideoRenderingStatusMsg orNativeVideoRenderingStatusMsg;
   orNativeVideoRenderingStatusMsg.enMsgType = e8NATIVEVIDEORENDERING_STATUS_MESSAGE;
   orNativeVideoRenderingStatusMsg.enNativeVideoRenderingStatus = enNativeVideoRenderingStatus;
   spi_tclDiPOWrapperMsgQInterface* p_DiPOWrapperMsgQInterface = spi_tclDiPOWrapperMsgQInterface::getInstance();
   if(p_DiPOWrapperMsgQInterface)
   {
       t_Bool bMessageSentStatus = p_DiPOWrapperMsgQInterface->bWriteMsgToQ(&orNativeVideoRenderingStatusMsg, sizeof(trNativeVideoRenderingStatusMsg));
       ETG_TRACE_USR2(("[PARAM]:vSetNativeVideoRenderingStatus - Message send status from vSetNativeVideoRenderingStatus: %d",
               ETG_ENUM(BOOL,bMessageSentStatus)));
   }
}


/////////////////////////////////////<EOF>//////////////////////////////////////////
