/***********************************************************************/
/*!
* \file  spi_tclDiPORespVideo.h
* \brief DiPO Video Output Interface
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    DiPO Discoverer Output Interface
AUTHOR:         Shiva Kumar Gurija
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
19.12.2016  | Shiva Kumar Gurija    | Initial Version

\endverbatim
*************************************************************************/
#ifndef _SPI_TCLDIPORESPVIDEO_H_
#define _SPI_TCLDIPORESPVIDEO_H_


/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "RespBase.h"
#include "RespRegister.h"
#include "SPITypes.h"
#include "DiPOTypes.h"

/******************************************************************************
| typedefs (scope: module-global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/


/****************************************************************************/
/*!
* \class spi_tclDiPORespVideo
* \brief DiPO Video Output Interface
*
* It provides an interface to SPI, To register for the Video
* status updates and updates all the registered clients, whenever there is
* an update.
*
****************************************************************************/
class spi_tclDiPORespVideo:public RespBase
{
public:

   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  spi_tclDiPORespVideo::spi_tclDiPORespVideo()
   ***************************************************************************/
   /*!
   * \fn      spi_tclDiPORespVideo()
   * \brief   Constructor
   * \sa      ~spi_tclDiPORespVideo()
   **************************************************************************/
   spi_tclDiPORespVideo():RespBase(e16DIPO_VIDEO_REGID){}

   /***************************************************************************
   ** FUNCTION:  spi_tclDiPORespVideo::~spi_tclDiPORespVideo()
   ***************************************************************************/
   /*!
   * \fn      virtual ~spi_tclDiPORespVideo()
   * \brief   Destructor
   * \param   t_Void
   * \sa      spi_tclDiPORespVideo(RegID enRegId)
   **************************************************************************/
   virtual ~spi_tclDiPORespVideo(){}

   /***************************************************************************
   ** FUNCTION: t_Void spi_tclDiPORespVideo::vOnRequestUI(t_String szRequestUIURL)
   ***************************************************************************/
   /*!
   * \fn      t_Void vOnRequestUI(t_String szRequestUIURL)
   * \brief   Method to update the notification from Phone to switch to native UI
   * \param   szRequestUIURL : [IN] Request UI URL.
   * \retval  t_Void
   ***************************************************************************/
   virtual t_Void vOnRequestUI(t_String /*szRequestUIURL*/) {}

   /***************************************************************************
   ** FUNCTION: t_Void spi_tclDiPORespVideo::vProjVideoRenderingStatus(...
   ***************************************************************************/
   /*!
   * \fn      t_Void vProjVideoRenderingStatus(tenProjVideoRenderingStatus enProjRenderingStatus)
   * \brief   Method to update the projection video rendering status update
   * *        Projection stopped update from Phone.stop in IVideoAdapter.
   * \param   enProjRenderingStatus : [IN] CarPlay projection status
   * \retval  t_Void
   ***************************************************************************/
   virtual t_Void vProjVideoRenderingStatus(tenProjVideoRenderingStatus /*enProjRenderingStatus*/){}

   /***************************************************************************
   ** FUNCTION: t_Void spi_tclDiPORespVideo::vVideoPlaybackStatus(...
   ***************************************************************************/
   /*!
   * \fn      t_Void vVideoPlaybackStatus(t_Bool bIsPlaybackStarted)
   * \brief   Method to update the projection video rendering status update
   * *        Projection started update from Phone. (VideoPlaybackstarted in IcontrolAdapter)
   * \param   bIsPlaybackStarted : [IN] TRUE - CarPlay projection started
   * \retval  t_Void
   ***************************************************************************/
   virtual t_Void vVideoPlaybackStatus(t_Bool /*bIsPlaybackStarted*/){}

   /***************************************************************************
   ****************************END OF PUBLIC***********************************
   ***************************************************************************/

protected:

   /***************************************************************************
   *********************************PROTECTED**********************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  spi_tclDiPORespVideo::spi_tclDiPORespVideo()
   ***************************************************************************/
   /*!
   * \fn      spi_tclDiPORespVideo(const spi_tclDiPORespVideo& corfoSrc))
   * \brief   Parameterized Constructor
   * \param   corfoSrc : [IN] reference to source data interface object
   * \sa      spi_tclDiPORespVideo(RegID enRegId)
   **************************************************************************/
   spi_tclDiPORespVideo(const spi_tclDiPORespVideo& corfoSrc);

   /***************************************************************************
   ** FUNCTION:  spi_tclDiPORespVideo& operator=( const  spi_tclDiPO...
   ***************************************************************************/
   /*!
   * \fn      spi_tclDiPORespVideo& operator=(const spi_tclDiPORespVideo& corfoSrc))
   * \brief   Assignment operator
   * \param   corfoSrc : [IN] reference to source data interface object
   * \retval
   * \sa      spi_tclDiPORespVideo(const spi_tclDiPORespVideo& otrSrc)
   ***************************************************************************/
   spi_tclDiPORespVideo& operator=(const spi_tclDiPORespVideo& corfoSrc);


   /***************************************************************************
   ****************************END OF PROTECTED********************************
   ***************************************************************************/

private:

   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/


   /***************************************************************************
   ****************************END OF PRIVATE *********************************
   ***************************************************************************/

};


#endif //_SPI_TCLDIPORESPVIDEO_H_

/////////////////////////////////////<EOF>//////////////////////////////////////////

