
/***********************************************************************/
/*!
* \file  spi_tclDiPOCmdVideo.h
* \brief Adapter class to send Video projection related to CarPlayd process.
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Adapter class to send Video projection related to CarPlayd process.
AUTHOR:         Shiva Kumar Gurija
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
09.12.2016  | Shiva Kumar Gurija    | Initial Version

\endverbatim
*************************************************************************/
#ifndef _SPI_TCLDIPOCMDVIDEO_H_
#define _SPI_TCLDIPOCMDVIDEO_H_


/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/****************************************************************************/
/*!
* \class spi_tclDiPOCmdVideo
* \brief Adapter class to send Video projection related to CarPlayd process.
****************************************************************************/
class spi_tclDiPOCmdVideo
{

public:

    /***************************************************************************
    *********************************PUBLIC*************************************
    ***************************************************************************/

    /***************************************************************************
    ** FUNCTION:  spi_tclDiPOCmdVideo::spi_tclDiPOCmdVideo()
    ***************************************************************************/
    /*!
    * \fn      spi_tclDiPOCmdVideo()
    * \brief   Default Constructor
    * \param   t_Void
    * \sa      ~spi_tclDiPOCmdVideo()
    **************************************************************************/
    spi_tclDiPOCmdVideo();

    /***************************************************************************
    ** FUNCTION:  spi_tclDiPOCmdVideo::~spi_tclDiPOCmdVideo()
    ***************************************************************************/
    /*!
    * \fn      ~spi_tclDiPOCmdVideo()
    * \brief   Destructor
    * \param   t_Void
    * \sa      spi_tclDiPOCmdVideo()
    **************************************************************************/
    ~spi_tclDiPOCmdVideo();

    /***************************************************************************
    ** FUNCTION:  t_Void spi_tclDiPOCmdVideo::vSetScreenConfig(const trVideoConfigData& corfrVideoConfig)
    ***************************************************************************/
    /*!
    * \fn      t_Void vSetScreenConfig(const trVideoConfigData& corfrVideoConfig)
    * \brief   Adapter Interface to set the screen configurations for CarPlay session
	* \param   corfrVideoConfig : [IN] Screen attributes
    * \retval  t_Void
    **************************************************************************/	
    t_Void vSetScreenConfig(const trVideoConfigData& corfrVideoConfig);
	
	/***************************************************************************
    ** FUNCTION:  t_Void spi_tclDiPOCmdVideo::vRequestUI(t_String szAppUrl)
    ***************************************************************************/
    /*!
    * \fn      t_Void vRequestUI(t_String szAppUrl)
    * \brief   Adapter Interface to launch an application on the iPhone
	* \param   szAppUrl : [IN] Applictaion URL
    * \retval  t_Void
    **************************************************************************/	
    t_Void vRequestUI(t_String szAppUrl);
	
	/***************************************************************************
    ** FUNCTION:  t_Void spi_tclDiPOCmdVideo::vSetVehicleMode(tenVehicleConfiguration enVehicleConfig)
    ***************************************************************************/
    /*!
    * \fn      t_Void vSetVehicleMode(tenVehicleConfiguration enVehicleConfig)
    * \brief   Adapter Interface to set the vehicle mode (Park/Drive)
	* \param   enVehicleConfig : [IN] Vehicle configuration
    * \retval  t_Void
    **************************************************************************/	
    t_Void vSetVehicleMode(tenVehicleConfiguration enVehicleConfig);
	
	/***************************************************************************
    ** FUNCTION:  t_Void spi_tclDiPOCmdVideo::vSetFeatureResrictions(...
    ***************************************************************************/
    /*!
    * \fn      t_Void vSetFeatureResrictions(t_U8 u8ParkModeRestrictions, 
	*                                        t_U8 u8DriveModeRestrictions
    * \brief   Adapter Interface to set the feature restrictions based on driving status
	* \param   u8ParkModeRestrictions : [IN] Feature restrictions to be enabled in Park mode
	* \param   u8DriveModeRestrictions : [IN] Feature restrictions to be enabled in Drive mode
    * \retval  t_Void
    **************************************************************************/	
    t_Void vSetFeatureResrictions(t_U8 u8ParkModeRestrictions, t_U8 u8DriveModeRestrictions);

    /***************************************************************************
     ** FUNCTION:  t_Void spi_tclDiPOCmdVideo::vSetNativeVideoRenderingStatus(...
     ***************************************************************************/
    /*!
     * \fn      t_Void vSetNativeVideoRenderingStatus(tenNativeVideoRenderingStatus enNativeVideoRenderingStatus)
     * \brief   Adapter Interface to set the native video rendering status
     * \param   enNativeVideoRenderingStatus : [IN] TRUE - Native Video rendering started
     * \retval  t_Void
     **************************************************************************/
     t_Void vSetNativeVideoRenderingStatus(tenNativeVideoRenderingStatus enNativeVideoRenderingStatus);


    /***************************************************************************
    ****************************END OF PUBLIC***********************************
    ***************************************************************************/

protected:

    /***************************************************************************
    *********************************PROTECTED**********************************
    ***************************************************************************/

    /***************************************************************************
    ** FUNCTION:  spi_tclDiPOCmdVideo(const spi_tclDiPOCmdVideo...
    ***************************************************************************/
    /*!
    * \fn      spi_tclDiPOCmdVideo(const spi_tclDiPOCmdVideo& corfoSrc)
    * \brief   Copy constructor - Do not allow the creation of copy constructor
    * \param   corfoSrc : [IN] reference to source data interface object
    * \sa      spi_tclDiPOCmdVideo()
    ***************************************************************************/
    spi_tclDiPOCmdVideo(const spi_tclDiPOCmdVideo& corfoSrc);


    /***************************************************************************
    ** FUNCTION:  spi_tclDiPOCmdVideo& operator=( const spi_tclDiP...
    ***************************************************************************/
    /*!
    * \fn      spi_tclDiPOCmdVideo& operator=(const spi_tclDiPOCmdVideo& corfoSrc))
    * \brief   Assignment operator
    * \param   corfoSrc : [IN] reference to source data interface object
    * \sa      spi_tclDiPOCmdVideo(const spi_tclDiPOCmdVideo& otrSrc)
    ***************************************************************************/
    spi_tclDiPOCmdVideo& operator=(const spi_tclDiPOCmdVideo& corfoSrc);


    /***************************************************************************
    ****************************END OF PROTECTED********************************
    ***************************************************************************/

private:

    /***************************************************************************
    *********************************PRIVATE************************************
    ***************************************************************************/


    /***************************************************************************
    ****************************END OF PRIVATE *********************************
    ***************************************************************************/


}; //class spi_tclDiPOCmdVideo

#endif //_SPI_TCLDIPOCMDVIDEO_H_

/////////////////////////////////////<EOF>//////////////////////////////////////////
