/***********************************************************************/
/*!
* \file  spi_tclDiPOSessionDispatcher.h
* \brief Message Dispatcher for Session Messages. 
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Message Dispatcher for Session Messages. 
AUTHOR:         Shiva Kumar Gurija
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
09.12.2016  | Shiva Kumar Gurija    | Initial Version

\endverbatim
*************************************************************************/
#ifndef _SPI_TCLDIPOSESSIONDISPATCHER_H_
#define _SPI_TCLDIPOSESSIONDISPATCHER_H_

/***************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|--------------------------------------------------------------------------*/
#include "DiPOTypes.h"
#include "DiPOWrapperTypes.h"
class spi_tclDiPOSessionDispatcher;

/******************************************************************************
| typedefs (scope: module-global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/****************************************************************************/
/*!
 * \class DiPOSessionMsgBase
 * \brief Base Message type for all Session messages
 ****************************************************************************/
class DiPOSessionMsgBase: public trMsgBase
{
   public:
      /***************************************************************************
       ** FUNCTION:  DiPOSessionMsgBase::DiPOSessionMsgBase
       ***************************************************************************/
      /*!
       * \fn      DiPOSessionMsgBase()
       * \brief   Default constructor
       **************************************************************************/
      DiPOSessionMsgBase();

      /***************************************************************************
       ** FUNCTION:  DiPOSessionMsgBase::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclDiPOSessionDispatcher* poSessionDispatcher)
       * \brief   Pure virtual function to be overridden by inherited classes for
       *          dispatching the message
       * \param poSessionDispatcher: pointer to Session Message Dispatcher
       **************************************************************************/
      virtual t_Void vDispatchMsg(spi_tclDiPOSessionDispatcher* poSessionDispatcher) = 0;

      /***************************************************************************
       ** FUNCTION:  DiPOSessionMsgBase::~DiPOSessionMsgBase
       ***************************************************************************/
      /*!
       * \fn      ~DiPOSessionMsgBase()
       * \brief   Destructor
       **************************************************************************/
      virtual ~DiPOSessionMsgBase()
      {

      }

      /***************************************************************************
       ** FUNCTION:  DiPOSessionMsgBase::u32GetDeviceHandle
       ***************************************************************************/
      /*!
       * \fn      u32GetDeviceHandle()
       * \brief   returns the device handle
       **************************************************************************/
      virtual t_U32 u32GetDeviceHandle();

      /***************************************************************************
       ** FUNCTION:  DiPOSessionMsgBase::vSetDeviceHandle
       ***************************************************************************/
      /*!
       * \fn      vSetDeviceHandle()
       * \brief   sets the device handle
       **************************************************************************/
      virtual t_Void vSetDeviceHandle(t_U32 u32DevHndle);

   private:
      t_U32 m_u32DeviceHandle;
};

/****************************************************************************/
/*!
 * \class DiPOSessionMsg
 * \brief Session information message
 ****************************************************************************/
class DiPOSessionMsg: public DiPOSessionMsgBase
{
   public:
   
    tenDiPOSessionState enDiPOSessionState;
	tenDiPOSessionTransport enSessionTransport;
	char szSessionIPAddress[DIPO_MAX_STR_LEN];

      /***************************************************************************
       ** FUNCTION:  DiPOSessionMsg::DiPOSessionMsg()
       ***************************************************************************/
      /*!
       * \fn      DiPOSessionMsg()
       * \brief   Default constructor
       **************************************************************************/
      DiPOSessionMsg();

      /***************************************************************************
       ** FUNCTION:  DiPOSessionMsg::~DiPOSessionMsg()
       ***************************************************************************/
      /*!
       * \fn      ~DiPOSessionMsg()
       * \brief   DiPOSessionMsg
       **************************************************************************/
      virtual ~DiPOSessionMsg() {}

      /***************************************************************************
       ** FUNCTION:  DiPOSessionMsg::vDispatchMsg()
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclDiPOSessionDispatcher* poSessionDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
       * \param   poSessionDispatcher: pointer to Session Message Dispatcher
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclDiPOSessionDispatcher* poSessionDispatcher);

      /***************************************************************************
       ** FUNCTION:  DiPOSessionMsg::vAllocateMsg()
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       **************************************************************************/
      t_Void vAllocateMsg();

      /***************************************************************************
       ** FUNCTION:  DiPOSessionMsg::vDeAllocateMsg()
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       **************************************************************************/
      t_Void vDeAllocateMsg();
};


/****************************************************************************/
/*!
 * \class spi_tclDiPOSessionDispatcher
 * \brief Message Dispatcher for Session Messages.implemented using
 *        double dispatch mechanism
 ****************************************************************************/
class spi_tclDiPOSessionDispatcher
{
   public:
      /***************************************************************************
       ** FUNCTION:  spi_tclDiPOSessionDispatcher::spi_tclDiPOSessionDispatcher
       ***************************************************************************/
      /*!
       * \fn      spi_tclDiPOSessionDispatcher()
       * \brief   Default constructor
       **************************************************************************/
      spi_tclDiPOSessionDispatcher();

      /***************************************************************************
       ** FUNCTION:  spi_tclDiPOSessionDispatcher::~spi_tclDiPOSessionDispatcher
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclDiPOSessionDispatcher()
       * \brief   Destructor
       **************************************************************************/
      ~spi_tclDiPOSessionDispatcher();

      /***************************************************************************
       ** FUNCTION:  spi_tclMLVncDAPDispatcher::vHandleSessionMsg(DiPOSessionMsg* poSessionMsg)
       ***************************************************************************/
      /*!
       * \fn      vHandleSessionMsg(DiPOSessionMsg* poSessionMsg) const
       * \brief   Handles Messages of DiPOSessionMsg type
       * \param   poSessionMsg : pointer to DiPOSessionMsg
       **************************************************************************/
      t_Void vHandleSessionMsg(DiPOSessionMsg* poSessionMsg)const;     
};

#endif // _SPI_TCLDIPOSESSIONDISPATCHER_H_

/////////////////////////////////////<EOF>//////////////////////////////////////////
