/***********************************************************************/
/*!
* \file  spi_tclDiPORespSession.h
* \brief DiPO Session Output Interface
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    DiPO Session Output Interface
AUTHOR:         Shiva Kumar Gurija
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
09.03.2016  | Shiva Kumar Gurija    | Initial Version

\endverbatim
*************************************************************************/
#ifndef _SPI_TCLDIPORESPSESSION_H_
#define _SPI_TCLDIPORESPSESSION_H_


/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "RespBase.h"
#include "RespRegister.h"
#include "DiPOTypes.h"

/******************************************************************************
| typedefs (scope: module-global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/


/****************************************************************************/
/*!
* \class spi_tclDiPORespSession
* \brief DiPO Session Output Interface
*
* It provides an interface to SPI, To register for the Session
* status updates and updates all the registered clients, whenever there is
* an update.
*
****************************************************************************/
class spi_tclDiPORespSession:public RespBase
{
public:

   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  spi_tclDiPORespSession::spi_tclDiPORespSession()
   ***************************************************************************/
   /*!
   * \fn      spi_tclDiPORespSession()
   * \brief   Constructor
   * \sa      ~spi_tclDiPORespSession()
   **************************************************************************/
   spi_tclDiPORespSession():RespBase(e16DIPO_SESSION_REGID){}

   /***************************************************************************
   ** FUNCTION:  spi_tclDiPORespSession::~spi_tclDiPORespSession()
   ***************************************************************************/
   /*!
   * \fn      virtual ~spi_tclDiPORespSession()
   * \brief   Destructor
   * \param   t_Void
   * \sa      spi_tclDiPORespSession(RegID enRegId)
   **************************************************************************/
   virtual ~spi_tclDiPORespSession(){}

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclDiPORespSession::vOnSessionMsg(...
   ***************************************************************************/
   /*!
   * \fn      virtual t_Void vOnSessionMsg(tenDiPOSessionState enDiPOSessionState,
   *                                       tenDiPOSessionTransport enSessionTransport)
   * \brief   To Post the session message to SPI, when the session state changes.
   * \param   enDiPOSessionState : [IN] Session State : Session Started,Session_Ended,
   *                                                    CarPlayd_PlugIn_Loaded or UnLoaded.
   * \param   enSessionTransport : [IN] Session is started over USB Transport or WiFi
   *                                    Applicable, only when SessionState is Session Started/ended.
   * \param   szSessionIPAddress : [IN] IP Address of the active carplay device.
   *                                    used, only if the Session Transport is WiFi
   * \retval  t_Void
   ***************************************************************************/
   virtual t_Void vOnSessionMsg(tenDiPOSessionState /*enDiPOSessionState*/,
                                tenDiPOSessionTransport /*enSessionTransport*/,
                                t_String /*szSessionIPAddress*/){}

   /***************************************************************************
   ****************************END OF PUBLIC***********************************
   ***************************************************************************/

protected:

   /***************************************************************************
   *********************************PROTECTED**********************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  spi_tclDiPORespSession::spi_tclDiPORespSession()
   ***************************************************************************/
   /*!
   * \fn      spi_tclDiPORespSession(const spi_tclDiPORespSession& corfoSrc))
   * \brief   Parameterized Constructor
   * \param   corfoSrc : [IN] reference to source data interface object
   * \sa      spi_tclDiPORespSession(RegID enRegId)
   **************************************************************************/
   spi_tclDiPORespSession(const spi_tclDiPORespSession& corfoSrc);

   /***************************************************************************
   ** FUNCTION:  spi_tclDiPORespSession& operator=( const  spi_tclDiPO...
   ***************************************************************************/
   /*!
   * \fn      spi_tclDiPORespSession& operator=(const spi_tclDiPORespSession& corfoSrc))
   * \brief   Assignment operator
   * \param   corfoSrc : [IN] reference to source data interface object
   * \retval
   * \sa      spi_tclDiPORespSession(const spi_tclDiPORespSession& otrSrc)
   ***************************************************************************/
   spi_tclDiPORespSession& operator=(const spi_tclDiPORespSession& corfoSrc);


   /***************************************************************************
   ****************************END OF PROTECTED********************************
   ***************************************************************************/

private:

   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/


   /***************************************************************************
   ****************************END OF PRIVATE *********************************
   ***************************************************************************/

};


#endif //_SPI_TCLDIPORESPSESSION_H_

/////////////////////////////////////<EOF>//////////////////////////////////////////

