/***********************************************************************/
/*!
* \file  spi_tclDiPORsrcMngrDispatcher.h
* \brief Message Dispatcher for Resource Manager Messages. 
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Message Dispatcher for Resource Manager Messages. 
AUTHOR:         Shiva Kumar Gurija
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
27.06.2017  | Shiva Kumar Gurija    | Initial Version

\endverbatim
*************************************************************************/
#ifndef _SPI_TCLDIPORSRCMNGRDISPATCHER_H_
#define _SPI_TCLDIPORSRCMNGRDISPATCHER_H_

/***************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|--------------------------------------------------------------------------*/
#include "DiPOTypes.h"
#include "DiPOWrapperTypes.h"
class spi_tclDiPORsrcMngrDispatcher;

/******************************************************************************
| typedefs (scope: module-global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/****************************************************************************/
/*!
 * \class DiPORsrcMngrMsgBase
 * \brief Base Message type for all Resource Manager messages
 ****************************************************************************/
class DiPORsrcMngrMsgBase: public trMsgBase
{
   public:
      /***************************************************************************
       ** FUNCTION:  DiPORsrcMngrMsgBase::DiPORsrcMngrMsgBase
       ***************************************************************************/
      /*!
       * \fn      DiPORsrcMngrMsgBase()
       * \brief   Default constructor
       **************************************************************************/
      DiPORsrcMngrMsgBase();

      /***************************************************************************
       ** FUNCTION:  DiPORsrcMngrMsgBase::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclDiPORsrcMngrDispatcher* poDiscDispatcher)
       * \brief   Pure virtual function to be overridden by inherited classes for
       *          dispatching the message
       * \param poDiscDispatcher: pointer to Resource Manager Message Dispatcher
       **************************************************************************/
      virtual t_Void vDispatchMsg(spi_tclDiPORsrcMngrDispatcher* poDiscDispatcher) = 0;

      /***************************************************************************
       ** FUNCTION:  DiPORsrcMngrMsgBase::~DiPORsrcMngrMsgBase
       ***************************************************************************/
      /*!
       * \fn      ~DiPORsrcMngrMsgBase()
       * \brief   Destructor
       **************************************************************************/
      virtual ~DiPORsrcMngrMsgBase()
      {

      }

      /***************************************************************************
       ** FUNCTION:  DiPORsrcMngrMsgBase::u32GetDeviceHandle
       ***************************************************************************/
      /*!
       * \fn      u32GetDeviceHandle()
       * \brief   returns the device handle
       **************************************************************************/
      virtual t_U32 u32GetDeviceHandle();

      /***************************************************************************
       ** FUNCTION:  DiPORsrcMngrMsgBase::vSetDeviceHandle
       ***************************************************************************/
      /*!
       * \fn      vSetDeviceHandle()
       * \brief   sets the device handle
       **************************************************************************/
      virtual t_Void vSetDeviceHandle(t_U32 u32DevHndle);

   private:
      t_U32 m_u32DeviceHandle;
};

/****************************************************************************/
/*!
 * \class ModesChangedMsg
 * \brief OnModesChanged update from Phone
 ****************************************************************************/
class ModesChangedMsg: public DiPORsrcMngrMsgBase
{
   public:
   
    trDiPOModeState *prDiPOModeState;

      /***************************************************************************
       ** FUNCTION:  ModesChangedMsg::ModesChangedMsg()
       ***************************************************************************/
      /*!
       * \fn      ModesChangedMsg()
       * \brief   Default constructor
       **************************************************************************/
      ModesChangedMsg();

      /***************************************************************************
       ** FUNCTION:  ModesChangedMsg::~ModesChangedMsg()
       ***************************************************************************/
      /*!
       * \fn      ~ModesChangedMsg()
       * \brief   ModesChangedMsg
       **************************************************************************/
      virtual ~ModesChangedMsg() {}

      /***************************************************************************
       ** FUNCTION:  ModesChangedMsg::vDispatchMsg()
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclDiPORsrcMngrDispatcher* poRsrcMngrDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
       * \param   poRsrcMngrDispatcher: pointer to Resouce Manager Message Dispatcher
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclDiPORsrcMngrDispatcher* poRsrcMngrDispatcher);

      /***************************************************************************
       ** FUNCTION:  ModesChangedMsg::vAllocateMsg()
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       **************************************************************************/
      t_Void vAllocateMsg();

      /***************************************************************************
       ** FUNCTION:  ModesChangedMsg::vDeAllocateMsg()
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       **************************************************************************/
      t_Void vDeAllocateMsg();
};


/****************************************************************************/
/*!
 * \class spi_tclDiPORsrcMngrDispatcher
 * \brief Message Dispatcher for Resource Manager Messages.implemented using
 *        double dispatch mechanism
 ****************************************************************************/
class spi_tclDiPORsrcMngrDispatcher
{
   public:
      /***************************************************************************
       ** FUNCTION:  spi_tclDiPORsrcMngrDispatcher::spi_tclDiPORsrcMngrDispatcher
       ***************************************************************************/
      /*!
       * \fn      spi_tclDiPORsrcMngrDispatcher()
       * \brief   Default constructor
       **************************************************************************/
      spi_tclDiPORsrcMngrDispatcher();

      /***************************************************************************
       ** FUNCTION:  spi_tclDiPORsrcMngrDispatcher::~spi_tclDiPORsrcMngrDispatcher
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclDiPORsrcMngrDispatcher()
       * \brief   Destructor
       **************************************************************************/
      ~spi_tclDiPORsrcMngrDispatcher();

      /***************************************************************************
       ** FUNCTION:  spi_tclDiPORsrcMngrDispatcher::vHandleRsrcMngrMsg(...
       ***************************************************************************/
      /*!
       * \fn      vHandleRsrcMngrMsg(ModesChangedMsg* poModesChangedMsg) const
       * \brief   Handles Messages of ModesChangedMsg type
       * \param   poModesChangedMsg : pointer to ModesChangedMsg
       **************************************************************************/
      t_Void vHandleRsrcMngrMsg(ModesChangedMsg* poModesChangedMsg)const;
      
};

#endif // _SPI_TCLDIPORSRCMNGRDISPATCHER_H_

/////////////////////////////////////<EOF>//////////////////////////////////////////
