/***********************************************************************/
/*!
* \file  spi_tclDiPODiscovererDispatcher.cpp
* \brief Message Dispatcher for Discoverer Messages.
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Message Dispatcher for Discoverer Messages.   
AUTHOR:         Shiva Kumar Gurija
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
09.12.2016  | Shiva Kumar Gurija    | Initial Version

\endverbatim
*************************************************************************/


/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/
#include "SPITypes.h"
#include "DiPOTypes.h"
#include "StringHandler.h"
#include "RespRegister.h"
#include "spi_tclDiPODiscovererDispatcher.h"
#include "spi_tclDiPORespDiscoverer.h"

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_MSGQTHREADER
#include "trcGenProj/Header/spi_tclDiPODiscovererDispatcher.cpp.trc.h"
#endif
#endif

/******************************************************************************
| typedefs (scope: module-global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: local)
|----------------------------------------------------------------------------*/
#define DEFINE_DISPATCH_MESSAGE_FUNCTION(COMMAND,DISPATCHER)\
t_Void COMMAND::vDispatchMsg(DISPATCHER* poDispatcher)      \
{                                                           \
   if (NULL != poDispatcher)                                \
   {                                                        \
      poDispatcher->vHandleDiscoveryMsg(this);              \
   }                                                        \
   vDeAllocateMsg();                                        \
}                                                           \

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/***************************************************************************
 ** FUNCTION:  DiPODiscovererMsgBase::DiPODiscovererMsgBase()
 ***************************************************************************/
DiPODiscovererMsgBase::DiPODiscovererMsgBase(): m_u32DeviceHandle(0)
{
	vSetServiceID(e8_DIPO_WRAPPER_DISC);
}

/***************************************************************************
 ** FUNCTION:  DiPODiscovererMsgBase::u32GetDeviceHandle()
 ***************************************************************************/
t_U32 DiPODiscovererMsgBase::u32GetDeviceHandle()
{
   return m_u32DeviceHandle;
}
/***************************************************************************
 ** FUNCTION:  DiPODiscovererMsgBase::vSetDeviceHandle()
 ***************************************************************************/
t_Void DiPODiscovererMsgBase::vSetDeviceHandle(t_U32 u32DevHndle)
{
   m_u32DeviceHandle = u32DevHndle;
}

/***************************************************************************
 ** FUNCTION:  DiPODeviceInfoMsg::DiPODeviceInfoMsg()
 ***************************************************************************/
DiPODeviceInfoMsg::DiPODeviceInfoMsg():prDeviceInfo(NULL),bIsDeviceConnected(false)
{
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  DiPODeviceInfoMsg::vDispatchMsg()
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(DiPODeviceInfoMsg, spi_tclDiPODiscovererDispatcher)

/***************************************************************************
 ** FUNCTION:  DiPODeviceInfoMsg::vAllocateMsg()
 ***************************************************************************/
t_Void DiPODeviceInfoMsg::vAllocateMsg()
{
   prDeviceInfo = new trDiPODeviceInfo;
   SPI_NORMAL_ASSERT(NULL == prDeviceInfo);
}

/***************************************************************************
 ** FUNCTION:  DiPODeviceInfoMsg::vDeAllocateMsg()
 ***************************************************************************/
t_Void DiPODeviceInfoMsg::vDeAllocateMsg()
{
   RELEASE_MEM(prDeviceInfo);
}


/***************************************************************************
** FUNCTION:  ConnectDeviceRespMsg::ConnectDeviceRespMsg()
***************************************************************************/
ConnectDeviceRespMsg::ConnectDeviceRespMsg() :bConnectSucceeded(false)
{
   memset(szBTMACAddress, '\0', DIPO_MAX_STR_LEN);
   vAllocateMsg();
}

/***************************************************************************
** FUNCTION:  DiPODeviceInfoMsg::vDispatchMsg()
***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(ConnectDeviceRespMsg, spi_tclDiPODiscovererDispatcher)

/***************************************************************************
** FUNCTION:  ConnectDeviceRespMsg::vAllocateMsg()
***************************************************************************/
t_Void ConnectDeviceRespMsg::vAllocateMsg(){}

/***************************************************************************
** FUNCTION:  ConnectDeviceRespMsg::vDeAllocateMsg()
***************************************************************************/
t_Void ConnectDeviceRespMsg::vDeAllocateMsg(){}


/***************************************************************************
** FUNCTION:  ConnectDeviceRespMsg::ConnectDeviceRespMsg()
***************************************************************************/
DisconnectDeviceRespMsg::DisconnectDeviceRespMsg() :bDisconnectSucceeded(false)
{
   memset(szBTMACAddress, '\0', DIPO_MAX_STR_LEN);
   vAllocateMsg();
}

/***************************************************************************
** FUNCTION:  DisconnectDeviceRespMsg::vDispatchMsg()
***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(DisconnectDeviceRespMsg, spi_tclDiPODiscovererDispatcher)

/***************************************************************************
** FUNCTION:  DisconnectDeviceRespMsg::vAllocateMsg()
***************************************************************************/
t_Void DisconnectDeviceRespMsg::vAllocateMsg(){}

/***************************************************************************
** FUNCTION:  DisconnectDeviceRespMsg::vDeAllocateMsg()
***************************************************************************/
t_Void DisconnectDeviceRespMsg::vDeAllocateMsg(){}

/***************************************************************************
 ** FUNCTION:  spi_tclDiPODiscovererDispatcher::spi_tclDiPODiscovererDispatcher()
 ***************************************************************************/
spi_tclDiPODiscovererDispatcher::spi_tclDiPODiscovererDispatcher()
{
   ETG_TRACE_USR1((" spi_tclDiPODiscovererDispatcher::spi_tclDiPODiscovererDispatcher()"));
}

/***************************************************************************
 ** FUNCTION:  spi_tclDiPODiscovererDispatcher::~spi_tclDiPODiscovererDispatcher()
 ***************************************************************************/
spi_tclDiPODiscovererDispatcher::~spi_tclDiPODiscovererDispatcher()
{
   ETG_TRACE_USR1((" spi_tclDiPODiscovererDispatcher::~spi_tclDiPODiscovererDispatcher()"));
}

/***************************************************************************
 ** FUNCTION:  spi_tclDiPODiscovererDispatcher::vHandleDiscoveryMsg(DiPODeviceInfoMsg* poDeviceInfoMsg)
 ***************************************************************************/
t_Void spi_tclDiPODiscovererDispatcher::vHandleDiscoveryMsg(DiPODeviceInfoMsg* poDeviceInfoMsg)const
{
   ETG_TRACE_USR1((" spi_tclDiPODiscovererDispatcher::vHandleDiscoveryMsg(DiPODeviceInfoMsg* poDeviceListMsg)"));
   if ((NULL != poDeviceInfoMsg) && (NULL != poDeviceInfoMsg->prDeviceInfo))
   {
      CALL_REG_OBJECTS(spi_tclDiPORespDiscoverer,
               e16DIPO_DISCOVERER_REGID,
               vOnDeviceUpdate(*(poDeviceInfoMsg->prDeviceInfo),poDeviceInfoMsg->bIsDeviceConnected));
   } // if (NULL != poDeviceListMsg)
}

/***************************************************************************
** FUNCTION:  spi_tclDiPODiscovererDispatcher::vHandleDiscoveryMsg(ConnectDeviceRespMsg* poDeviceInfoMsg)
***************************************************************************/
t_Void spi_tclDiPODiscovererDispatcher::vHandleDiscoveryMsg(ConnectDeviceRespMsg* poConnectDeviceRespMsg)const
{
   ETG_TRACE_USR1((" spi_tclDiPODiscovererDispatcher::vHandleDiscoveryMsg(ConnectDeviceRespMsg* poConnectDeviceRespMsg)"));
   if (NULL != poConnectDeviceRespMsg)
   {
      CALL_REG_OBJECTS(spi_tclDiPORespDiscoverer,
         e16DIPO_DISCOVERER_REGID,
         vOnConnectDeviceResp(poConnectDeviceRespMsg->szBTMACAddress, poConnectDeviceRespMsg->bConnectSucceeded));
   } // if (NULL != poDeviceListMsg)
}

/***************************************************************************
** FUNCTION:  spi_tclDiPODiscovererDispatcher::vHandleDiscoveryMsg(DisconnectDeviceRespMsg* poDeviceInfoMsg)
***************************************************************************/
t_Void spi_tclDiPODiscovererDispatcher::vHandleDiscoveryMsg(DisconnectDeviceRespMsg* poDisconnectDeviceRespMsg)const
{
   ETG_TRACE_USR1((" spi_tclDiPODiscovererDispatcher::vHandleDiscoveryMsg(DisconnectDeviceRespMsg* poDisconnectDeviceRespMsg)"));
   if (NULL != poDisconnectDeviceRespMsg)
   {
      CALL_REG_OBJECTS(spi_tclDiPORespDiscoverer,
         e16DIPO_DISCOVERER_REGID,
         vOnDisconnectDeviceResp(poDisconnectDeviceRespMsg->szBTMACAddress, poDisconnectDeviceRespMsg->bDisconnectSucceeded));
   } // if (NULL != poDeviceListMsg)
}

/////////////////////////////////////<EOF>//////////////////////////////////////////
