/***********************************************************************/
/*!
* \file  spi_tclDiPOCmdDiscoverer.cpp
* \brief Adapter class to send discovery & connectivity requests to CarPlayd process.
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Adapter class to send discovery & connectivity requests to CarPlayd process.
AUTHOR:         Shiva Kumar Gurija
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
09.12.2016  | Shiva Kumar Gurija    | Initial Version

\endverbatim
*************************************************************************/


/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "BaseTypes.h"
#include "SPITypes.h"
#include "IPCMessageQueue.h"
#include "DiPOTypes.h"
#include "DiPOWrapperTypes.h"
#include "spi_tclDiPOCmdDiscoverer.h"

#include "spi_tclDiPOWrapperMsgQInterface.h"

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
   #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_DIPO
      #include "trcGenProj/Header/spi_tclDiPOCmdDiscoverer.cpp.trc.h"
   #endif
#endif

/******************************************************************************
| typedefs (scope: module-global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/


/***************************************************************************
** FUNCTION:  spi_tclDiPOCmdDiscoverer::spi_tclDiPOCmdDiscoverer()
***************************************************************************/
spi_tclDiPOCmdDiscoverer::spi_tclDiPOCmdDiscoverer()
{
   ETG_TRACE_USR1(("spi_tclDiPOCmdDiscoverer::spi_tclDiPOCmdDiscoverer()"));
}

/***************************************************************************
** FUNCTION:  spi_tclDiPOCmdDiscoverer::~spi_tclDiPOCmdDiscoverer()
***************************************************************************/
spi_tclDiPOCmdDiscoverer::~spi_tclDiPOCmdDiscoverer()
{
   ETG_TRACE_USR1(("spi_tclDiPOCmdDiscoverer::~spi_tclDiPOCmdDiscoverer()"));
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclDiPOCmdDiscoverer::enStartDeviceDiscovery()
***************************************************************************/
t_Void spi_tclDiPOCmdDiscoverer::vStartDeviceDiscovery()
{
   ETG_TRACE_USR1(("spi_tclDiPOCmdDiscoverer::vStartDeviceDiscovery()"));

   trDeviceDiscoveryMsg oDeviceDiscoveryMsg;
   oDeviceDiscoveryMsg.bStartDeviceDiscovery = true;
   oDeviceDiscoveryMsg.enMsgType = e8DEVICE_DISCOVERY;
   spi_tclDiPOWrapperMsgQInterface* p_DiPOWrapperMsgQInterface = spi_tclDiPOWrapperMsgQInterface::getInstance();
   if(p_DiPOWrapperMsgQInterface)
   {
       p_DiPOWrapperMsgQInterface->bWriteMsgToQ(&oDeviceDiscoveryMsg, sizeof(trDeviceDiscoveryMsg));
   }
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclDiPOCmdDiscoverer::enStopDeviceDiscovery()
***************************************************************************/
t_Void spi_tclDiPOCmdDiscoverer::vStopDeviceDiscovery()
{
   ETG_TRACE_USR1(("spi_tclDiPOCmdDiscoverer::enStopDeviceDiscovery()"));

   trDeviceDiscoveryMsg oDeviceDiscoveryMsg;
   oDeviceDiscoveryMsg.bStartDeviceDiscovery = false;
   oDeviceDiscoveryMsg.enMsgType = e8DEVICE_DISCOVERY;

   spi_tclDiPOWrapperMsgQInterface* p_DiPOWrapperMsgQInterface = spi_tclDiPOWrapperMsgQInterface::getInstance();
   if(p_DiPOWrapperMsgQInterface)
   {
       p_DiPOWrapperMsgQInterface->bWriteMsgToQ(&oDeviceDiscoveryMsg, sizeof(trDeviceDiscoveryMsg));
   }
}

/**************************************************************************
* FUNCTION:  t_Void spi_tclDiPOCmdDiscoverer::vConnectDevice(t_String szBTMacAddr)
**************************************************************************/
t_Void spi_tclDiPOCmdDiscoverer::vConnectDevice(t_String szBTMacAddr)
{
   ETG_TRACE_USR1(("spi_tclDiPOCmdDiscoverer::vConnectDevice():BT MAC Address:%s",szBTMacAddr.c_str()));

   trConnectDeviceMsg oConnectDeviceMsg;
   if (szBTMacAddr.length() < DIPO_MAX_STR_LEN)
   {
       strncpy(oConnectDeviceMsg.szBTMACAddress, szBTMacAddr.c_str(), szBTMacAddr.length());
       oConnectDeviceMsg.szBTMACAddress[szBTMacAddr.length()] = '\0';
   }
   else
   {
       ETG_TRACE_ERR(("[ERR]:spi_tclDiPOCmdDiscoverer::vConnectDevice():Received BT Address seems to be invalid. Length is more than defined."));
   }
   oConnectDeviceMsg.enMsgType = e8DEVICE_CONNECT;

   spi_tclDiPOWrapperMsgQInterface* p_DiPOWrapperMsgQInterface = spi_tclDiPOWrapperMsgQInterface::getInstance();
   if(p_DiPOWrapperMsgQInterface)
   {
       p_DiPOWrapperMsgQInterface->bWriteMsgToQ(&oConnectDeviceMsg, sizeof(trConnectDeviceMsg));
   }
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclDiPOCmdDiscoverer::vDisconnectDevice(t_String szBTMacAddr)
***************************************************************************/
t_Void spi_tclDiPOCmdDiscoverer::vDisconnectDevice(t_String szBTMacAddr,
                                                  tenConnectTriggerReason enConnectTriggerReason)
{
   ETG_TRACE_USR1(("spi_tclDiPOCmdDiscoverer::vDisconnectDevice():Trigger Reason:%d,BT MAC Address:%s",
   ETG_ENUM(CONNECT_TRIGGER,enConnectTriggerReason),szBTMacAddr.c_str()));

   trDisconnectDeviceMsg oDisconnectDeviceMsg;
   if (szBTMacAddr.length() < DIPO_MAX_STR_LEN)
   {
       strncpy(oDisconnectDeviceMsg.szBTMACAddress, szBTMacAddr.c_str(), szBTMacAddr.length());
       oDisconnectDeviceMsg.szBTMACAddress[szBTMacAddr.length()] = '\0';
   }
   else
   {
       ETG_TRACE_ERR(("[ERR]:spi_tclDiPOCmdDiscoverer::vDisconnectDevice():Received BT Address seems to be invalid. Length is more than defined."));
   }
   oDisconnectDeviceMsg.enConnectTriggerReason = enConnectTriggerReason;
   oDisconnectDeviceMsg.enMsgType = e8DEVICE_DISCONNECT;
   spi_tclDiPOWrapperMsgQInterface* p_DiPOWrapperMsgQInterface = spi_tclDiPOWrapperMsgQInterface::getInstance();
   if(p_DiPOWrapperMsgQInterface)
   {
       p_DiPOWrapperMsgQInterface->bWriteMsgToQ(&oDisconnectDeviceMsg, sizeof(trDisconnectDeviceMsg));
   }
}

/////////////////////////////////////<EOF>//////////////////////////////////////////
