/***********************************************************************/
/*!
* \file  spi_tclDiPORespDiscoverer.h
* \brief DiPO Discoverer Output Interface
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    DiPO Discoverer Output Interface
AUTHOR:         Shiva Kumar Gurija
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
19.12.2016  | Shiva Kumar Gurija    | Initial Version

\endverbatim
*************************************************************************/
#ifndef _SPI_TCLDIPORESPDISCOVERER_H_
#define _SPI_TCLDIPORESPDISCOVERER_H_


/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "RespBase.h"
#include "RespRegister.h"
#include "DiPOTypes.h"

/******************************************************************************
| typedefs (scope: module-global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/


/****************************************************************************/
/*!
* \class spi_tclDiPORespDiscoverer
* \brief DiPO Discoverer Output Interface
*
* It provides an interface to SPI, To register for the Discoverer
* status updates and updates all the registered clients, whenever there is
* an update.
*
****************************************************************************/
class spi_tclDiPORespDiscoverer:public RespBase
{
public:

   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  spi_tclDiPORespDiscoverer::spi_tclDiPORespDiscoverer()
   ***************************************************************************/
   /*!
   * \fn      spi_tclDiPORespDiscoverer()
   * \brief   Constructor
   * \sa      ~spi_tclDiPORespDiscoverer()
   **************************************************************************/
   spi_tclDiPORespDiscoverer():RespBase(e16DIPO_DISCOVERER_REGID){}

   /***************************************************************************
   ** FUNCTION:  spi_tclDiPORespDiscoverer::~spi_tclDiPORespDiscoverer()
   ***************************************************************************/
   /*!
   * \fn      virtual ~spi_tclDiPORespDiscoverer()
   * \brief   Destructor
   * \param   t_Void
   * \sa      spi_tclDiPORespDiscoverer(RegID enRegId)
   **************************************************************************/
   virtual ~spi_tclDiPORespDiscoverer(){}

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclDiPORespDiscoverer::vOnDeviceListUpdate(...
   ***************************************************************************/
   /*!
   * \fn      virtual t_Void vOnDeviceUpdate(
   *                       const trDiPODeviceList& corfrDiPODeviceList,t_Bool bIsConnected)
   * \brief   To Post the device info to SPI, when the device list changes
   * \param   corfrDiPODeviceList : [IN] CarPlay Device Info
   * \param   bIsConnected : [IN] device connection status
   * \retval  t_Void
   ***************************************************************************/
   virtual t_Void vOnDeviceUpdate(const trDiPODeviceInfo& /*corfrDiPODeviceInfo*/,t_Bool /*bIsConnected*/){}

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclDiPORespDiscoverer::vOnConnectDeviceResp(...
   ***************************************************************************/
   /*!
   * \fn      virtual t_Void vOnConnectDeviceResp(
   *                       const char* pczBTMACAddress, t_Bool bIsConnectSucceeded)
   * \brief   To Post the ConnectDevice Response
   * \param   pczBTMACAddress : [IN] BT MAC Address of the device
   * \param   bIsConnectSucceeded : [IN] true - ConnectDevice success
   *                                     false - ConnectDevice failure
   * \retval  t_Void
   ***************************************************************************/
   virtual t_Void vOnConnectDeviceResp(const char* /*pczBTMACAddress*/, t_Bool /*bIsConnectSucceeded*/){}

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclDiPORespDiscoverer::vOnDisconnectDeviceResp(...
   ***************************************************************************/
   /*!
   * \fn      virtual t_Void vOnDisconnectDeviceResp(
   *                       const char* pczBTMACAddress, t_Bool bIsConnectSucceeded)
   * \brief   To Post the DisconnectDevice Response
   * \param   pczBTMACAddress : [IN] BT MAC Address of the device
   * \param   bIsDisconnectSucceeded : [IN] true - DisconnectDevice success
   *                                     false - DisconnectDevice failure
   * \retval  t_Void
   ***************************************************************************/
   virtual t_Void vOnDisconnectDeviceResp(const char* /*pczBTMACAddress*/, t_Bool /*bIsDisconnectSucceeded*/){}

   /***************************************************************************
   ****************************END OF PUBLIC***********************************
   ***************************************************************************/

protected:

   /***************************************************************************
   *********************************PROTECTED**********************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  spi_tclDiPORespDiscoverer::spi_tclDiPORespDiscoverer()
   ***************************************************************************/
   /*!
   * \fn      spi_tclDiPORespDiscoverer(const spi_tclDiPORespDiscoverer& corfoSrc))
   * \brief   Parameterized Constructor
   * \param   corfoSrc : [IN] reference to source data interface object
   * \sa      spi_tclDiPORespDiscoverer(RegID enRegId)
   **************************************************************************/
   spi_tclDiPORespDiscoverer(const spi_tclDiPORespDiscoverer& corfoSrc);

   /***************************************************************************
   ** FUNCTION:  spi_tclDiPORespDiscoverer& operator=( const  spi_tclDiPO...
   ***************************************************************************/
   /*!
   * \fn      spi_tclDiPORespDiscoverer& operator=(const spi_tclDiPORespDiscoverer& corfoSrc))
   * \brief   Assignment operator
   * \param   corfoSrc : [IN] reference to source data interface object
   * \retval
   * \sa      spi_tclDiPORespDiscoverer(const spi_tclDiPORespDiscoverer& otrSrc)
   ***************************************************************************/
   spi_tclDiPORespDiscoverer& operator=(const spi_tclDiPORespDiscoverer& corfoSrc);


   /***************************************************************************
   ****************************END OF PROTECTED********************************
   ***************************************************************************/

private:

   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/


   /***************************************************************************
   ****************************END OF PRIVATE *********************************
   ***************************************************************************/

};


#endif //_SPI_TCLDIPORESPDISCOVERER_H_

/////////////////////////////////////<EOF>//////////////////////////////////////////

