/***********************************************************************/
/*!
* \file  spi_tclDiPODiscovererDispatcher.h
* \brief Message Dispatcher for Discoverer Messages. 
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Message Dispatcher for Discoverer Messages. 
AUTHOR:         Shiva Kumar Gurija
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
09.12.2016  | Shiva Kumar Gurija    | Initial Version

\endverbatim
*************************************************************************/
#ifndef _SPI_TCLDIPODISCOVERERDISPATCHER_H_
#define _SPI_TCLDIPODISCOVERERDISPATCHER_H_

/***************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|--------------------------------------------------------------------------*/
#include "DiPOTypes.h"
#include "DiPOWrapperTypes.h"
class spi_tclDiPODiscovererDispatcher;

/******************************************************************************
| typedefs (scope: module-global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/****************************************************************************/
/*!
 * \class DiPODiscovererMsgBase
 * \brief Base Message type for all Discoverer messages
 ****************************************************************************/
class DiPODiscovererMsgBase: public trMsgBase
{
   public:
      /***************************************************************************
       ** FUNCTION:  DiPODiscovererMsgBase::DiPODiscovererMsgBase
       ***************************************************************************/
      /*!
       * \fn      DiPODiscovererMsgBase()
       * \brief   Default constructor
       **************************************************************************/
      DiPODiscovererMsgBase();

      /***************************************************************************
       ** FUNCTION:  DiPODiscovererMsgBase::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclDiPODiscovererDispatcher* poDiscDispatcher)
       * \brief   Pure virtual function to be overridden by inherited classes for
       *          dispatching the message
       * \param poDiscDispatcher: pointer to Discoverer Message Dispatcher
       **************************************************************************/
      virtual t_Void vDispatchMsg(spi_tclDiPODiscovererDispatcher* poDiscDispatcher) = 0;

      /***************************************************************************
       ** FUNCTION:  DiPODiscovererMsgBase::~DiPODiscovererMsgBase
       ***************************************************************************/
      /*!
       * \fn      ~DiPODiscovererMsgBase()
       * \brief   Destructor
       **************************************************************************/
      virtual ~DiPODiscovererMsgBase()
      {

      }

      /***************************************************************************
       ** FUNCTION:  DiPODiscovererMsgBase::u32GetDeviceHandle
       ***************************************************************************/
      /*!
       * \fn      u32GetDeviceHandle()
       * \brief   returns the device handle
       **************************************************************************/
      virtual t_U32 u32GetDeviceHandle();

      /***************************************************************************
       ** FUNCTION:  DiPODiscovererMsgBase::vSetDeviceHandle
       ***************************************************************************/
      /*!
       * \fn      vSetDeviceHandle()
       * \brief   sets the device handle
       **************************************************************************/
      virtual t_Void vSetDeviceHandle(t_U32 u32DevHndle);

   private:
      t_U32 m_u32DeviceHandle;
};

/****************************************************************************/
/*!
 * \class DiPODeviceInfoMsg
 * \brief Device information message
 ****************************************************************************/
class DiPODeviceInfoMsg: public DiPODiscovererMsgBase
{
   public:
   
    trDiPODeviceInfo* prDeviceInfo;
	t_Bool bIsDeviceConnected;

      /***************************************************************************
       ** FUNCTION:  DiPODeviceInfoMsg::DiPODeviceInfoMsg()
       ***************************************************************************/
      /*!
       * \fn      DiPODeviceInfoMsg()
       * \brief   Default constructor
       **************************************************************************/
      DiPODeviceInfoMsg();

      /***************************************************************************
       ** FUNCTION:  DiPODeviceInfoMsg::~DiPODeviceInfoMsg()
       ***************************************************************************/
      /*!
       * \fn      ~DiPODeviceInfoMsg()
       * \brief   DiPODeviceInfoMsg
       **************************************************************************/
      virtual ~DiPODeviceInfoMsg() {}

      /***************************************************************************
       ** FUNCTION:  DiPODeviceInfoMsg::vDispatchMsg()
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclDiPODiscovererDispatcher* poDiscDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
       * \param   poDiscDispatcher: pointer to Discoverer Message Dispatcher
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclDiPODiscovererDispatcher* poDiscDispatcher);

      /***************************************************************************
       ** FUNCTION:  DiPODeviceInfoMsg::vAllocateMsg()
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       **************************************************************************/
      t_Void vAllocateMsg();

      /***************************************************************************
       ** FUNCTION:  DiPODeviceInfoMsg::vDeAllocateMsg()
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       **************************************************************************/
      t_Void vDeAllocateMsg();
};


/****************************************************************************/
/*!
* \class ConnectDeviceRespMsg
* \brief Response for the ConnectDevice
****************************************************************************/
class ConnectDeviceRespMsg : public DiPODiscovererMsgBase
{
public:

   char szBTMACAddress[DIPO_MAX_STR_LEN];
   t_Bool bConnectSucceeded;

   /***************************************************************************
   ** FUNCTION:  ConnectDeviceRespMsg::ConnectDeviceRespMsg()
   ***************************************************************************/
   /*!
   * \fn      ConnectDeviceRespMsg()
   * \brief   Default constructor
   **************************************************************************/
   ConnectDeviceRespMsg();

   /***************************************************************************
   ** FUNCTION:  ConnectDeviceRespMsg::~ConnectDeviceRespMsg()
   ***************************************************************************/
   /*!
   * \fn      ~ConnectDeviceRespMsg()
   * \brief   ConnectDeviceRespMsg
   **************************************************************************/
   virtual ~ConnectDeviceRespMsg() {}

   /***************************************************************************
   ** FUNCTION:  ConnectDeviceRespMsg::vDispatchMsg()
   ***************************************************************************/
   /*!
   * \fn      vDispatchMsg(spi_tclDiPODiscovererDispatcher* poDiscDispatcher)
   * \brief   virtual function for dispatching the message of 'this' type
   * \param   poDiscDispatcher: pointer to Discoverer Message Dispatcher
   **************************************************************************/
   t_Void vDispatchMsg(spi_tclDiPODiscovererDispatcher* poDiscDispatcher);

   /***************************************************************************
   ** FUNCTION:  ConnectDeviceRespMsg::vAllocateMsg()
   ***************************************************************************/
   /*!
   * \fn      vAllocateMsg()
   * \brief   Allocates memory for non trivial datatypes (ex STL containers)
   * \sa      vDeAllocateMsg
   **************************************************************************/
   t_Void vAllocateMsg();

   /***************************************************************************
   ** FUNCTION:  ConnectDeviceRespMsg::vDeAllocateMsg()
   ***************************************************************************/
   /*!
   * \fn      vDeAllocateMsg()
   * \brief   Destroys memory allocated by vAllocateMsg()
   * \sa      vAllocateMsg
   **************************************************************************/
   t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
* \class DisconnectDeviceRespMsg
* \brief Response for the DisconnectDevice
****************************************************************************/
class DisconnectDeviceRespMsg : public DiPODiscovererMsgBase
{
public:

   char szBTMACAddress[DIPO_MAX_STR_LEN];
   t_Bool bDisconnectSucceeded;

   /***************************************************************************
   ** FUNCTION:  DisconnectDeviceRespMsg::DisconnectDeviceRespMsg()
   ***************************************************************************/
   /*!
   * \fn      DisconnectDeviceRespMsg()
   * \brief   Default constructor
   **************************************************************************/
   DisconnectDeviceRespMsg();

   /***************************************************************************
   ** FUNCTION:  DisconnectDeviceRespMsg::~DisconnectDeviceRespMsg()
   ***************************************************************************/
   /*!
   * \fn      ~DisconnectDeviceRespMsg()
   * \brief   DisconnectDeviceRespMsg
   **************************************************************************/
   virtual ~DisconnectDeviceRespMsg() {}

   /***************************************************************************
   ** FUNCTION:  DisconnectDeviceRespMsg::vDispatchMsg()
   ***************************************************************************/
   /*!
   * \fn      vDispatchMsg(spi_tclDiPODiscovererDispatcher* poDiscDispatcher)
   * \brief   virtual function for dispatching the message of 'this' type
   * \param   poDiscDispatcher: pointer to Discoverer Message Dispatcher
   **************************************************************************/
   t_Void vDispatchMsg(spi_tclDiPODiscovererDispatcher* poDiscDispatcher);

   /***************************************************************************
   ** FUNCTION:  DisconnectDeviceRespMsg::vAllocateMsg()
   ***************************************************************************/
   /*!
   * \fn      vAllocateMsg()
   * \brief   Allocates memory for non trivial datatypes (ex STL containers)
   * \sa      vDeAllocateMsg
   **************************************************************************/
   t_Void vAllocateMsg();

   /***************************************************************************
   ** FUNCTION:  DisconnectDeviceRespMsg::vDeAllocateMsg()
   ***************************************************************************/
   /*!
   * \fn      vDeAllocateMsg()
   * \brief   Destroys memory allocated by vAllocateMsg()
   * \sa      vAllocateMsg
   **************************************************************************/
   t_Void vDeAllocateMsg();

};


/****************************************************************************/
/*!
 * \class spi_tclDiPODiscovererDispatcher
 * \brief Message Dispatcher for Discoverer Messages.implemented using
 *        double dispatch mechanism
 ****************************************************************************/
class spi_tclDiPODiscovererDispatcher
{
   public:
      /***************************************************************************
       ** FUNCTION:  spi_tclDiPODiscovererDispatcher::spi_tclDiPODiscovererDispatcher
       ***************************************************************************/
      /*!
       * \fn      spi_tclDiPODiscovererDispatcher()
       * \brief   Default constructor
       **************************************************************************/
      spi_tclDiPODiscovererDispatcher();

      /***************************************************************************
       ** FUNCTION:  spi_tclDiPODiscovererDispatcher::~spi_tclDiPODiscovererDispatcher
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclDiPODiscovererDispatcher()
       * \brief   Destructor
       **************************************************************************/
      ~spi_tclDiPODiscovererDispatcher();

      /***************************************************************************
       ** FUNCTION:  spi_tclMLVncDAPDispatcher::vHandleDiscoveryMsg(DiPODeviceInfoMsg* poDeviceListMsg)
       ***************************************************************************/
      /*!
       * \fn      vHandleDiscoveryMsg(DiPODeviceInfoMsg* poDeviceListMsg) const
       * \brief   Handles Messages of DiPODeviceInfoMsg type
       * \param   poDeviceListMsg : pointer to DiPODeviceInfoMsg
       **************************************************************************/
      t_Void vHandleDiscoveryMsg(DiPODeviceInfoMsg* poDeviceListMsg)const;

      /***************************************************************************
      ** FUNCTION:  spi_tclMLVncDAPDispatcher::vHandleDiscoveryMsg(ConnectDeviceRespMsg* poConnectDeviceRespMsg)
       ***************************************************************************/
      /*!
      * \fn      vHandleDiscoveryMsg(ConnectDeviceRespMsg* poConnectDeviceRespMsg) const
      * \brief   Handles Messages of ConnectDeviceRespMsg type
      * \param   poConnectDeviceRespMsg : pointer to ConnectDeviceRespMsg
      **************************************************************************/
      t_Void vHandleDiscoveryMsg(ConnectDeviceRespMsg* poConnectDeviceRespMsg)const;

      /***************************************************************************
      ** FUNCTION:  spi_tclMLVncDAPDispatcher::vHandleDiscoveryMsg(DisconnectDeviceRespMsg* poDisconnectDeviceRespMsg)
      ***************************************************************************/
      /*!
      * \fn      vHandleDiscoveryMsg(DisconnectDeviceRespMsg* poDisconnectDeviceRespMsg const
      * \brief   Handles Messages of DisconnectDeviceRespMsg type
      * \param   poConnectDeviceRespMsg : pointer to DisconnectDeviceRespMsg
      **************************************************************************/
      t_Void vHandleDiscoveryMsg(DisconnectDeviceRespMsg* poDisconnectDeviceRespMsg)const;
      
};

#endif // _SPI_TCLDIPODISCOVERERDISPATCHER_H_

/////////////////////////////////////<EOF>//////////////////////////////////////////
