
/***********************************************************************/
/*!
* \file  spi_tclDiPOCmdDiscoverer.h
* \brief Adapter class to send discovery & connectivity requests to CarPlayd process.
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Adapter class to send discovery & connectivity requests to CarPlayd process.
AUTHOR:         Shiva Kumar Gurija
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
09.12.2016  | Shiva Kumar Gurija    | Initial Version

\endverbatim
*************************************************************************/
#ifndef _SPI_TCLDIPOCMDDISCOVERER_H_
#define _SPI_TCLDIPOCMDDISCOVERER_H_


/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/
enum class tenConnectTriggerReason;

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/****************************************************************************/
/*!
* \class spi_tclDiPOCmdDiscoverer
* \brief Adapter class to send discovery & connectivity requests to CarPlayd process.
****************************************************************************/
class spi_tclDiPOCmdDiscoverer
{

public:

    /***************************************************************************
    *********************************PUBLIC*************************************
    ***************************************************************************/

    /***************************************************************************
    ** FUNCTION:  spi_tclDiPOCmdDiscoverer::spi_tclDiPOCmdDiscoverer()
    ***************************************************************************/
    /*!
    * \fn      spi_tclDiPOCmdDiscoverer()
    * \brief   Default Constructor
    * \param   t_Void
    * \sa      ~spi_tclDiPOCmdDiscoverer()
    **************************************************************************/
    spi_tclDiPOCmdDiscoverer();

    /***************************************************************************
    ** FUNCTION:  spi_tclDiPOCmdDiscoverer::~spi_tclDiPOCmdDiscoverer()
    ***************************************************************************/
    /*!
    * \fn      ~spi_tclDiPOCmdDiscoverer()
    * \brief   Destructor
    * \param   t_Void
    * \sa      spi_tclDiPOCmdDiscoverer()
    **************************************************************************/
    ~spi_tclDiPOCmdDiscoverer();


    /***************************************************************************
    ** FUNCTION:  t_Void spi_tclDiPOCmdDiscoverer::vStartDeviceDiscovery()
    ***************************************************************************/
    /*!
    * \fn      t_Void vStartDeviceDiscovery()
    * \brief   Adapter Interface to initiate CarPlay Device discovery
    * \retval  t_Void
    * \sa      enStopDeviceDiscovery()
    **************************************************************************/	
    t_Void vStartDeviceDiscovery();

    /***************************************************************************
    ** FUNCTION:  t_Void spi_tclDiPOCmdDiscoverer::vStopDeviceDiscovery()
    ***************************************************************************/
    /*!
    * \fn      t_Void vStopDeviceDiscovery()
    * \brief   Adapter Interface to stop CarPlay Device discovery
	* \retval  t_Void
    * \sa      enStartDeviceDiscovery()
    **************************************************************************/	
    t_Void vStopDeviceDiscovery();

    /***************************************************************************
    ** FUNCTION:  t_Void spi_tclDiPOCmdDiscoverer::vConnectDevice(t_String szBTMacAddr)
    ***************************************************************************/
    /*!
    * \fn      t_Void vConnectDevice(t_String szBTMacAddr)
    * \brief   Adapter Interface to connect CarPlay device to establish CarPlay session.
    * \param   szBTMacAddr :[IN] Unique Identifier of the device with CarPlayd Plug-In.
    * \retval  t_Void
    * \sa      vDisconnectDevice()
    **************************************************************************/	
    t_Void vConnectDevice(t_String szBTMacAddr);

    /***************************************************************************
    ** FUNCTION:  t_Void spi_tclDiPOCmdDiscoverer::vDisconnectDevice(t_String szBTMacAddr)
    ***************************************************************************/
    /*!
    * \fn      t_Void vDisconnectDevice(t_String szBTMacAddr,
	*                                   tenConnectTriggerReason enConnectTriggerReason)
    * \brief   Adapter Interface to terminate CarPlay session.
    * \param   szBTMacAddr :[IN] Unique Identifier of the device with CarPlayd Plug-In.
    * \param   enConnectTriggerReason :[IN] Connect Trigger Reason.
	* \retval  t_Void
    * \sa      enConnectDevice()
    **************************************************************************/	
    t_Void vDisconnectDevice(t_String szBTMacAddr,tenConnectTriggerReason enConnectTriggerReason);


    /***************************************************************************
    ****************************END OF PUBLIC***********************************
    ***************************************************************************/

protected:

    /***************************************************************************
    *********************************PROTECTED**********************************
    ***************************************************************************/

    /***************************************************************************
    ** FUNCTION:  spi_tclDiPOCmdDiscoverer(const spi_tclDiPOCmdDiscoverer...
    ***************************************************************************/
    /*!
    * \fn      spi_tclDiPOCmdDiscoverer(const spi_tclDiPOCmdDiscoverer& corfoSrc)
    * \brief   Copy constructor - Do not allow the creation of copy constructor
    * \param   corfoSrc : [IN] reference to source data interface object
    * \sa      spi_tclDiPOCmdDiscoverer()
    ***************************************************************************/
    spi_tclDiPOCmdDiscoverer(const spi_tclDiPOCmdDiscoverer& corfoSrc);


    /***************************************************************************
    ** FUNCTION:  spi_tclDiPOCmdDiscoverer& operator=( const spi_tclDiP...
    ***************************************************************************/
    /*!
    * \fn      spi_tclDiPOCmdDiscoverer& operator=(const spi_tclDiPOCmdDiscoverer& corfoSrc))
    * \brief   Assignment operator
    * \param   corfoSrc : [IN] reference to source data interface object
    * \sa      spi_tclDiPOCmdDiscoverer(const spi_tclDiPOCmdDiscoverer& otrSrc)
    ***************************************************************************/
    spi_tclDiPOCmdDiscoverer& operator=(const spi_tclDiPOCmdDiscoverer& corfoSrc);


    /***************************************************************************
    ****************************END OF PROTECTED********************************
    ***************************************************************************/

private:

    /***************************************************************************
    *********************************PRIVATE************************************
    ***************************************************************************/


    /***************************************************************************
    ****************************END OF PRIVATE *********************************
    ***************************************************************************/


}; //class spi_tclDiPOCmdDiscoverer

#endif //_SPI_TCLDIPOCMDDISCOVERER_H_

/////////////////////////////////////<EOF>//////////////////////////////////////////
