/*************************************************************************************************/
/*!
* \file   spi_tclDiPOMsgQThreadable.cpp
* \brief  Responsible to receive the messages written to Queue and dispatch to respective dispatchers.
***************************************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Responsible to receive the messages written to Queue and dispatch to respective dispatchers.
AUTHOR:         Shiva Kumar Gurija
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
09.12.2016  | Shiva Kumar Gurija    | Initial Version

\endverbatim
***************************************************************************************************/

/**************************************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|-------------------------------------------------------------------------------------------------*/
#include "SPITypes.h" //@TODO - use only basetypes.h
#include "MsgQThreadable.h"
#include "DiPOWrapperTypes.h"
#include "spi_tclDiPOMsgQThreadable.h"
#include "spi_tclDiPODiscovererDispatcher.h"
#include "spi_tclDiPOVideoDispatcher.h"
#include "spi_tclDiPOSessionDispatcher.h"
#include "spi_tclDiPOBluetoothDispatcher.h"
#include "spi_tclDiPORsrcMngrDispatcher.h"
#include "spi_tclDiPOAudioDispatcher.h"

//! Includes for Trace files
#include "Trace.h"
   #ifdef TARGET_BUILD
      #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_MSGQTHREADER
      #include "trcGenProj/Header/spi_tclDiPOMsgQThreadable.cpp.trc.h"
   #endif
#endif

/******************************************************************************
| typedefs (scope: module-global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/


/***************************************************************************************************
 ** FUNCTION:  spi_tclDiPOMsgQThreadable::spi_tclDiPOMsgQThreadable()
 ***************************************************************************************************/
spi_tclDiPOMsgQThreadable::spi_tclDiPOMsgQThreadable() : m_poDiscDispatcher(NULL),
m_poVideoDispatcher(NULL),m_poSessionDispatcher(NULL),m_poBTDispatcher(NULL),m_poRsrcMngrDispatcher(NULL),
m_poAudioDispatcher(NULL)
{
   ETG_TRACE_USR1((" spi_tclDiPOMsgQThreadable::spi_tclDiPOMsgQThreadable()"));
   
   m_poDiscDispatcher = new(std::nothrow) spi_tclDiPODiscovererDispatcher();
   SPI_NORMAL_ASSERT(NULL == m_poDiscDispatcher);  

   m_poVideoDispatcher = new(std::nothrow) spi_tclDiPOVideoDispatcher();
   SPI_NORMAL_ASSERT(NULL == m_poVideoDispatcher);

   m_poSessionDispatcher = new(std::nothrow) spi_tclDiPOSessionDispatcher();
   SPI_NORMAL_ASSERT(NULL == m_poSessionDispatcher);

   m_poBTDispatcher = new(std::nothrow) spi_tclDiPOBluetoothDispatcher();
   SPI_NORMAL_ASSERT(NULL == m_poBTDispatcher);
   
   m_poRsrcMngrDispatcher = new(std::nothrow) spi_tclDiPORsrcMngrDispatcher();
   SPI_NORMAL_ASSERT(NULL == m_poRsrcMngrDispatcher);

   m_poAudioDispatcher = new(std::nothrow) spi_tclDiPOAudioDispatcher();
   SPI_NORMAL_ASSERT(NULL == m_poAudioDispatcher);
}

/***************************************************************************************************
 ** FUNCTION:  spi_tclDiPOMsgQThreadable::~spi_tclDiPOMsgQThreadable()
 ***************************************************************************************************/
spi_tclDiPOMsgQThreadable::~spi_tclDiPOMsgQThreadable()
{
   ETG_TRACE_USR1((" spi_tclDiPOMsgQThreadable::~spi_tclDiPOMsgQThreadable()"));
   RELEASE_MEM(m_poDiscDispatcher);
   RELEASE_MEM(m_poVideoDispatcher);
   RELEASE_MEM(m_poSessionDispatcher);
   RELEASE_MEM(m_poBTDispatcher);
   RELEASE_MEM(m_poRsrcMngrDispatcher);
   RELEASE_MEM(m_poAudioDispatcher);
}

/***************************************************************************************************
 ** FUNCTION:  spi_tclDiPOMsgQThreadable::vExecute(tShlMessage *poMessage)
 ***************************************************************************************************/
t_Void spi_tclDiPOMsgQThreadable::vExecute(tShlMessage *poMessage)
{
   ETG_TRACE_USR1((" spi_tclDiPOMsgQThreadable::vExecute"));
   if ((NULL != poMessage) && (NULL != poMessage->pvBuffer))
   {
      trMsgBase *prMsgBase = static_cast<trMsgBase*>(poMessage->pvBuffer);
      if (NULL != prMsgBase)
      {
         t_U32 u32ServiceID = prMsgBase->u32GetServiceID();
         ETG_TRACE_USR2(("[PARAM]:spi_tclDiPOMsgQThreadable::vExecute:ServiceID:%d", u32ServiceID));

         //Handle message to corresponding dispatcher based on Service ID
         switch (u32ServiceID)
         {
            case e8_DIPO_WRAPPER_DISC:
            {
               DiPODiscovererMsgBase *prDiscMsgBase = static_cast<DiPODiscovererMsgBase*>(poMessage->pvBuffer);
               if (NULL != prDiscMsgBase)
               {
                  prDiscMsgBase->vDispatchMsg(m_poDiscDispatcher);
               } // if (NULL != prDiscMsgBase)
            }
            break;
            case e8_DIPO_WRAPPER_SESSION:
            {
               DiPOSessionMsgBase* poSessionMsg = static_cast<DiPOSessionMsgBase*>(poMessage->pvBuffer);
               if (NULL != poSessionMsg)
               {
                  poSessionMsg->vDispatchMsg(m_poSessionDispatcher);
               }
            }
            break;
            case e8_DIPO_WRAPPER_VIDEO:
            {
               DiPOVideoMsgBase* poVideoMsg = static_cast<DiPOVideoMsgBase*>(poMessage->pvBuffer);
               if (NULL != poVideoMsg)
               {
                  poVideoMsg->vDispatchMsg(m_poVideoDispatcher);
               }
            }
            break;
            case e8_DIPO_WRAPPER_AUDIO:
            {
               DiPOAudioMsgBase* poAudioMsg = static_cast<DiPOAudioMsgBase*>(poMessage->pvBuffer);
               if (NULL != poAudioMsg)
               {
                  poAudioMsg->vDispatchMsg(m_poAudioDispatcher);
               }
            }
            break;
            case e8_DIPO_WRAPPER_INPUT:
            {
               //Not used
            }
            break;
            case e8_DIPO_WRAPPER_BLUETOOTH:
            {
               DiPOBluetoothMsgBase* poBTMsg = static_cast<DiPOBluetoothMsgBase*>(poMessage->pvBuffer);
               if(NULL != poBTMsg)
               {
                  poBTMsg->vDispatchMsg(m_poBTDispatcher);
               }
            }
            break;
            case e8_DIPO_WRAPPER_RSRCMNGR:
            {
               DiPORsrcMngrMsgBase* poRsrcMngrMsg = static_cast<DiPORsrcMngrMsgBase*>(poMessage->pvBuffer);
               if (NULL != poRsrcMngrMsg)
               {
                  poRsrcMngrMsg->vDispatchMsg(m_poRsrcMngrDispatcher);
               }
            }
            break;
            default:
            {
               ETG_TRACE_ERR(("[ERR]:spi_tclDiPOMsgQThreadable::vExecute:Unknown ServiceID:%d", u32ServiceID));
            }
            break;
         } // switch (u32ServiceID)
      } // if (NULL != prMsgBase)

      t_U8 *pU8Buffer = static_cast<t_PU8> (poMessage->pvBuffer);
      RELEASE_ARRAY_MEM(pU8Buffer);
   }
   RELEASE_MEM(poMessage);
}

/***************************************************************************************************
 ** FUNCTION:  spi_tclDiPOMsgQThreadable::~spi_tclDiPOMsgQThreadable()
 ***************************************************************************************************/
tShlMessage* spi_tclDiPOMsgQThreadable::poGetMsgBuffer(size_t siBuffer)
{
   ETG_TRACE_USR1((" spi_tclDiPOMsgQThreadable::poGetMsgBuffer "));
   tShlMessage* poMessage = new tShlMessage;

   if (NULL != poMessage)
   {
      if(0 < siBuffer)
      {
         //Allocate the requested memory
         poMessage->pvBuffer = new t_U8[siBuffer];
      }// if(0 < siBuffer)
      else
      {
         poMessage->pvBuffer = NULL;
      } //else for  if(0 < siBuffer)

      if (NULL != poMessage->pvBuffer)
      {
         poMessage->size = (siBuffer);
      } //if (NULL != poMessage->pvBuffer)
      else
      {
         //Free the message as internal allocation failed.
         delete poMessage;
         poMessage = NULL;
      } //else for if (NULL != poMessage->pvBuffer)
   } //if (NULL != poMessage)

   return poMessage;
}

///////////////////////////////////////////////// EOF //////////////////////////////////////////////
