/******************************************************************************/
/*!
* \file  spi_tclDiPOMsgQInterface.h
* \brief 
*******************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    
AUTHOR:         Shiva Kumar Gurija
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
09.12.2016  | Shiva Kumar Gurija    | Initial Version

\endverbatim
******************************************************************************/
#ifndef _SPI_TCLDIPOMSGQINTERFACE_H_
#define _SPI_TCLDIPOMSGQINTERFACE_H_

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "BaseTypes.h"
#include "MsgQThreader.h"
#include "spi_tclDiPOMsgQThreadable.h"
#include "GenericSingleton.h"

using namespace shl::thread;

/******************************************************************************
| typedefs (scope: module-global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/


/*****************************************************************************/
/*!
* \class spi_tclDiPOMsgQInterface
* \brief Responsible to write the messages to Queue and creates thread which 
*        reads the messages written to Queue.
****************************************************************************/
class spi_tclDiPOMsgQInterface : public GenericSingleton<spi_tclDiPOMsgQInterface>
{
public:

	 /***************************************************************************
	 *********************************PUBLIC*************************************
	 ***************************************************************************/

      /***************************************************************************
      ** FUNCTION:  spi_tclDiPOMsgQInterface::~spi_tclDiPOMsgQInterface()
      ***************************************************************************/
      /*!
      * \fn      ~spi_tclDiPOMsgQInterface()
      * \brief   Destructor
      * \sa      spi_tclDiPOMsgQInterface()
      ***************************************************************************/
      ~spi_tclDiPOMsgQInterface();

      /***************************************************************************
      ** FUNCTION:  spi_tclDiPOMsgQInterface::bWriteMsgToQ
      ***************************************************************************/
      /*!
      * \fn      bWriteMsgToQ(trMsgBase *prMsgBase, t_U32 u32MsgSize)
      * \brief   Write Msg to Q for dispatching the message by a seperate thread
      * \param prMsgBase : Pointer to Base Message type
      * \param u32MsgSize :  size of the message to be written to the MsgQ
      ***************************************************************************/
      t_Bool bWriteMsgToQ(trMsgBase *prMsgBase, t_U32 u32MsgSize);

      //! Base Singleton class
      friend class GenericSingleton<spi_tclDiPOMsgQInterface> ;


	  /***************************************************************************
	  *********************************PUBLIC*************************************
	  ***************************************************************************/

protected:
	 /***************************************************************************
	 *********************************PROTECTED**********************************
	 ***************************************************************************/


	 /***************************************************************************
	 *********************************PROTECTED**********************************
	 ***************************************************************************/

private:

	 /***************************************************************************
	 *******************************PRIVATE**************************************
	 ***************************************************************************/

     /***************************************************************************
     ** FUNCTION:  spi_tclDiPOMsgQInterface::spi_tclDiPOMsgQInterface()
     ***************************************************************************/
     /*!
     * \fn      spi_tclDiPOMsgQInterface()
     * \brief   Default Constructor
     * \sa      ~spi_tclDiPOMsgQInterface()
     ***************************************************************************/
     spi_tclDiPOMsgQInterface();
	 
     /***************************************************************************
      ** FUNCTION:  spi_tclDiPOMsgQInterface(const spi_tclDiPOMsgQInterface...
      ***************************************************************************/
     /*!
      * \fn      spi_tclDiPOMsgQInterface(
      *                             const spi_tclDiPOMsgQInterface& corfoSrc)
      * \brief   Copy constructor - Do not allow the creation of copy constructor
      * \param   corfoSrc : [IN] reference to source data interface object
      * \retval
      * \sa      spi_tclDiPOMsgQInterface()
      ***************************************************************************/
      spi_tclDiPOMsgQInterface(const spi_tclDiPOMsgQInterface& corfoSrc);

     /***************************************************************************
      ** FUNCTION:  spi_tclDiPOMsgQInterface& operator=( const spi_tclAAP...
      ***************************************************************************/
     /*!
      * \fn      spi_tclDiPOMsgQInterface& operator=(
      *                          const spi_tclDiPOMsgQInterface& corfoSrc))
      * \brief   Assignment operator
      * \param   corfoSrc : [IN] reference to source data interface object
      * \retval
      * \sa      spi_tclDiPOMsgQInterface(const spi_tclDiPOMsgQInterface& otrSrc)
      ***************************************************************************/
      spi_tclDiPOMsgQInterface& operator=(const spi_tclDiPOMsgQInterface& corfoSrc);	 	 

     //! Pointer to the overridden MsgQThreadable class
     spi_tclDiPOMsgQThreadable *m_poDiPOMsgQThreadable;

     //! pointer to MsgQThreader
     MsgQThreader *m_poDiPOMsgQThreader;

	 /***************************************************************************
	 *******************************PRIVATE************************************
	 **************************************************************************/
};

#endif //_SPI_TCLDIPOMSGQINTERFACE_H_
