
/***********************************************************************/
/*!
* \file  spi_tclDiPOCmdBluetooth.h
* \brief Adapter class to process Bluetooth related events.
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Adapter class to process Bluetooth related events.
AUTHOR:         Shiva Kumar Gurija
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
26.06.2017  | Shiva Kumar Gurija    | Initial Version

\endverbatim
*************************************************************************/
#ifndef _SPI_TCLDIPOCMDBLUETOOTH_H_
#define _SPI_TCLDIPOCMDBLUETOOTH_H_


/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/****************************************************************************/
/*!
* \class spi_tclDiPOCmdBluetooth
* \brief Adapter class to process Bluetooth related events..
****************************************************************************/
class spi_tclDiPOCmdBluetooth
{

public:

    /***************************************************************************
    *********************************PUBLIC*************************************
    ***************************************************************************/

    /***************************************************************************
    ** FUNCTION:  spi_tclDiPOCmdBluetooth::spi_tclDiPOCmdBluetooth()
    ***************************************************************************/
    /*!
    * \fn      spi_tclDiPOCmdBluetooth()
    * \brief   Default Constructor
    * \param   t_Void
    * \sa      ~spi_tclDiPOCmdBluetooth()
    **************************************************************************/
    spi_tclDiPOCmdBluetooth();

    /***************************************************************************
    ** FUNCTION:  spi_tclDiPOCmdBluetooth::~spi_tclDiPOCmdBluetooth()
    ***************************************************************************/
    /*!
    * \fn      ~spi_tclDiPOCmdBluetooth()
    * \brief   Destructor
    * \param   t_Void
    * \sa      spi_tclDiPOCmdBluetooth()
    **************************************************************************/
    ~spi_tclDiPOCmdBluetooth();

    /***************************************************************************
    ** FUNCTION:  t_Void spi_tclDiPOCmdBluetooth::vUpdateBTAddr(...
    ***************************************************************************/
    /*!
    * \fn      t_Void vUpdateBTAddr(t_String szBMACAddr)
    * \brief   Adapter Interface to update BT MAC address
    * \param   szBMACAddr : [IN] BT MAC address of HU
    * \retval  t_Void
    **************************************************************************/
    t_Void vUpdateBTAddr(t_String szBMACAddr);

    /***************************************************************************
    ****************************END OF PUBLIC***********************************
    ***************************************************************************/

protected:

    /***************************************************************************
    *********************************PROTECTED**********************************
    ***************************************************************************/

    /***************************************************************************
    ** FUNCTION:  spi_tclDiPOCmdBluetooth(const spi_tclDiPOCmdBluetooth...
    ***************************************************************************/
    /*!
    * \fn      spi_tclDiPOCmdBluetooth(const spi_tclDiPOCmdBluetooth& corfoSrc)
    * \brief   Copy constructor - Do not allow the creation of copy constructor
    * \param   corfoSrc : [IN] reference to source data interface object
    * \sa      spi_tclDiPOCmdBluetooth()
    ***************************************************************************/
    spi_tclDiPOCmdBluetooth(const spi_tclDiPOCmdBluetooth& corfoSrc);


    /***************************************************************************
    ** FUNCTION:  spi_tclDiPOCmdBluetooth& operator=( const spi_tclDiP...
    ***************************************************************************/
    /*!
    * \fn      spi_tclDiPOCmdBluetooth& operator=(const spi_tclDiPOCmdBluetooth& corfoSrc))
    * \brief   Assignment operator
    * \param   corfoSrc : [IN] reference to source data interface object
    * \sa      spi_tclDiPOCmdBluetooth(const spi_tclDiPOCmdBluetooth& otrSrc)
    ***************************************************************************/
    spi_tclDiPOCmdBluetooth& operator=(const spi_tclDiPOCmdBluetooth& corfoSrc);


    /***************************************************************************
    ****************************END OF PROTECTED********************************
    ***************************************************************************/

private:

    /***************************************************************************
    *********************************PRIVATE************************************
    ***************************************************************************/


    /***************************************************************************
    ****************************END OF PRIVATE *********************************
    ***************************************************************************/


}; //class spi_tclDiPOCmdBluetooth

#endif //_SPI_TCLDIPOCMDBLUETOOTH_H_

/////////////////////////////////////<EOF>//////////////////////////////////////////
