/***********************************************************************/
/*!
* \file  spi_tclDiPOBluetoothDispatcher.h
* \brief Message Dispatcher for Session Messages.
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Message Dispatcher for Bluetooth Messages.
AUTHOR:         Shiva Kumar Gurija
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
26.06.2016  | Shiva Kumar Gurija    | Initial Version

\endverbatim
*************************************************************************/
#ifndef _SPI_TCLDIPOBLUETOOTHDISPATCHER_H_
#define _SPI_TCLDIPOBLUETOOTHDISPATCHER_H_

/***************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|--------------------------------------------------------------------------*/
#include "DiPOTypes.h"
#include "DiPOWrapperTypes.h"
class spi_tclDiPOBluetoothDispatcher;

/******************************************************************************
| typedefs (scope: module-global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/****************************************************************************/
/*!
 * \class DiPOBluetoothMsgBase
 * \brief Base Message type for all Bluetooth messages
 ****************************************************************************/
class DiPOBluetoothMsgBase: public trMsgBase
{
   public:
      /***************************************************************************
       ** FUNCTION:  DiPOBluetoothMsgBase::DiPOBluetoothMsgBase
       ***************************************************************************/
      /*!
       * \fn      DiPOBluetoothMsgBase()
       * \brief   Default constructor
       **************************************************************************/
      DiPOBluetoothMsgBase();

      /***************************************************************************
       ** FUNCTION:  DiPOBluetoothMsgBase::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclDiPOBluetoothDispatcher* poSessionDispatcher)
       * \brief   Pure virtual function to be overridden by inherited classes for
       *          dispatching the message
       * \param poSessionDispatcher: pointer to Session Message Dispatcher
       **************************************************************************/
      virtual t_Void vDispatchMsg(spi_tclDiPOBluetoothDispatcher* poSessionDispatcher) = 0;

      /***************************************************************************
       ** FUNCTION:  DiPOBluetoothMsgBase::~DiPOBluetoothMsgBase
       ***************************************************************************/
      /*!
       * \fn      ~DiPOBluetoothMsgBase()
       * \brief   Destructor
       **************************************************************************/
      virtual ~DiPOBluetoothMsgBase() {   }

      /***************************************************************************
       ** FUNCTION:  DiPOBluetoothMsgBase::u32GetDeviceHandle
       ***************************************************************************/
      /*!
       * \fn      u32GetDeviceHandle()
       * \brief   returns the device handle
       **************************************************************************/
      virtual t_U32 u32GetDeviceHandle();

      /***************************************************************************
       ** FUNCTION:  DiPOBluetoothMsgBase::vSetDeviceHandle
       ***************************************************************************/
      /*!
       * \fn      vSetDeviceHandle()
       * \brief   sets the device handle
       **************************************************************************/
      virtual t_Void vSetDeviceHandle(t_U32 u32DevHndle);

   private:
      t_U32 m_u32DeviceHandle;
};

/****************************************************************************/
/*!
 * \class DisableBluetoothMsg
 * \brief disable bluetooth request handler
 ****************************************************************************/
class DisableBluetoothMsg: public DiPOBluetoothMsgBase
{
   public:

   char szBMACAddress[DIPO_MAX_STR_LEN];
   tenDiPOSessionTransport enSessionTransport;

      /***************************************************************************
       ** FUNCTION:  DisableBluetoothMsg::DisableBluetoothMsg()
       ***************************************************************************/
      /*!
       * \fn      DisableBluetoothMsg()
       * \brief   Default constructor
       **************************************************************************/
       DisableBluetoothMsg();

      /***************************************************************************
       ** FUNCTION:  DisableBluetoothMsg::~DisableBluetoothMsg()
       ***************************************************************************/
      /*!
       * \fn      ~DisableBluetoothMsg()
       * \brief   DisableBluetoothMsg
       **************************************************************************/
      virtual ~DisableBluetoothMsg() {}

      /***************************************************************************
       ** FUNCTION:  DisableBluetoothMsg::vDispatchMsg()
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclDiPOBluetoothDispatcher* poSessionDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
       * \param   poSessionDispatcher: pointer to Session Message Dispatcher
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclDiPOBluetoothDispatcher* poSessionDispatcher);

      /***************************************************************************
       ** FUNCTION:  DisableBluetoothMsg::vAllocateMsg()
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       **************************************************************************/
      t_Void vAllocateMsg();

      /***************************************************************************
       ** FUNCTION:  DisableBluetoothMsg::vDeAllocateMsg()
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       **************************************************************************/
      t_Void vDeAllocateMsg();
};


/****************************************************************************/
/*!
 * \class spi_tclDiPOBluetoothDispatcher
 * \brief Message Dispatcher for Session Messages.implemented using
 *        double dispatch mechanism
 ****************************************************************************/
class spi_tclDiPOBluetoothDispatcher
{
   public:
      /***************************************************************************
       ** FUNCTION:  spi_tclDiPOBluetoothDispatcher::spi_tclDiPOBluetoothDispatcher
       ***************************************************************************/
      /*!
       * \fn      spi_tclDiPOBluetoothDispatcher()
       * \brief   Default constructor
       **************************************************************************/
      spi_tclDiPOBluetoothDispatcher();

      /***************************************************************************
       ** FUNCTION:  spi_tclDiPOBluetoothDispatcher::~spi_tclDiPOBluetoothDispatcher
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclDiPOBluetoothDispatcher()
       * \brief   Destructor
       **************************************************************************/
      ~spi_tclDiPOBluetoothDispatcher();

      /***************************************************************************
       ** FUNCTION:  spi_tclMLVncDAPDispatcher::vHandleBluetoothMsg(...
       ***************************************************************************/
      /*!
       * \fn      vHandleBluetoothMsg(DisableBluetoothMsg* poDisableBluetoothMsg) const
       * \brief   Handles Messages of Disable Bluetooth type
       * \param   poDisableBluetoothMsg : pointer to DisableBluetoothMsg
       **************************************************************************/
      t_Void vHandleBluetoothMsg(DisableBluetoothMsg* poDisableBluetoothMsg)const;
};

#endif // _SPI_TCLDIPOBLUETOOTHDISPATCHER_H_

/////////////////////////////////////<EOF>//////////////////////////////////////////
