/***********************************************************************/
/*!
* \file  spi_tclDiPOCmdAudio.h
* \brief Adapter class to send audio related events to CarPlayd process.
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Adapter class to send audio related events to CarPlayd process.
AUTHOR:         Shiva Kumar Gurija
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
26.06.2017  | Shiva Kumar Gurija    | Initial Version

\endverbatim
*************************************************************************/


/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "BaseTypes.h"
#include "IPCMessageQueue.h"
#include "SPITypes.h"
#include "DiPOTypes.h"
#include "DiPOWrapperTypes.h"
#include "spi_tclDiPOCmdAudio.h"

#include "spi_tclDiPOWrapperMsgQInterface.h"

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
   #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_DIPO
      #include "trcGenProj/Header/spi_tclDiPOCmdAudio.cpp.trc.h"
   #endif
#endif

/******************************************************************************
| typedefs (scope: module-global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/***************************************************************************
** FUNCTION:  spi_tclDiPOCmdAudio::spi_tclDiPOCmdAudio()
***************************************************************************/
spi_tclDiPOCmdAudio::spi_tclDiPOCmdAudio()
{
   ETG_TRACE_USR1(("spi_tclDiPOCmdAudio::spi_tclDiPOCmdAudio()"));
}

/***************************************************************************
** FUNCTION:  spi_tclDiPOCmdAudio::~spi_tclDiPOCmdAudio()
***************************************************************************/
spi_tclDiPOCmdAudio::~spi_tclDiPOCmdAudio()
{
   ETG_TRACE_USR1(("spi_tclDiPOCmdAudio::~spi_tclDiPOCmdAudio()"));
}

/***************************************************************************
** FUNCTION:  t_Bool spi_tclDiPOCmdAudio::bSendAudioAllocResponse(...
***************************************************************************/
t_Bool spi_tclDiPOCmdAudio::bSendAudioAllocResponse(tenDiPOAudioAllocRespType enDiPOAudioAllocRespType,
         tenAudioStreamType enAudioStreamType,
         t_String szAudioOutAlsaDevice,
         t_String szAudioInAlsaDevice)
{
   ETG_TRACE_USR1(("spi_tclDiPOCmdAudio::bSendAudioAllocResponse:Audio Allocation Request Type:%d",
   ETG_ENUM(DIPO_AUDIO_ALLOC_RESP_TYPE,enDiPOAudioAllocRespType)));
   t_Bool bIsMessageSentSuccessfully = false;

   switch(enDiPOAudioAllocRespType)
   {
      case e8_DIPO_AUDIO_ALLOC_RESP_AUDIO:
      {
         trAudioMsg oAudioMsg;
         oAudioMsg.enMsgType = e8AUDIO_MESSAGE;

         oAudioMsg.enAudioStreamType = enAudioStreamType;
         ETG_TRACE_USR4(("[PARAM]:vSendAudioAllocResponse:Audio:AudioStreamType: %d", (t_U8)oAudioMsg.enAudioStreamType));

         if(szAudioOutAlsaDevice.length() < MAX_STR_LEN)
         {
             strncpy(oAudioMsg.szALSADeviceName, szAudioOutAlsaDevice.c_str(), MAX_STR_LEN);
             ETG_TRACE_USR4(("[PARAM]:vSendAudioAllocResponse:Audio:ALSADeviceName: %s", oAudioMsg.szALSADeviceName));
         }
         else
         {
             ETG_TRACE_ERR(("[ERR]vSendAudioAllocResponse:Audio:AudioOutDevice length is more than defined"));
         }
         spi_tclDiPOWrapperMsgQInterface* p_DiPOWrapperMsgQInterface = spi_tclDiPOWrapperMsgQInterface::getInstance();
         if(p_DiPOWrapperMsgQInterface)
         {
             p_DiPOWrapperMsgQInterface->bWriteMsgToQ(&oAudioMsg, sizeof(trAudioMsg));
         }
      }
      break;
      case e8_DIPO_AUDIO_ALLOC_RESP_AUDIO_IN:
      {
          trAudioInMsg oAudioInMsg;

          oAudioInMsg.enMsgType = e8AUDIO_IN_MESSAGE;

          if(szAudioOutAlsaDevice.length() < MAX_STR_LEN)
          {
              strncpy(oAudioInMsg.szAudioOutDevice, szAudioOutAlsaDevice.c_str(), MAX_STR_LEN);
              ETG_TRACE_USR4(("[PARAM]:vSendAudioAllocResponse::AudioIn:AudioOutDevice: %s", oAudioInMsg.szAudioOutDevice));
          }
          else
          {
              ETG_TRACE_ERR(("[ERR]vSendAudioAllocResponse::AudioIn:AudioOutDevice length is more than defined"));
          }

          if(szAudioInAlsaDevice.length() < MAX_STR_LEN)
          {
              strncpy(oAudioInMsg.szAudioInDevice, szAudioInAlsaDevice.c_str(), MAX_STR_LEN);
              ETG_TRACE_USR4(("[PARAM]:vSendAudioAllocResponse::AudioIn:AudioInDevice:%s", oAudioInMsg.szAudioInDevice));
          }
          else
          {
              ETG_TRACE_ERR(("[ERR]vSendAudioAllocResponse::AudioIn:AudioInDevice length is more than defined"));
          }

          spi_tclDiPOWrapperMsgQInterface* p_DiPOWrapperMsgQInterface = spi_tclDiPOWrapperMsgQInterface::getInstance();
          if(p_DiPOWrapperMsgQInterface)
          {
              p_DiPOWrapperMsgQInterface->bWriteMsgToQ(&oAudioInMsg, sizeof(trAudioInMsg));
          }
      }
      break;
      case e8_DIPO_AUDIO_ALLOC_RESP_AUDIO_ALREADY_ACTIVE:
      {
          trAudioSrcActiveMsg oAudioActiveMsg;
          oAudioActiveMsg.enMsgType = e8AUDIO_ACTIVE_MESSAGE;

          spi_tclDiPOWrapperMsgQInterface* p_DiPOWrapperMsgQInterface = spi_tclDiPOWrapperMsgQInterface::getInstance();
          if(p_DiPOWrapperMsgQInterface)
          {
              p_DiPOWrapperMsgQInterface->bWriteMsgToQ(&oAudioActiveMsg, sizeof(trAudioSrcActiveMsg));
          }
      }
      break;
      case e8_DIPO_AUDIO_ALLOC_RESP_ERROR:
      {
          trAudioErrorMsg oAudioErrMsg;
          oAudioErrMsg.enMsgType = e8AUDIO_ERROR_MESSAGE;

          oAudioErrMsg.enAudioStreamType = enAudioStreamType;
          ETG_TRACE_USR4(("[PARAM]:vSendAudioAllocResponse:AudioError:AudioStreamType:%d", (t_U8)oAudioErrMsg.enAudioStreamType));

          strncpy(oAudioErrMsg.szALSADummyDeviceName, "AdevSpiDummy", MAX_STR_LEN);
          ETG_TRACE_USR4(("[PARAM]:vSendAudioAllocResponse:AudioError:Dummy Alsa device:%s", oAudioErrMsg.szALSADummyDeviceName));

          spi_tclDiPOWrapperMsgQInterface* p_DiPOWrapperMsgQInterface = spi_tclDiPOWrapperMsgQInterface::getInstance();
          if(p_DiPOWrapperMsgQInterface)
          {
              p_DiPOWrapperMsgQInterface->bWriteMsgToQ(&oAudioErrMsg, sizeof(trAudioErrorMsg));
          }
      }
      break;
      default:
      {

      }
   }

   ETG_TRACE_USR4(("[PARAM]:IPC Message send status from vSendAudioAllocResponse for the type %d is sucess: %d", enDiPOAudioAllocRespType,
            ETG_ENUM(BOOL,bIsMessageSentSuccessfully)));

   return bIsMessageSentSuccessfully;
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclDiPOCmdAudio::vSendStopAudioRequest(...
***************************************************************************/
t_Void spi_tclDiPOCmdAudio::vSendStopAudioRequest(tenAudioReqType enAudioReqType, t_Bool bIsDropAudio)
{
   ETG_TRACE_USR1(("spi_tclDiPOCmdAudio::vSendStopAudioRequest"));
   
   trAudioStopMsg oAudioStopMsg;
   oAudioStopMsg.enMsgType = e8AUDIO_STOP_MESSAGE;
   oAudioStopMsg.enAudioReqType = enAudioReqType;
   oAudioStopMsg.bIsDropAudio = bIsDropAudio;
   ETG_TRACE_USR4(("[PARAM]:vSendStopAudioRequest:AudioReqType: %d", oAudioStopMsg.enAudioReqType));
   spi_tclDiPOWrapperMsgQInterface* p_DiPOWrapperMsgQInterface = spi_tclDiPOWrapperMsgQInterface::getInstance();
   if(p_DiPOWrapperMsgQInterface)
   {
       p_DiPOWrapperMsgQInterface->bWriteMsgToQ(&oAudioStopMsg, sizeof(trAudioStopMsg));
   }
}
/////////////////////////////////////<EOF>//////////////////////////////////////////
