
/***********************************************************************/
/*!
* \file  spi_tclDiPOCmdAudio.h
* \brief Adapter class to send audio related events to CarPlayd process.
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Adapter class to send audio related events to CarPlayd process.
AUTHOR:         Shiva Kumar Gurija
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
26.06.2017  | Shiva Kumar Gurija    | Initial Version

\endverbatim
*************************************************************************/
#ifndef _SPI_TCLDIPOCMDAUDIO_H_
#define _SPI_TCLDIPOCMDAUDIO_H_
#include "spi_tclDiPOCmdAudioIntf.h"


/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/****************************************************************************/
/*!
* \class spi_tclDiPOCmdAudio
* \brief Adapter class to send audio related events to CarPlayd process.
****************************************************************************/
class spi_tclDiPOCmdAudio : public spi_tclDiPOCmdAudioIntf
{

public:

    /***************************************************************************
    *********************************PUBLIC*************************************
    ***************************************************************************/

    /***************************************************************************
    ** FUNCTION:  spi_tclDiPOCmdAudio::spi_tclDiPOCmdAudio()
    ***************************************************************************/
    /*!
    * \fn      spi_tclDiPOCmdAudio()
    * \brief   Default Constructor
    * \retval  t_Void
    * \sa      ~spi_tclDiPOCmdAudio()
    **************************************************************************/
    spi_tclDiPOCmdAudio();

    /***************************************************************************
    ** FUNCTION:  spi_tclDiPOCmdAudio::~spi_tclDiPOCmdAudio()
    ***************************************************************************/
    /*!
    * \fn      ~spi_tclDiPOCmdAudio()
    * \brief   Destructor
    * \retval  t_Void
    * \sa      spi_tclDiPOCmdAudio()
    **************************************************************************/
    ~spi_tclDiPOCmdAudio();
	
    /***************************************************************************
     ** FUNCTION:  t_Bool spi_tclDiPOCmdAudio::bSendAudioAllocResponse(...
     ***************************************************************************/
    /*!
     * \fn      t_Bool bSendAudioAllocResponse(tenDiPOAudioAllocRespType enDiPOAudioAllocRespType,
     *                 tenAudioStreamType enAudioStreamType,t_String szAudioOutAlsaDevice,
     *                 t_String szAudioInAlsaDevice)
     * \brief   Method to send the response for Audio allocation request (prepare).
     * \param   enDiPOAudioAllocRespType : [IN] Enum to detail the response type.
     *                                          eg. Audio Error/AudioIn/Audio or Audio source is already available
     * \param   enDiPOAudioAllocRespType : [IN] Enum to detail the response type.
     * \param   enAudioStreamType : [IN] Main Audio/Alternate audio. Not valid for AudioIn response.
     * \param   szAudioOutAlsaDevice : [IN] Output Alsa device name.
     * \param   szAudioInAlsaDevice : [IN] Input Alsa device name. Valid only for AudioIn messages.
     * \retval  t_Bool
     **************************************************************************/
    t_Bool bSendAudioAllocResponse(tenDiPOAudioAllocRespType enDiPOAudioAllocRespType,
             tenAudioStreamType enAudioStreamType,
             t_String szAudioOutAlsaDevice,
             t_String szAudioInAlsaDevice);

    /***************************************************************************
     ** FUNCTION:  t_Void spi_tclDiPOCmdAudio::vSendStopAudioRequest(...
     ***************************************************************************/
    /*!
     * \fn      t_Void vSendStopAudioRequest(tenAudioReqType enAudioReqType)
     * \brief   Method to send the stop audio request to Phone.
     * \param   enAudioReqType : [IN] Audio allocation/de-allocation enum
     * \param   bIsDropAudio :   [IN] whether audio strem need to be blocked by platform
     * \retval  t_Void
     **************************************************************************/
    t_Void vSendStopAudioRequest(tenAudioReqType enAudioReqType, t_Bool bIsDropAudio);


    /***************************************************************************
    ****************************END OF PUBLIC***********************************
    ***************************************************************************/

protected:

    /***************************************************************************
    *********************************PROTECTED**********************************
    ***************************************************************************/

    /***************************************************************************
    ** FUNCTION:  spi_tclDiPOCmdAudio(const spi_tclDiPOCmdAudio...
    ***************************************************************************/
    /*!
    * \fn      spi_tclDiPOCmdAudio(const spi_tclDiPOCmdAudio& corfoSrc)
    * \brief   Copy constructor - Do not allow the creation of copy constructor
    * \param   corfoSrc : [IN] reference to source data interface object
    * \sa      spi_tclDiPOCmdAudio()
    ***************************************************************************/
    spi_tclDiPOCmdAudio(const spi_tclDiPOCmdAudio& corfoSrc);


    /***************************************************************************
    ** FUNCTION:  spi_tclDiPOCmdAudio& operator=( const spi_tclDiP...
    ***************************************************************************/
    /*!
    * \fn      spi_tclDiPOCmdAudio& operator=(const spi_tclDiPOCmdAudio& corfoSrc))
    * \brief   Assignment operator
    * \param   corfoSrc : [IN] reference to source data interface object
    * \sa      spi_tclDiPOCmdAudio(const spi_tclDiPOCmdAudio& otrSrc)
    ***************************************************************************/
    spi_tclDiPOCmdAudio& operator=(const spi_tclDiPOCmdAudio& corfoSrc);


    /***************************************************************************
    ****************************END OF PROTECTED********************************
    ***************************************************************************/

private:

    /***************************************************************************
    *********************************PRIVATE************************************
    ***************************************************************************/


    /***************************************************************************
    ****************************END OF PRIVATE *********************************
    ***************************************************************************/


}; //class spi_tclDiPOCmdAudio

#endif //_SPI_TCLDIPOCMDAUDIO_H_

/////////////////////////////////////<EOF>//////////////////////////////////////////
