/*!
 *******************************************************************************
 * \file             spi_tclDiPOConnectionIntf.h
 * \brief            DiPo Connection interface 
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    DiPo Connection manager interface class
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 12.02.2013 |  Shihabudheen P M            | Initial Version
 05.11.2014 |  Ramya Murthy                | Added response for Application metadata.

 \endverbatim
 ******************************************************************************/

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/
#ifndef SPI_TCLDIPOCONNECTIONINTF_H
#define SPI_TCLDIPOCONNECTIONINTF_H

#include "SPITypes.h"
#include "BaseTypes.h"

/*!
 * \class spi_tclDiPOConnectionIntf
 * \brief DiPo connection interface class for handling device connections.
 */
class spi_tclDiPOConnectionIntf
{
public:
   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION: spi_tclDiPOConnectionIntf::~spi_tclDiPOConnectionIntf()
   ***************************************************************************/
   /*!
   * \fn     ~spi_tclDiPOConnectionIntf()
   * \brief  Constructor
   * \sa     
   **************************************************************************/
   spi_tclDiPOConnectionIntf() {};

   /***************************************************************************
   ** FUNCTION: spi_tclDiPOConnectionIntf::~spi_tclDiPOConnectionIntf()
   ***************************************************************************/
   /*!
   * \fn     ~spi_tclDiPOConnectionIntf()
   * \brief  Destructor
   * \sa     
   **************************************************************************/
   virtual ~spi_tclDiPOConnectionIntf() {};

   /***************************************************************************
   ** FUNCTION: t_Void spi_tclDiPOConnectionIntf::vOnDiPODeviceConnect()...
   ***************************************************************************/
   /*!
   * \fn     vOnDiPODeviceConnect(const trDeviceInfo &corfrDeviceInfo)
   * \brief  DiPO capable device connection.
   * \param  corfrDeviceInfo : [IN] Connected device info.
   * \sa
   **************************************************************************/
   virtual t_Void vOnDiPODeviceConnect(const trDeviceInfo & /*corfrDeviceInfo*/) {};

   /***************************************************************************
   ** FUNCTION: t_Void spi_tclDiPOConnectionIntf::vOnDiPODeviceDisConnect()...
   ***************************************************************************/
   /*!
   * \fn     vOnDiPODeviceDisConnect(const trDeviceInfo &corfrDeviceInfo)
   * \brief  DiPO capable device disconnection.
   * \param  corfrDeviceInfo : [IN] disconnected device info.
   * \sa
   **************************************************************************/
   virtual t_Void vOnDiPODeviceDisConnect(const t_U32 /*u32DeviceHandle*/) {};

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclDiPOConnectionIntf::vPostSelctDeviceResult()
   ***************************************************************************/
   /*!
   * \fn     t_Void vPostSelctDeviceResult()
   * \brief  Function to post the device selection statu.
   * \param  enResponse : [IN] Operation status.
   * \param  enErrorType : [IN] error value.
   **************************************************************************/
   virtual t_Void vPostSelectDeviceResult(tenResponseCode enResponse, 
      tenErrorCode enErrorType) = 0;

   /***************************************************************************
   *********************************END OFPUBLIC*******************************
   ***************************************************************************/

private:
  /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/


  /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

};
#endif
