/*!
*******************************************************************************
* \file         spi_tclDiPODeviceAdapter.h
* \brief        CarPlay Device Adapter impmentation.
*******************************************************************************
\verbatim
PROJECT:        G3G
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    CarPlay Device Adapter impmentation
COPYRIGHT:      &copy; RBEI

HISTORY:
Date       |  Author                      | Modifications
10.11.2016 |  Shiva Kumar G               | Initial Version

\endverbatim
******************************************************************************/
#ifndef SPI_TCL_DIPODEVICEADAPTERIMPL_H_
#define SPI_TCL_DIPODEVICEADAPTERIMPL_H_

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include <list>
#include <map>
#include "DiPOTypes.h"
#include <dipo_plugin.h>
#include <ICarPlayDeviceAdapter.h>

using namespace adit::carplay;

/******************************************************************************
| typedefs (scope: module-global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/


/****************************************************************************/
/*!
* \class spi_tclDiPODeviceAdapter
* \brief ICarPlayDeviceAdapter realization
****************************************************************************/
class spi_tclDiPODeviceAdapter : public ICarPlayDeviceAdapter
{
public:

   /***************************************************************************
   *********************************PUBLIC************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION: spi_tclDiPODeviceAdapter::spi_tclDiPODeviceAdapter()
   ***************************************************************************/
   /*!
   * \fn     spi_tclDiPODeviceAdapter()
   * \brief  Constructor
   **************************************************************************/
   spi_tclDiPODeviceAdapter();
   
   /***************************************************************************
   ** FUNCTION: spi_tclDiPODeviceAdapter::~spi_tclDiPODeviceAdapter()
   ***************************************************************************/
   /*!
   * \fn     virtual ~spi_tclDiPODeviceAdapter()
   * \brief  Destructor
   **************************************************************************/
   virtual ~spi_tclDiPODeviceAdapter();

   /***************************************************************************
   ** FUNCTION: t_Bool spi_tclDiPODeviceAdapter::Initialize()
   ***************************************************************************/
   /*!
   * \fn     virtual bool Initialize(ICarPlayDeviceReceiver& rfrDeviceAdapterRcvr)
   * \brief  Method to initialize the DeviceAdapter.
   *         This a pure virtual method in ICarPlayDeviceAdapter
   * \param  rfrDeviceAdapterRcvr : [IN] Pointer to ICarPlayDeviceReceiver to send requests
   * \retVal t_Bool : True if message send success, false otherwise
   **************************************************************************/
   virtual t_Bool Initialize(ICarPlayDeviceReceiver& rfrDeviceAdapterRcvr);

   /***************************************************************************
   ** FUNCTION: t_Void spi_tclDiPODeviceAdapter::OnDeviceUpdated()
   ***************************************************************************/
   /*!
   * \fn     t_Void OnDeviceUpdated(const CarPlayDevice& deviceCarplay, t_Bool bDeviceConnStatus)
   * \brief  Method to receive the device connection information
   *         This a pure virtual method in ICarPlayDeviceAdapter
   * \param  corfrCarPlayDeviceInfo : [IN] CarPlay device info which includes
   *                                  Device BT Address, iOS version and the connection status.
   * \param  bDeviceConnStatus      : [IN] Device Connection status.
   *								True - connected
   *								False - Disconnected
   * \retVal t_Void
   **************************************************************************/
   virtual t_Void OnDeviceUpdated(const CarPlayDevice& corfrCarPlayDeviceInfo, t_Bool bDeviceConnStatus);

   /***************************************************************************
   ** FUNCTION: t_Void spi_tclDiPODeviceAdapter::vConnectDevice()
   ***************************************************************************/
   /*!
   * \fn     t_Void vConnectDevice(const char* cszBTMACAddress)
   * \brief  Method to triggr connectdevice apple interface to establish CarPlay session.
   * \param  cszBTMACAddress : [IN] Unique ID of the device with CarPlay Communication Plug-In.
   * \retVal t_Void
   **************************************************************************/
   static t_Void vConnectDevice(const char* cszBTMACAddress);

   /***************************************************************************
   ** FUNCTION: t_Void spi_tclDiPODeviceAdapter::vDisconnectDevice()
   ***************************************************************************/
   /*!
   * \fn     t_Void vDisconnectDevice(const char* cszBTMACAddress,
   *                                  tenConnectTriggerReason enConnectTriggerReason)
   * \brief  Method to triggr disconnectdevice apple interface to terminate a CarPlay session.
   * \param  cszBTMACAddress : [IN] Unique ID of the device with CarPlay Communication Plug-In.
   * \param  enConnectTriggerReason : Connect Trigger Reason.
   * \retVal t_Void
   **************************************************************************/
   static t_Void vDisconnectDevice(const char* cszBTMACAddress,
   tenConnectTriggerReason enConnectTriggerReason);

   /***************************************************************************
   ** FUNCTION: t_Void spi_tclDiPODeviceAdapter::vSetDeviceDiscoveryState()
   ***************************************************************************/
   /*!
   * \fn     t_Void vSetDeviceDiscoveryState(t_Bool bStartDeviceDiscovery)
   * \brief  Method to triggr disconnectdevice apple interface to terminate a CarPlay session.
   * \param  bStartDeviceDiscovery : [IN] true - Initiate CarPlay device discovery
   *                                      false - stop CarPlay device discovery
   * \retVal t_Void
   **************************************************************************/
   static t_Void vSetDeviceDiscoveryState(t_Bool bStartDeviceDiscovery);

   /*************************************************************************
   ****************************END OF PUBLIC*********************************
   *************************************************************************/


private:

   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/
   
   /***************************************************************************
   ** FUNCTION: t_String spi_tclDiPODeviceAdapter::szCovertBTAddrToSPIFormat(const char* pcocCarplaydBTAddr)
   ***************************************************************************/
   /*!
   * \fn     t_String szCovertBTAddrToSPIFormat(const char* pcocCarplaydBTAddr)
   * \brief  Method to convert the BT Address received from CarPlayd to SPI BT MAC address format usage.
   * \param  pcocCarplaydBTAddr : [IN] BT MAC Address received from CarPlayd Process
   * \retVal std::string : SPI format BT MAC Address
   * \sa
   **************************************************************************/
   t_String szCovertBTAddrToSPIFormat(const char* pcocCarplaydBTAddr);   
					  
								  
   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclDiPODeviceAdapter::vSendConnectDeviceResp()
   ***************************************************************************/
   /*!
   * \fn      t_Void vSendConnectDeviceResp(const char* cszBTMACAddress, 
   *                                        t_Bool bIsConnectSuccess)
   * \brief   Method to populate the connect device response message and post to SPI process.
   * \param   cszBTMACAddress : [IN] BT MAC Address of the device.
   * \param   bIsConnectSuccess : [IN] TRUE - Success, FALSE-Failure
   * \retval  t_Void
   **************************************************************************/
   t_Void vSendConnectDeviceResp(const char* cszBTMACAddress,t_Bool bIsConnectSuccess);

   /***************************************************************************
   ** FUNCTION:  CAEStatus spi_tclDiPODeviceAdapter::enSendConnectDeviceReq()
   ***************************************************************************/
   /*!
   * \fn      CAEStatus enSendConnectDeviceReq(const char* cszBTMACAddress)
   * \brief   Method to send the connect device request.
   * \param   cszBTMACAddress : [IN] BT MAC Address of the device.
   * \retval  CAEStatus
   **************************************************************************/
   CAEStatus enSendConnectDeviceReq(const char* cszBTMACAddress);

   //! Pointer to ICarPlayDeviceReceiver to send the requests for device detection & connection
   static ICarPlayDeviceReceiver *m_poCarplayDeviceAdapterRcvr;
   
   t_String m_sczDeviceBTAddr;

   static spi_tclDiPODeviceAdapter* m_poDiPODeviceAdapter;


   /*************************************************************************
   ****************************END OF PRIVATE*********************************
   *************************************************************************/
};
#endif

/////////////////////////////////////<EOF>//////////////////////////////////////////
