/******************************************************************************/
/*!
* \file  spi_tclDiPOAdapterMsgQInterface.h
* \brief 
*******************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    
AUTHOR:         Suraj P S
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
03.03.2019  | Suraj P S    | Initial Version

\endverbatim
******************************************************************************/
#ifndef _SPI_TCLDIPOADAPTERMSGQINTERFACE_H_
#define _SPI_TCLDIPOADAPTERMSGQINTERFACE_H_

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "BaseTypes.h"
#include "MsgQThreader.h"
#include "spi_tclDiPOMsgQThreadable.h"
#include "GenericSingleton.h"

using namespace shl::thread;

/******************************************************************************
| typedefs (scope: module-global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/


/*****************************************************************************/
/*!
* \class spi_tclDiPOAdapterMsgQInterface
* \brief Responsible to write the messages to Queue and creates thread which 
*        reads the messages written to Queue.
****************************************************************************/
class spi_tclDiPOAdapterMsgQInterface : public GenericSingleton<spi_tclDiPOAdapterMsgQInterface>
{
public:

	 /***************************************************************************
	 *********************************PUBLIC*************************************
	 ***************************************************************************/

      /***************************************************************************
      ** FUNCTION:  spi_tclDiPOAdapterMsgQInterface::~spi_tclDiPOAdapterMsgQInterface()
      ***************************************************************************/
      /*!
      * \fn      ~spi_tclDiPOAdapterMsgQInterface()
      * \brief   Destructor
      * \sa      spi_tclDiPOAdapterMsgQInterface()
      ***************************************************************************/
      ~spi_tclDiPOAdapterMsgQInterface();

      /***************************************************************************
      ** FUNCTION:  spi_tclDiPOAdapterMsgQInterface::bWriteMsgToQ
      ***************************************************************************/
      /*!
      * \fn      bWriteMsgToQ(trMsgQBase *prMsgBase, t_U32 u32MsgSize)
      * \brief   Write Msg to Q for dispatching the message by a seperate thread
      * \param prMsgBase : Pointer to Base Message type
      * \param u32MsgSize :  size of the message to be written to the MsgQ
      ***************************************************************************/
      t_Bool bWriteMsgToQ(trMsgQBase *prMsgBase, t_U32 u32MsgSize);

      //! Base Singleton class
      friend class GenericSingleton<spi_tclDiPOAdapterMsgQInterface> ;


	  /***************************************************************************
	  *********************************PUBLIC*************************************
	  ***************************************************************************/

protected:
	 /***************************************************************************
	 *********************************PROTECTED**********************************
	 ***************************************************************************/


	 /***************************************************************************
	 *********************************PROTECTED**********************************
	 ***************************************************************************/

private:

	 /***************************************************************************
	 *******************************PRIVATE**************************************
	 ***************************************************************************/

     /***************************************************************************
     ** FUNCTION:  spi_tclDiPOAdapterMsgQInterface::spi_tclDiPOAdapterMsgQInterface()
     ***************************************************************************/
     /*!
     * \fn      spi_tclDiPOAdapterMsgQInterface()
     * \brief   Default Constructor
     * \sa      ~spi_tclDiPOAdapterMsgQInterface()
     ***************************************************************************/
     spi_tclDiPOAdapterMsgQInterface();
	 
     /***************************************************************************
      ** FUNCTION:  spi_tclDiPOAdapterMsgQInterface(const spi_tclDiPOAdapterMsgQInterface...
      ***************************************************************************/
     /*!
      * \fn      spi_tclDiPOAdapterMsgQInterface(
      *                             const spi_tclDiPOAdapterMsgQInterface& corfoSrc)
      * \brief   Copy constructor - Do not allow the creation of copy constructor
      * \param   corfoSrc : [IN] reference to source data interface object
      * \retval
      * \sa      spi_tclDiPOAdapterMsgQInterface()
      ***************************************************************************/
      spi_tclDiPOAdapterMsgQInterface(const spi_tclDiPOAdapterMsgQInterface& corfoSrc);

     /***************************************************************************
      ** FUNCTION:  spi_tclDiPOAdapterMsgQInterface& operator=( const spi_tclAAP...
      ***************************************************************************/
     /*!
      * \fn      spi_tclDiPOAdapterMsgQInterface& operator=(
      *                          const spi_tclDiPOAdapterMsgQInterface& corfoSrc))
      * \brief   Assignment operator
      * \param   corfoSrc : [IN] reference to source data interface object
      * \retval
      * \sa      spi_tclDiPOAdapterMsgQInterface(const spi_tclDiPOAdapterMsgQInterface& otrSrc)
      ***************************************************************************/
      spi_tclDiPOAdapterMsgQInterface& operator=(const spi_tclDiPOAdapterMsgQInterface& corfoSrc);	 	 

     //! Pointer to the overridden MsgQThreadable class
     MsgQThreadable *m_poMsgQThreadable;

     //! pointer to MsgQThreader
     MsgQThreader *m_poMsgQThreader;

	 /***************************************************************************
	 *******************************PRIVATE************************************
	 **************************************************************************/
};

#endif //_SPI_TCLDIPOADAPTERMSGQINTERFACE_H_
