/***********************************************************************/
/*!
* \file  spi_tclResourceMngrSettingsIntf.h
* \brief  Implementation of the Class spi_tclResourceMngrSettingsIntf
*************************************************************************
\verbatim


PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Interface class for Resource manager Settings
AUTHOR:         kmo6kor
COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
07.06.2018    kmo6kor			    Initial Version
\endverbatim
*************************************************************************/


/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/
/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/
#ifndef SPI_TCLRESOURCEMNGRSETTINGSINTF_
#define SPI_TCLRESOURCEMNGRSETTINGSINTF_

#include "spi_tclCommonSettingsIntf.h"
#include "DiPOTypes.h"

class spi_tclResourceMngrSettingsIntf : public virtual spi_tclCommonSettingsIntf
{
   /***************************************************************************
   ****************************PUBLIC *********************************
   ***************************************************************************/

public:
   /***************************************************************************
   ** FUNCTION: spi_tclResourceMngrSettingsIntf::spi_tclResourceMngrSettingsIntf()
   ***************************************************************************/
   /*!
   * \fn      spi_tclResourceMngrSettingsIntf()
   * \brief   Constructor
   * \param   None
   **************************************************************************/
   spi_tclResourceMngrSettingsIntf(){}

   /***************************************************************************
   ** FUNCTION: spi_tclResourceMngrSettingsIntf::~spi_tclResourceMngrSettingsIntf()
   ***************************************************************************/
   /*!
   * \fn      ~spi_tclResourceMngrSettingsIntf()
   * \brief   Destructor
   * \param   None
   **************************************************************************/
   virtual ~spi_tclResourceMngrSettingsIntf(){}

   /***************************************************************************
   ** FUNCTION:  t_U32 spi_tclResourceMngrSettingsIntf::u32GetStartUpTimeInterval()
   ***************************************************************************/
   /*!
   * \fn      u32GetStartUpTimeInterval()
   * \brief   Function to get the CarPlay session startup time interval
   * \param   NONE
   * \retVal  t_U32 : Time interval in milli seconds.
   * \sa
   **************************************************************************/
   virtual t_U32 u32GetStartUpTimeInterval() const = 0;

   /***************************************************************************
   ** FUNCTION:  tenETCInfo spi_tclResourceMngrSettingsIntf::enGetCarPlayETCEnabledFlag()
   ***************************************************************************/
   /*!
   * \fn      enGetCarPlayETCEnabledFlag()
   * \brief   Function to get the CarPlay ETC feature enable flag
   * \param   enDevCat: [IN] Category of the device whose ETC status is needed
   * \retVal  tenETCInfo: ETC Status
   * \sa
   **************************************************************************/
   virtual tenETCInfo enGetCarPlayETCEnabledFlag(tenDeviceCategory enDevCat) const = 0;

   /***************************************************************************
   ** FUNCTION:  tenDriveSideInfo spi_tclResourceMngrSettingsIntf::enGetDriveSideInfo(...)
   ***************************************************************************/
   /*!
   * \fn      enGetDriveSideInfo()
   * \brief   Method to read Drive side info.
   * \param   NONE
   * \retval  Drive Side enum
   **************************************************************************/
   virtual tenDriveSideInfo enGetDriveSideInfo() = 0;

   /***************************************************************************
    ** FUNCTION:  t_String spi_tclResourceMngrSettingsIntf::szGetSoftwareVersion()
    ***************************************************************************/
   /*!
    * \fn      t_String szGetSoftwareVersion()
    * \brief   Method to get the software version
    * \param   NONE
    * \retval  t_String
    **************************************************************************/
   virtual t_String szGetSoftwareVersion() const = 0;

   /***************************************************************************
    ** FUNCTION:  t_String spi_tclResourceMngrSettingsIntf::szGetHardwareVersion()
    ***************************************************************************/
   /*!
    * \fn      t_String szGetHardwareVersion()
    * \brief   Method to get the accessory hardware version
    * \param   NONE
    * \retval  t_String
    **************************************************************************/
   virtual t_String szGetHardwareVersion() = 0;

   /***************************************************************************
   ** FUNCTION: t_Void spi_tclResourceMngrSettingsIntf::vGetDiPOExtendedFeaturesSupport(
                     trExtendedFeaturesSupport& rfrExtendedFeaturesSupport)
   ***************************************************************************/
   /*!
   * \fn      t_Void vGetDiPOExtendedFeaturesSupport(trExtendedFeaturesSupport& rfrExtendedFeaturesSupport)
   * \brief   Method to read DiPO Extended Features Support
   * \param   rfrExtendedFeaturesSupport: [OUT]Extended Features Support
   * \retval  NONE
   **************************************************************************/
   virtual t_Void vGetDiPOExtendedFeaturesSupport(trExtendedFeaturesSupport& rfrExtendedFeaturesSupport) = 0;


   /***************************************************************************
   ** FUNCTION: t_Void spi_tclResourceMngrSettingsIntf::vGetOemIconData(
                     trVehicleBrandInfo& rfrVehicleBrandInfo)
   ***************************************************************************/
   /*!
   * \fn      t_Void vGetOemIconData(trVehicleBrandInfo& rfrVehicleBrandInfo)
   * \brief   Method to read the EOL value and get the Brand configuration data
              from the look up table
   * \param   rfrVideoConfig: [IN]Vehicle Brand Data
   * \retval  NONE
   **************************************************************************/
   virtual t_Void vGetOemIconData(trVehicleBrandInfo& rfrVehicleBrandInfo) = 0;

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclResourceMngrSettingsIntf::vGetDriveModeInfo()
   ***************************************************************************/
   /*!
   * \fn      t_Void vGetDriveModeInfo()
   * \brief   Method set the drive mode information
   * \param   enDriveModeInfo : [OUT] Drive mode info.
   * \retval  t_Void
   **************************************************************************/
   virtual t_Void vGetDriveModeInfo(tenVehicleConfiguration &rfoenDriveModeInfo)  = 0;

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclResourceMngrSettingsIntf::vGetNightModeInfo()
   ***************************************************************************/
   /*!
   * \fn      t_Void vGetNightModeInfo()
   * \brief   Method get the night  mode information
   * \param   rfoenNightModeInfo : [OUT] Night mode info
   * \retval  t_Void
   **************************************************************************/
   virtual t_Void vGetNightModeInfo(tenVehicleConfiguration &rfoenNightModeInfo) = 0;

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclResourceMngrSettingsIntf::vGetDisplayInputParam()
   ***************************************************************************/
   /*!
   * \fn      t_Void vGetDisplayInputParam()
   * \brief   Method get the display input configuration.Input methods enabled.
   * \param   rfu8DisplayInput : [OUT] Display input parameter for DiPO
   * \retval  t_Void
   **************************************************************************/
   virtual t_Void vGetDisplayInputParam(t_U8 &rfu8DisplayInput) = 0;

   /***************************************************************************
   ****************************END OF PUBLIC *********************************
   ***************************************************************************/

};
#endif //SPI_TCLRESOURCEMNGRSETTINGSINTF_
