/***********************************************************************/
/*!
* \file  spi_tclBluetoothSettingsIntf.h
* \brief  Implementation of the Class spi_tclBluetoothSettingsIntf
*************************************************************************
\verbatim


PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Interface class for Bluetooth Settings
AUTHOR:         kmo6kor
COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
07/08/2018  | kmo6kor			    | Initial Version                                               
\endverbatim
*************************************************************************/


/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/
/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/
#ifndef SPI_TCLBLUETOOTHSETTINGSINTF_
#define SPI_TCLBLUETOOTHSETTINGSINTF_

#include "spi_tclCommonSettingsIntf.h"

class spi_tclBluetoothSettingsIntf : public virtual spi_tclCommonSettingsIntf
{
   /***************************************************************************
   ****************************PUBLIC *********************************
   ***************************************************************************/

public:
	/***************************************************************************
	 ** FUNCTION:  spi_tclBluetoothSettingsIntf::spi_tclBluetoothSettingsIntf()
	 ***************************************************************************/
	/*!
	 * \fn      spi_tclBluetoothSettingsIntf()
	 * \brief   Constructor
	 * \param   None
	 **************************************************************************/
	spi_tclBluetoothSettingsIntf(){}

	/***************************************************************************
	 ** FUNCTION:  spi_tclBluetoothSettingsIntf::~spi_tclBluetoothSettingsIntf()
	 ***************************************************************************/
	/*!
	 * \fn      ~spi_tclBluetoothSettingsIntf()
	 * \brief   Destructor
	 * \param   None
	 **************************************************************************/
	virtual ~spi_tclBluetoothSettingsIntf(){}

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclBluetoothSettingsIntf::vOnVehicleBTAddress()
   ***************************************************************************/
   /*!
   * \fn     vOnVehicleBTAddress()
   * \brief  Function to set the vehicle BT address.
   * \param  szVehicleBTAddress:[OUT] Vehicle BT address
   * \retval  None
   **************************************************************************/
   virtual t_Void vOnVehicleBTAddress(t_String &szVehicleBTAddress) = 0;

   /***************************************************************************
   ****************************END OF PUBLIC *********************************
   ***************************************************************************/

};
#endif //SPI_TCLBLUETOOTHSETTINGSINTF_
