/***********************************************************************/
/*!
* \file  spi_tclResourceMngrSettings.cpp
* \brief Class to get the Resource Manager settings from the xml.
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Class to get the Resource Manager settings from the xml
AUTHOR:         Shihabudheen P M
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
22.02.1015  | Shihabudheen P M      | Initial version.   
30.11.2015  | Shihabudheen P M      | added bGetarPlayAutoLaunchFlag()


\endverbatim
*************************************************************************/

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "Trace.h"
#include <string.h>
#include <SPITypes.h>
#include "FileHandler.h"
#include "spi_tclResourceMngrSettings.h"

#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_CONFIGREADER
#include "trcGenProj/Header/spi_tclResourceMngrSettings.cpp.trc.h"
#endif
#endif

static const t_Char cG3GXmlConfigFile[] =  "/opt/bosch/spi/xml/policy.xml";

static const t_U8 su8ETCEnabledMask = 0x01;

/***************************************************************************
** FUNCTION:  t_Void spi_tclResourceMngrSettings::~spi_tclResourceMngrSettings()
***************************************************************************/
spi_tclResourceMngrSettings::~spi_tclResourceMngrSettings()
{
   ETG_TRACE_USR1(("spi_tclResourceMngrSettings::~spi_tclResourceMngrSettings()"
      "entered \n"));

}

//! Private
/***************************************************************************
** FUNCTION:  t_Void spi_tclResourceMngrSettings::spi_tclResourceMngrSettings()
***************************************************************************/
spi_tclResourceMngrSettings::spi_tclResourceMngrSettings():
m_StartupTimeInterval(0),
m_enETCSupport(e8ETCInfo_NotSupported),
m_enLastModeSupport(e8LASTMODE_DISABLED)
{
   ETG_TRACE_USR1(("spi_tclResourceMngrSettings::spi_tclResourceMngrSettings() entered \n"));
}


/***************************************************************************
** FUNCTION:  t_Void spi_tclResourceMngrSettings::vReadSettingsValues()
***************************************************************************/
t_Void spi_tclResourceMngrSettings::vReadSettingsValues()
{
   ETG_TRACE_USR1(("spi_tclResourceMngrSettings::vReadConfigValues()"
      "entered \n"));

   t_Char* szConfigFilePath = NULL;
   szConfigFilePath = const_cast<t_Char*>(cG3GXmlConfigFile);
   spi::io::FileHandler oPolicySettingsFile(szConfigFilePath,spi::io::SPI_EN_RDONLY);
   if(true == oPolicySettingsFile.bIsValid())
   {
      tclXmlDocument oXmlDoc(szConfigFilePath);
      tclXmlReader oXmlReader(&oXmlDoc, this);
      oXmlReader.bRead("RESOURCEMNGR");
   }//if(true == oPolicySettingsFile.bIsValid())

}


/***************************************************************************
** FUNCTION:  t_Void spi_tclResourceMngrSettings::u32GetStartUpTimeInterval()
***************************************************************************/
t_U32 spi_tclResourceMngrSettings::u32GetStartUpTimeInterval()
{
   ETG_TRACE_USR1(("spi_tclResourceMngrSettings::u32GetStartUpTimeInterval()"
      "entered \n"));
   return m_StartupTimeInterval;
}

/***************************************************************************
** FUNCTION: tenLastModeSupport spi_tclResourceMngrSettings::bGetLastModeSupport()
***************************************************************************/
t_Bool spi_tclResourceMngrSettings::bGetLastModeSupport(tenDeviceCategory enDevCat) const
{
   ETG_TRACE_USR2(("[PARAM]:spi_tclResourceMngrSettings::enGetLastModeSupport(): Last mode support value - %d", 
         ETG_ENUM(LASTMODE_SUPPORT, m_enLastModeSupport)));

   t_Bool bIsLastModeSupported = false;
   switch (enDevCat)
   {
      case e8DEV_TYPE_DIPO:
         bIsLastModeSupported = (e8LASTMODE_DISABLED != m_enLastModeSupport);
         break;
      case e8DEV_TYPE_UNKNOWN:
      case e8DEV_TYPE_MAX:
      case e8DEV_TYPE_DEFAULT:
         bIsLastModeSupported = false;
         break;
      default:
         bIsLastModeSupported = (e8LASTMODE_ALLTECH == m_enLastModeSupport);
         break;

   }
   return bIsLastModeSupported;
}

/***************************************************************************
** FUNCTION: tenLastModeSupport spi_tclResourceMngrSettings::enGetLastModeSupport()
***************************************************************************/
tenLastModeSupport spi_tclResourceMngrSettings::enGetLastModeSupport() const
{
   ETG_TRACE_USR2(("[PARAM]:spi_tclResourceMngrSettings::enGetLastModeSupport(): Last mode support value - %d", 
         ETG_ENUM(LASTMODE_SUPPORT, m_enLastModeSupport)));
   return m_enLastModeSupport;
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclResourceMngrSettings::bXmlReadNode()
***************************************************************************/
t_Bool spi_tclResourceMngrSettings::bXmlReadNode(xmlNodePtr poNode)
{
   ETG_TRACE_USR1(("spi_tclResourceMngrSettings::bXmlReadNode() entered \n"));
   
   t_Bool bRetVal=false;
   t_String szNodeName;
   
   if(NULL != poNode)
   {
      szNodeName = (const char *)(poNode->name);
   }
   if("STARTUP_TIME_INTERVAL" == szNodeName)
   {
      t_S32 u32Value = 0;
      bRetVal = bGetAttribute("VALUE", poNode, u32Value);
      m_StartupTimeInterval = (t_U32)u32Value;
      ETG_TRACE_USR1(("spi_tclResourceMngrSettings: CarPlay time intervel=%d", 
         m_StartupTimeInterval));
   } //if(STARTUP_TIME_INTERVAL == szNodeName)
   else if("LASTMODE_SUPPORT" == szNodeName)
   {
      t_S32 s32LastModeSupport = 0;
      bRetVal = bGetAttribute("VALUE", poNode, s32LastModeSupport);
      m_enLastModeSupport = static_cast<tenLastModeSupport>(s32LastModeSupport);
      ETG_TRACE_USR4(("spi_tclResourceMngrSettings: Last mode support read value = %d", 
            ETG_ENUM(LASTMODE_SUPPORT, m_enLastModeSupport)));
   }

   return bRetVal;
}
