/***********************************************************************/
/*!
* \file  spi_tclDataServiceSettings.cpp
* \brief Class to get the DataService Settings
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Class to get the DataService Settings
AUTHOR:         Ramya Murthy
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
26.05.2015  | Ramya Murthy          | Initial Version
10.01.2017  | Noopur R Kalawatia    | Added speed frequency field.
\endverbatim
*************************************************************************/

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "FileHandler.h"
#include "XmlDocument.h"
#include "XmlReader.h"
#include "spi_tclDataServiceSettings.h"

#include "Trace.h"
#ifdef TARGET_BUILD
   #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_CONFIGREADER
      #include "trcGenProj/Header/spi_tclDataServiceSettings.cpp.trc.h"
   #endif
#endif

   static const t_Char* pczConfigFilePath = "/opt/bosch/spi/xml/policy.xml";

using namespace shl::xml;
/***************************************************************************
** FUNCTION:  spi_tclDataServiceSettings::spi_tclDataServiceSettings()
***************************************************************************/
spi_tclDataServiceSettings::spi_tclDataServiceSettings()
   : m_bCdbGPSSeviceEnabled(false),
     m_bCdbLocationSeviceEnabled(false),
     m_bCdbMediaSinkEnabled(false),
     m_bCdbNaviSinkEnabled(false),
     m_bSubForEnvData(false),
     m_bSubForGearStatus(false),
     m_bSubForAcclData(false),
     m_bSubForGyroData(false),
     m_bSubForParkBrakeData(false),
     m_bIsBoschNavi(true),
     m_u32SpeedTimerIntervalInMs(0),
     m_bLocDataEnabled(true),
     m_bCdbPrivateSeviceEnabled(false),
     m_bCarlifeGPSSupportflag(false)

{
   ETG_TRACE_USR1(("spi_tclDataServiceSettings() entered "));
}

/***************************************************************************
** FUNCTION:  spi_tclDataServiceSettings::~spi_tclDataServiceSettings()
***************************************************************************/
spi_tclDataServiceSettings::~spi_tclDataServiceSettings()
{
   ETG_TRACE_USR1(("~spi_tclDataServiceSettings() entered "));
}

/***************************************************************************
** FUNCTION:  t_Bool spi_tclDataServiceSettings::bGetCdbGPSSeviceEnabled()
***************************************************************************/
t_Bool spi_tclDataServiceSettings::bGetCdbGPSSeviceEnabled() const
{
   ETG_TRACE_USR1(("spi_tclDataServiceSettings::bGetCdbGPSSeviceEnabled: %u ",
         ETG_ENUM(BOOL, m_bCdbGPSSeviceEnabled)));
   return m_bCdbGPSSeviceEnabled;
}

/***************************************************************************
** FUNCTION:  t_Bool spi_tclDataServiceSettings::bGetCdbLocationSeviceEnabled()
***************************************************************************/
t_Bool spi_tclDataServiceSettings::bGetCdbLocationSeviceEnabled() const
{
   ETG_TRACE_USR1(("spi_tclDataServiceSettings::bGetCdbLocationSeviceEnabled: %u ",
            ETG_ENUM(BOOL, m_bCdbLocationSeviceEnabled)));
   return m_bCdbLocationSeviceEnabled;
}

/***************************************************************************
** FUNCTION:  t_Bool spi_tclDataServiceSettings::bGetCdbPrivateSeviceEnabled()
***************************************************************************/
t_Bool spi_tclDataServiceSettings::bGetCdbPrivateSeviceEnabled() const
{
   ETG_TRACE_USR1(("spi_tclDataServiceSettings::bGetCdbPrivateSeviceEnabled: %u ",
            ETG_ENUM(BOOL, m_bCdbPrivateSeviceEnabled)));
   return m_bCdbPrivateSeviceEnabled;
}

/***************************************************************************
** FUNCTION:  t_Bool spi_tclDataServiceSettings::bGetCdbMediaMetadataSinkEnabled()
***************************************************************************/
t_Bool spi_tclDataServiceSettings::bGetCdbMediaMetadataSinkEnabled() const
{
   ETG_TRACE_USR1(("spi_tclDataServiceSettings::bGetCdbMediaMetadataSinkEnabled: %u ",
            ETG_ENUM(BOOL, m_bCdbMediaSinkEnabled)));
   return m_bCdbMediaSinkEnabled;
}

/***************************************************************************
** FUNCTION:  t_Bool spi_tclDataServiceSettings::bGetCdbNavMetadataSinkEnabled()
***************************************************************************/
t_Bool spi_tclDataServiceSettings::bGetCdbNaviMetadataSinkEnabled() const
{
   ETG_TRACE_USR1(("spi_tclDataServiceSettings::bGetCdbNavMetadataSinkEnabled: %u ",
            ETG_ENUM(BOOL, m_bCdbNaviSinkEnabled)));
   return m_bCdbNaviSinkEnabled;
}

/***************************************************************************
** FUNCTION:  t_Bool spi_tclDataServiceSettings::bGetEnvDataSubEnabled()
***************************************************************************/
t_Bool spi_tclDataServiceSettings::bGetEnvDataSubEnabled() const
{
   ETG_TRACE_USR1(("spi_tclDataServiceSettings:::bGetEnvDataSubEnabled() entered "));
   ETG_TRACE_USR2(("[DESC]:The value for enabling environment status data is = %d ",
   m_bSubForEnvData));
   return m_bSubForEnvData;
}

/***************************************************************************
** FUNCTION:  t_Bool spi_tclDataServiceSettings::bGetGearStatusEnabled()
***************************************************************************/
t_Bool spi_tclDataServiceSettings::bGetGearStatusEnabled() const
{
   ETG_TRACE_USR1(("spi_tclDataServiceSettings:::bGetGearStatusEnabled() entered "));
   ETG_TRACE_USR2(("[DESC]:The value for enabling gear status data is = %d ",
   m_bSubForGearStatus));
   return m_bSubForGearStatus;
}

/***************************************************************************
** FUNCTION:  t_Bool spi_tclDataServiceSettings::bGetAccelerometerDataDisable()
***************************************************************************/
t_Bool spi_tclDataServiceSettings::bGetAccelerometerDataEnabled() const
{
   ETG_TRACE_USR1(("spi_tclDataServiceSettings:::bGetAccelerometerDataEnabled() entered "));
   ETG_TRACE_USR2(("[DESC]:The value for enabling accelerometer data is = %d ",
   	m_bSubForAcclData));
   return m_bSubForAcclData;
}

/***************************************************************************
** FUNCTION:  t_Bool spi_tclDataServiceSettings::bIsBochNavigation()
***************************************************************************/
t_Bool spi_tclDataServiceSettings::bIsBochNavigation() const
{
   ETG_TRACE_USR2(("[DESC]:Is Navigation from bosch = %d ",
   ETG_ENUM(BOOL,m_bIsBoschNavi)));
   return m_bIsBoschNavi;
}

/***************************************************************************
** FUNCTION:  t_Bool spi_tclDataServiceSettings::bGetGyroDataDisabled()
***************************************************************************/
t_Bool spi_tclDataServiceSettings::bGetGyroDataEnabled() const
{
   ETG_TRACE_USR1(("spi_tclDataServiceSettings::bGetGyroDataEnabled() entered "));
   ETG_TRACE_USR2(("[DESC]:The value for enabling Gyro data is = %d ",
   m_bSubForGyroData));
   return m_bSubForGyroData;
}

/***************************************************************************
** FUNCTION:  t_Bool spi_tclDataServiceSettings::bGetParkBrakeDataEnabled()
***************************************************************************/
t_Bool spi_tclDataServiceSettings::bGetParkBrakeDataEnabled() const
{
   ETG_TRACE_USR1(("spi_tclDataServiceSettings::bGetParkBrakeDataEnabled() entered "));
   ETG_TRACE_USR2(("[DESC]:The value for enabling Park Brake data is = %d ",
            m_bSubForParkBrakeData));
   return m_bSubForParkBrakeData;
}

/***************************************************************************
** FUNCTION:  t_Bool spi_tclDataServiceSettings::u32GetSpeedTimerInterval()
***************************************************************************/
t_U32 spi_tclDataServiceSettings::u32GetSpeedTimerInterval()const
{
	ETG_TRACE_USR1(("spi_tclDataServiceSettings::u32GetSpeedTimerInterval() entered "));
	ETG_TRACE_USR2(("[DESC]:The value for speed frequency timer interval is = %d ",
			m_u32SpeedTimerIntervalInMs));
    return m_u32SpeedTimerIntervalInMs;
}

/***************************************************************************
** FUNCTION:  t_Bool spi_tclDataServiceSettings::bGetLocDataEnabled()
***************************************************************************/
t_Bool spi_tclDataServiceSettings::bGetLocDataEnabled() const
{
   ETG_TRACE_USR1(("spi_tclDataServiceSettings::bGetLocDataEnabled() entered "));
   ETG_TRACE_USR2(("[DESC]:The value for Location data enabled is = %d ",
            m_bLocDataEnabled));
    return m_bLocDataEnabled;
}

/***************************************************************************
** FUNCTION:  t_Bool spi_tclDataServiceSettings::bGetCarlifeGPSDataSupportflag()
***************************************************************************/
t_Bool spi_tclDataServiceSettings::bGetCarlifeGPSDataSupportflag() const
{
   ETG_TRACE_USR1(("spi_tclDataServiceSettings::bGetCarlifeGPSDataSupportflag() entered "));
   ETG_TRACE_USR2(("[DESC]:The value of GPS support flag  for Carlife is = %d ",
            m_bCarlifeGPSSupportflag));
    return m_bCarlifeGPSSupportflag;
}
/***************************************************************************
** FUNCTION:  t_Void spi_tclDataServiceSettings::vReadDataServiceSettings()
***************************************************************************/
t_Void spi_tclDataServiceSettings::vReadDataServiceSettings()
{
   ETG_TRACE_USR1(("spi_tclDataServiceSettings::vReadDataServiceSettings() entered "));

   //Check the validity of the xml file
   spi::io::FileHandler oPolicySettingsFile(pczConfigFilePath, spi::io::SPI_EN_RDONLY);
   if (true == oPolicySettingsFile.bIsValid())
   {
      tclXmlDocument oXmlDoc(pczConfigFilePath);
      tclXmlReader oXmlReader(&oXmlDoc, this);

      oXmlReader.bRead("DATASERVICE");
   } // if (true == oPolicySettingsFile.bIsValid())
}

/*************************************************************************
** FUNCTION:  t_Bool spi_tclDataServiceSettings::bXmlReadNode(xmlNode *poNode)
*************************************************************************/
t_Bool spi_tclDataServiceSettings::bXmlReadNode(xmlNodePtr poNode)
{
   ETG_TRACE_USR1(("spi_tclDataServiceSettings::bXmlReadNode() entered "));

   t_String szAttrName;
   t_Bool bRetVal = false;
   t_String szNodeName;
   t_S32 s32Value = 0;

   if (NULL != poNode)
   {
      szNodeName = (const t_Char *) (poNode->name);
   } // if (NULL != poNode)

   if ("CDB_GPS_SERVICE" == szNodeName)
   {
      szAttrName = "BOOL";
      bRetVal = bGetAttribute(szAttrName, poNode, m_bCdbGPSSeviceEnabled);
      ETG_TRACE_USR4(("bXmlReadNode(): CDB GPS Service enabled = %d ", ETG_ENUM(BOOL,m_bCdbGPSSeviceEnabled)));
   }
   else if ("CDB_LOCATION_SERVICE" == szNodeName)
   {
      szAttrName = "BOOL";
      bRetVal = bGetAttribute(szAttrName, poNode, m_bCdbLocationSeviceEnabled);
      ETG_TRACE_USR4(("bXmlReadNode(): CDB Location Service enabled = %d ", ETG_ENUM(BOOL,m_bCdbLocationSeviceEnabled)));
   } //if ("CDB_LOCATION_SERVICE" == szNodeName)
   else if ("CDB_PRIVATE_SERVICE" == szNodeName)
   {
      szAttrName = "BOOL";
      bRetVal = bGetAttribute(szAttrName, poNode, m_bCdbPrivateSeviceEnabled);
      ETG_TRACE_USR4(("bXmlReadNode(): CDB Private Service enabled = %d ", ETG_ENUM(BOOL,m_bCdbPrivateSeviceEnabled)));
   } //if ("CDB_PRIVATE_SERVICE" == szNodeName) 
   else if ("ENVIRONMENT_DATA_SUB" == szNodeName)
   {
      szAttrName = "BOOL";
      bRetVal = bGetAttribute(szAttrName, poNode, m_bSubForEnvData);
      ETG_TRACE_USR4(("bXmlReadNode(): Subscribe For Environment Data = %d ", ETG_ENUM(BOOL,m_bSubForEnvData)));
   } //if ("CDB_LOCATION_SERVICE" == szNodeName)
   else if ("GEAR_STATUS" == szNodeName)
   {
      szAttrName = "BOOL";
      bRetVal = bGetAttribute(szAttrName, poNode, m_bSubForGearStatus);
      ETG_TRACE_USR4(("bXmlReadNode(): Subscribe For gear status = %d ", ETG_ENUM(BOOL,m_bSubForGearStatus)));
   }
   else if ("ACCELEROMETER_DATA" == szNodeName)
   {
      szAttrName = "BOOL";
      bRetVal = bGetAttribute(szAttrName, poNode,  m_bSubForAcclData);
      ETG_TRACE_USR4(("bXmlReadNode(): Subscribe For accelerometer data = %d ", ETG_ENUM(BOOL,m_bSubForAcclData)));
   }
   else if ("GYRO_DATA" == szNodeName)
   {
      szAttrName = "BOOL";
      bRetVal = bGetAttribute(szAttrName, poNode, m_bSubForGyroData);
      ETG_TRACE_USR4(("bXmlReadNode(): Subscribe For gyro Data = %d ", ETG_ENUM(BOOL,m_bSubForGyroData)));
   }
   else if ("PARKBRAKE_DATA" == szNodeName)
   {
      szAttrName = "BOOL";
      bRetVal = bGetAttribute(szAttrName, poNode, m_bSubForParkBrakeData);
      ETG_TRACE_USR4(("bXmlReadNode(): Subscribe For Park Brake Data = %d ", ETG_ENUM(BOOL,m_bSubForParkBrakeData)));
   }
   else if ("BOSCH_NAVI" == szNodeName)
   {
      szAttrName = "BOOL";
      bRetVal = bGetAttribute(szAttrName, poNode, m_bIsBoschNavi);
      ETG_TRACE_USR4(("bXmlReadNode(): Is navigation data from bosch = %d ", ETG_ENUM(BOOL,m_bIsBoschNavi)));
   }
   else if("SPEED_TIMER_INTERVAL" == szNodeName)
   {
	   szAttrName = "VALUE";
	   bRetVal = bGetAttribute(szAttrName, poNode,s32Value);
	   m_u32SpeedTimerIntervalInMs = (t_U32) s32Value;
	   ETG_TRACE_USR4(("bXmlReadNode(): Speed Update Timer Interval value = %d ",m_u32SpeedTimerIntervalInMs));
   }
   else if("CDB_MEDIA_METADATA_SINK" == szNodeName)
   {
      szAttrName = "BOOL";
      bRetVal = bGetAttribute(szAttrName, poNode, m_bCdbMediaSinkEnabled);
      ETG_TRACE_USR4(("bXmlReadNode(): CDB Media Sink enabled = %d ", ETG_ENUM(BOOL,m_bCdbMediaSinkEnabled)));
   }
   else if ("CDB_NAV_METADATA_SINK" == szNodeName)
   {
      szAttrName = "BOOL";
      bRetVal = bGetAttribute(szAttrName, poNode, m_bCdbNaviSinkEnabled);
      ETG_TRACE_USR4(("bXmlReadNode(): CDB Navi Sink enabled = %d ", ETG_ENUM(BOOL,m_bCdbNaviSinkEnabled)));
   }
   else if("LOC_DATA_ENABLED" == szNodeName)
   {
      szAttrName = "BOOL";
      bRetVal = bGetAttribute(szAttrName, poNode, m_bLocDataEnabled);
      ETG_TRACE_USR4(("bXmlReadNode(): Location data enabled value = %d ",m_bLocDataEnabled));
   }
   else if("CARLIFE_GPS_ENABLED" == szNodeName)
   {
      szAttrName = "BOOL";
      bRetVal = bGetAttribute(szAttrName, poNode, m_bCarlifeGPSSupportflag);
      ETG_TRACE_USR4(("bXmlReadNode(): The value of GPS support flag  for Carlife is = %d ",m_bCarlifeGPSSupportflag));
   }
   return bRetVal;
}
///////////////////////////////////////////////////////////////////////////////
// <EOF>
