/***********************************************************************/
/*!
 * \file  spi_tclAppSettings.cpp
 * \brief Class to get the App Mngr Settings
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Class to get the App Mngr Settings
 AUTHOR:         Shiva Kumar Gurija
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 16.02.2014  | Shiva Kumar Gurija    | Initial Version
 23.04.2014  | Shiva Kumar Gurija    | Updated with the elements for Notifications&
 CTS Testing
 29.04.2014  | Shiva Kumar Gurija    | Changes for Locale Mapping
 13.05.2014  | Ramya Murthy          | Implemented persistent Notification on/off
 setting using Datapool.
 21.05.2014  | Shiva Kumar Gurija    | Changes to use ML1.x or above Phones
 03.07.2015  | Shiva Kumar Gurija    | improvements in ML Version checking

 \endverbatim
 *************************************************************************/

/******************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |----------------------------------------------------------------------------*/
#include "FileHandler.h"
#include "XmlDocument.h"
#include "XmlReader.h"
#include "spi_tclAppSettings.h"

#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_CONFIGREADER
#include "trcGenProj/Header/spi_tclAppSettings.cpp.trc.h"
#endif
#endif

static const t_Char coczG3GXmlConfigFile[] = "/opt/bosch/spi/xml/policy.xml";

/*! 
 * \brief Mapped the enum values to respective region codes as mentioned in the CCC Specifications.
 * refer to the document CCC-TS-024-Mirrorlink_UPnPApplicationServerService section A_ARG_TYPE_AppCertificateInfo
 * for more details.
 *
 * e8_INVALID is used to know that the End of Array is used
 */
static const trLocaleMap saLocaleMapping[] = { { e8_WORLD, "WORLD" }, { e8_EU, "EU" }, { e8_EPE, "EPE" }, { e8_CAN,
         "CAN" }, { e8_USA, "USA" }, { e8_AMERICA, "AMERICA" }, { e8_AUS, "AUS" }, { e8_KOR, "KOR" }, { e8_JPN, "JPN" },
         { e8_CHN, "CHN" }, { e8_HKG, "HKG" }, { e8_TPE, "TPE" }, { e8_IND, "IND" }, { e8_APAC, "APAC" }, { e8_AFRICA,
                  "AFRICA" }, { e8_INVALID, "" } };

using namespace shl::xml;
/***************************************************************************
 ** FUNCTION:  spi_tclAppSettings::spi_tclAppSettings()
 ***************************************************************************/
spi_tclAppSettings::spi_tclAppSettings() :
                  m_szRegion("WORLD"),
                  m_bNonCertAppsReq(false),
                  m_bEnableCTSTest(false),
                  m_bEnableAAPNavigation(false),
                  m_bEnableAAPNotification(false),
                  m_bEnableAAPMediaPlayback(false),
                  m_bEnableTBTUpdates(false),
                  m_bEnableAssistantGuideUpdates(false),
                  m_bAllowAllMLApps(false)
{
   //add code
}

/***************************************************************************
 ** FUNCTION:  spi_tclAppSettings::~spi_tclAppSettings()
 ***************************************************************************/
spi_tclAppSettings::~spi_tclAppSettings()
{
   //Add code
}

/***************************************************************************
 ** FUNCTION: t_Void spi_tclAppSettings::vSetRegion(.)
 ***************************************************************************/
t_Void spi_tclAppSettings::vSetRegion(tenRegion enRegion)
{
   ETG_TRACE_USR1(("spi_tclAppSettings::Region:%d", ETG_ENUM(REGION_TYPE, enRegion)));
   for (t_U8 u8Index = 0; saLocaleMapping[u8Index].enRegion != e8_INVALID; u8Index++)
   {
      if (saLocaleMapping[u8Index].enRegion == enRegion)
      {
         m_oRegionLock.s16Lock();
         m_szRegion = saLocaleMapping[u8Index].szRegion.c_str();
         ETG_TRACE_USR4(("spi_tclAppSettings::Region:%s", m_szRegion.c_str()));
         m_oRegionLock.vUnlock();
         break;
      } //if(saLocaleMapping[u8Index].u8Loc
   } //for(t_U8 u8Index=0;saLoca
}

/***************************************************************************
 ** FUNCTION:  t_String spi_tclAppSettings::szGetRegion()
 ***************************************************************************/
t_String spi_tclAppSettings::szGetRegion()
{
   //ETG_TRACE_USR1(("spi_tclAppSettings::szGetRegion:%s\n",m_szLocale.c_str()));
   m_oRegionLock.s16Lock();
   t_String szRegion = m_szRegion.c_str();
   m_oRegionLock.vUnlock();

   return szRegion.c_str();
}

/***************************************************************************
 ** FUNCTION:  t_Bool spi_tclAppSettings::bNonCertAppsReq()
 ***************************************************************************/
t_Bool spi_tclAppSettings::bNonCertAppsReq()
{

   ETG_TRACE_USR1(("spi_tclAppSettings::bNonCertAppsReq:%d\n", ETG_ENUM(BOOL, m_bNonCertAppsReq)));

   return m_bNonCertAppsReq;
}

/***************************************************************************
 ** FUNCTION: t_Bool spi_tclAppSettings::bEnableCTSTest()
 ***************************************************************************/
t_Bool spi_tclAppSettings::bEnableCTSTest()
{
   ETG_TRACE_USR1(("spi_tclAppSettings::bEnableCTSTest-%d", ETG_ENUM(BOOL, m_bEnableCTSTest)));

   return m_bEnableCTSTest;
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclAppSettings::vReadAppSettings()
 ***************************************************************************/
t_Void spi_tclAppSettings::vReadAppSettings()
{
   ETG_TRACE_USR1(("spi_tclAppSettings::vReadAppSettings\n"));
   const t_Char* pczConfigFilePath = NULL;
   pczConfigFilePath = coczG3GXmlConfigFile;

   //Check the validity of the xml file
   spi::io::FileHandler oPolicySettingsFile(pczConfigFilePath, spi::io::SPI_EN_RDONLY);
   if (true == oPolicySettingsFile.bIsValid())
   {
      tclXmlDocument oXmlDoc(pczConfigFilePath);
      tclXmlReader oXmlReader(&oXmlDoc, this);

      oXmlReader.bRead("APPMNGR");
   } // if (true == oPolicySettingsFile.bIsValid())
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclAppSettings::vDisplayAppSettings()
 ***************************************************************************/
t_Void spi_tclAppSettings::vDisplayAppSettings()
{

   ETG_TRACE_USR4(("vDisplayAppSettings: Filter Non certified applications - %d", ETG_ENUM(BOOL, m_bNonCertAppsReq)));
}

/***************************************************************************
 ** FUNCTION: t_Bool spi_tclAppSettings::bEnableTestApps()
 ***************************************************************************/
t_Bool spi_tclAppSettings::bEnableAAPNavigation()
{
   ETG_TRACE_USR1(("spi_tclAppSettings::vEnableNavigation - %d", ETG_ENUM(BOOL, m_bEnableAAPNavigation)));
   return m_bEnableAAPNavigation;
}

/***************************************************************************
 ** FUNCTION: t_Bool spi_tclAppSettings::bEnableAAPMediaPlayback()
 ***************************************************************************/
t_Bool spi_tclAppSettings::bEnableAAPMediaPlayback()
{
   ETG_TRACE_USR1(("spi_tclAppSettings::vEnableMediaPlayback - %d", ETG_ENUM(BOOL, m_bEnableAAPMediaPlayback)));
   return m_bEnableAAPMediaPlayback;
}

/***************************************************************************
 ** FUNCTION: t_Bool spi_tclAppSettings::bEnableTestApps()
 ***************************************************************************/
t_Bool spi_tclAppSettings::bEnableAAPNotification()
{
   ETG_TRACE_USR1(("spi_tclAppSettings::vEnableNotification - %d", ETG_ENUM(BOOL, m_bEnableAAPNotification)));

   return m_bEnableAAPNotification;
}

/***************************************************************************
 ** FUNCTION: t_Void spi_tclAppSettings::bGetTBTUpdatesEnabledInfo()
 ***************************************************************************/
t_Bool spi_tclAppSettings::bGetTBTUpdatesEnabledInfo()
{
   ETG_TRACE_USR1(("spi_tclAppSettings::TBTUpdatesEnabledInfo - %d", ETG_ENUM(BOOL, m_bEnableTBTUpdates)));

   return m_bEnableTBTUpdates;
}

/***************************************************************************
 ** FUNCTION: t_Void spi_tclAppSettings::bGetAssisstantGuideUpdatesEnabledInfo()
 ***************************************************************************/
t_Bool spi_tclAppSettings::bGetAssisstantGuideUpdatesEnabledInfo()
{
   ETG_TRACE_USR1(("spi_tclAppSettings::AssisstantGuideUpdatesEnabledInfo - %d", ETG_ENUM(BOOL,
            m_bEnableAssistantGuideUpdates)));

   return m_bEnableAssistantGuideUpdates;
}

/***************************************************************************
 ** FUNCTION: t_Bool spi_tclAppSettings::bGetNonCertAppAllowedInfo()
 ***************************************************************************/
t_Bool spi_tclAppSettings::bGetNonCertAppAllowedInfo()
{
   ETG_TRACE_USR1(("spi_tclAppSettings::bGetNonCertAppAllowedInfo - %d", ETG_ENUM(BOOL, m_bAllowAllMLApps)));

   return m_bAllowAllMLApps;
}

/*************************************************************************
 ** FUNCTION:  t_Bool spi_tclAppSettings::bXmlReadNode(xmlNode *poNode)
 *************************************************************************/
t_Bool spi_tclAppSettings::bXmlReadNode(xmlNodePtr poNode)
{
   ETG_TRACE_USR1(("spi_tclAppSettings::bXmlReadNode()"));

   t_String szAttrName;
   t_Bool bRetVal = false;
   t_String szNodeName;

   if (NULL != poNode)
   {
      szNodeName = (const t_Char *) (poNode->name);
   } // if (NULL != poNode)

   if ("NONCERTAPPS" == szNodeName)
   {
      szAttrName = "BOOL";
      bRetVal = bGetAttribute(szAttrName, poNode, m_bNonCertAppsReq);
      ETG_TRACE_USR2(("spi_tclAppSettings::bXmlReadNode: Filter Non certified applications - %d", ETG_ENUM(BOOL,
               m_bNonCertAppsReq)));
   } //else if ("FILTERNONCERTAPPS" == szNodeName)
   else if ("ENABLE_CTS_TEST" == szNodeName)
   {
      szAttrName = "BOOL";
      bRetVal = bGetAttribute(szAttrName, poNode, m_bEnableCTSTest);
      ETG_TRACE_USR2(("spi_tclAppSettings::bXmlReadNode: Filter Non certified applications - %d", ETG_ENUM(BOOL,
               m_bEnableCTSTest)));
   }
   else if ("ENABLE_AAP_NAVIGATION" == szNodeName)
   {
      szAttrName = "BOOL";
      bRetVal = bGetAttribute(szAttrName, poNode, m_bEnableAAPNavigation);
      ETG_TRACE_USR2(("spi_tclAppSettings::bXmlReadNode: Enable AAP Navigation value - %d", ETG_ENUM(BOOL,
               m_bEnableAAPNavigation)));
   }
   else if ("ENABLE_AAP_NOTIFICATION" == szNodeName)
   {
      szAttrName = "BOOL";
      bRetVal = bGetAttribute(szAttrName, poNode, m_bEnableAAPNotification);
      ETG_TRACE_USR2(("spi_tclAppSettings::bXmlReadNode: Enable AAP Notification value- %d", ETG_ENUM(BOOL,
               m_bEnableAAPNotification)));
   }
   else if ("ENABLE_AAP_MEDIAPLAYBACK" == szNodeName)
   {
      szAttrName = "BOOL";
      bRetVal = bGetAttribute(szAttrName, poNode, m_bEnableAAPMediaPlayback);
      ETG_TRACE_USR2(("spi_tclAppSettings::bXmlReadNode: Enable AAP MediaPlayback value- %d", ETG_ENUM(BOOL,
               m_bEnableAAPMediaPlayback)));
   }
   else if ("ENABLE_TBT_UPDATES" == szNodeName)
   {
      szAttrName = "BOOL";
      bRetVal = bGetAttribute(szAttrName, poNode, m_bEnableTBTUpdates);
      ETG_TRACE_USR2(("spi_tclAppSettings::bXmlReadNode: Enable TBT Updates value- %d", ETG_ENUM(BOOL,
               m_bEnableTBTUpdates)));
   }
   else if ("ENABLE_ASSISTANT_GUIDE_UPDATES" == szNodeName)
   {
      szAttrName = "BOOL";
      bRetVal = bGetAttribute(szAttrName, poNode, m_bEnableAssistantGuideUpdates);
      ETG_TRACE_USR2(("spi_tclAppSettings::bXmlReadNode: Enable Assistant guide updates value- %d", ETG_ENUM(BOOL,
               m_bEnableAssistantGuideUpdates)));
   }
   else if ("ENABLE_BLOCKING_IN_DRIVE_MODE" == szNodeName)
   {
      szAttrName = "BOOL";
      bRetVal = bGetAttribute(szAttrName, poNode, m_bAllowAllMLApps);
      ETG_TRACE_USR2(("spi_tclAppSettings::bXmlReadNode: Allow non certified ML apps in drive - %d", ETG_ENUM(BOOL,
               m_bAllowAllMLApps)));
   }
   return bRetVal;
}
///////////////////////////////////////////////////////////////////////////////
// <EOF>
