/*!
*******************************************************************************
* \file              spi_tclDatapooldefs.h
* \brief             Interface to include the user defined types that are used in datapool
*******************************************************************************
\verbatim
PROJECT:       GM Gen3
SW-COMPONENT:  Smart Phone Integration
DESCRIPTION:   Interface to include the user defined types that are used in datapool
COPYRIGHT:     &copy; RBEI

HISTORY:
Date       |  Author                      | Modifications
24.06.2014 |  Shiva Kumar G               | Initial version

\endverbatim
******************************************************************************/

#ifndef SPI_TCLDATAPOOLDEFS_H_
#define SPI_TCLDATAPOOLDEFS_H_

#define NUM_SPI_TECH e8DP_DEVCAT_MAX + 1
#define MAX_SIZE_CHAR_ARRAY 128

static const tU8 scou8dpMaxKeys = 50;

//! Identifies the different types of devices
typedef enum
{
   //Keep the enumeration values similar to enum tenDeviceCategory defined in SPITypes.h
   e8DP_DEVCAT_DIPO = 1,
   e8DP_DEVCAT_MIRRORLINK = 2,
   e8DP_DEVCAT_ANDROIDAUTO = 3,
   //! mySPIN Device
   e8DP_DEVCAT_MYSPIN = 4,
   //! Baidu Carlife Device
   e8DP_DEVCAT_CARLIFE = 5,
   //! OnCar Device
   e8DP_DEVCAT_ONCAR = 6,
   e8DP_DEVCAT_MAX,
   //! Default technology preference to use device in default mode
   e8DP_DEVCAT_DEFAULT = 0x0F
} tenDPDevCat;

//! Identifies the different types of touch display is supported screen
typedef enum
{
	//Keep the enumeration values similar to enum tenTouchEventType defined in SPITypes.h
    e8DP_SINGLETOUCH = 0,
    e8DP_MULTITOUCH = 1
}tenDPTouchEventType;

typedef struct rProjLayerAttributes
{
   tenDPDevCat enDPDevCat;
   tU16 u16TouchLayerID;
   tU16 u16TouchSurfaceID;
   tU16 u16VideoLayerID;
   tU16 u16VideoSurfaceID;
   tU16 u16LayerWidth;
   tU16 u16LayerHeight;
   tU16 u16DisplayHeightMm;
   tU16 u16DisplayWidthMm;
   tenDPTouchEventType enDPTouchEventType;
   tU16 u16dpi;
   tU16 u16PriorityIndex;
   tChar cPixelAspectRatio[MAX_SIZE_CHAR_ARRAY];
}trProjLayerAttributes;

//! Identifies the different types of display screen
typedef enum
{
   //Keep the enumeration values similar to enum tenDisplayType defined in SPITypes.h
   e8DP_RESISTIVE_SCREEN = 0,
   e8DP_CAPACITIVE_SCREEN = 1
}tenDPDisplayType;

typedef enum
{
	e8DP_LOW_FIDELITY = 0,
	e8DP_HIGH_FIDELITY = 1
}tenFidelityTouchType;

typedef struct rScreenProperties
{
   tU16 u16ScreenHeight;
   tU16 u16ScreenWidth;
   tU16 u16ScreenHeightMm;
   tU16 u16ScreenWidthMm;
   tenDPDisplayType enDPDisplayType;
   tU16 u16DisplayLayerAttributesSize;
   //STL vectors should not be stored in data pool, since vector class includes it's own management structures
   //and size varies dynamically.
   trProjLayerAttributes aProjLayerAttr[NUM_SPI_TECH];
}trScreenProperties;

typedef enum
{
	e8DP_POSITION_UNKNOWN = 0x0,
	e8DP_POSITION_LEFT = 0x1,
	e8DP_POSITION_RIGHT = 0x2
}tenSteeringWheelPosition;

typedef enum
{
	e8DP_UNKNOWN_DRIVE_SIDE = 0,
	e8DP_LEFT_HAND_DRIVE = 1,
	e8DP_RIGHT_HAND_DRIVE = 2

}tenDriverPositionInfo;

typedef struct
{
	tChar cOEMName[MAX_SIZE_CHAR_ARRAY];
	tChar cOEMPath[MAX_SIZE_CHAR_ARRAY];
}trOEMICONDetails;

typedef struct rVehicleManufacturerInformation
{
	tChar cVehicleMake[MAX_SIZE_CHAR_ARRAY];
	tChar cVehicleModel[MAX_SIZE_CHAR_ARRAY];
	tChar cVehicleModelYear[MAX_SIZE_CHAR_ARRAY];
	tChar cVehicleHUMake[MAX_SIZE_CHAR_ARRAY];
	tChar cVehicleHUModel[MAX_SIZE_CHAR_ARRAY];
	tChar cVehicleHUSwVersion[MAX_SIZE_CHAR_ARRAY];
	tChar cVehicleHUHwVersion[MAX_SIZE_CHAR_ARRAY];
	tChar cVehicleHUSwBuild[MAX_SIZE_CHAR_ARRAY];
	tenDriverPositionInfo enDriverPositionInfo;
	tU16 u16SupportedSPITechnologiesInfo;
	tBool bIsNativeNavSupported;
	trOEMICONDetails rOEMIconDetails;
	tBool bIsRotaryCtrlSupported;
	tenFidelityTouchType enFidelityType;

}trVMInfo;
#endif //SPI_TCLDATAPOOLDEFS_H_
