/*
 * spi_tclMediatorIntf.h
 *
 *  Created on: Oct 31, 2016
 *      Author: ptr4kor
 */

#ifndef SPI_TCLMEDIATORINTF_H_
#define SPI_TCLMEDIATORINTF_H_

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/
#include <functional>
#include "GenericSingleton.h"
#include "SPITypes.h"
#include "spi_ConnMngrTypeDefines.h"
#include "spi_WifiTypedefs.h"
#include "spi_BluetoothTypedefs.h"

/******************************************************************************
 | defines and macros and constants(scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

//lint -save -e1055 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1013 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1401 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e601 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e19 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e10 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e55 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e58 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e48 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e808 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e63 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e40 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e64 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e746 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e515 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e516 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e601 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported

//! Callback signatures definitions: To be registered by the SPI component
/*lint -esym(40,function)function Undeclared identifier */
//! Callback for Posting device selection result
typedef std::function<t_Void(tenCompID, tenErrorCode)> tfvOnSelectDeviceRes;
//! Callback for posting device disconnection
typedef std::function<t_Void(t_U32)> tfvOnDeviceDisconnection;
//! Callback for posting device connection
typedef std::function<t_Void(t_U32)> tfvOnDeviceConnection;
//! Callback for posting device connection status to Diagnosis
typedef std::function<t_Void(t_U32, t_U32, t_U32)> tfvOnDeviceConnectionStatus;
//! Callback for posting device disconnection status to Diagnosis
typedef std::function<t_Void(t_U32)> tfvOnDeviceDisconnectionStatus;
//! Callback for automatically selecting device
typedef std::function<void(t_U32, tenDeviceConnectionReq, tenDeviceCategory,tenSelectReason)> tfvAutoSelectDevice;
//! Callback for setting user deselect flag
typedef std::function<void(const t_U32, t_Bool)> tfvSetUserDeselect;
//! Callback for applying selection strategy
typedef std::function<void(tenDeviceCategory)> tfvApplySelStrategy;
//! Callback for setting DAY/Night
typedef std::function<void(tenVehicleConfiguration)> tfvSetDayNightMode;
//! Callback for providing BT Device name
typedef std::function<void(t_U32, t_String, t_String)> tfvSetBTDeviceInfo;
//!typedef - To Update the Terminate App Response
typedef std::function<t_Void(const tenCompID, const t_U32,const t_U32,tenErrorCode ,
                              const trUserContext&)> tvTerminateAppResult;
//!typedef - To Update the Launch App Response
typedef std::function<t_Void(const tenCompID, const t_U32,const t_U32,const tenDiPOAppType,tenErrorCode ,
                             const trUserContext&)> tvLaunchAppResult;
//! Callback for InitiateWirelessDiscovery result
typedef std::function<t_Void(t_Bool)> tfvInitiateWirelessDiscoveryResult;
//! Callback for BT Limitation mode result
typedef std::function<t_Void(const trBTLimitationModeInfo)> tfvBTLimitationModeStatus;

//! callback to send WiFi credentials to requested client after user consent
typedef std::function<t_Void(t_String)> tfvSendWiFiCredentials;
typedef std::function<t_Void(t_Bool)> tfvSetBTLimModeResult;

//! callback to send different App States.
typedef std::function<void(tenSpeechAppState,tenPhoneAppState,tenNavAppState)> tfvAppStateStatus;

typedef std::function<t_Void(t_U32)> tfvDeviceChanged;

typedef std::function<t_Void(t_Bool)> tfvOnHUWiFiAPStateChange;

typedef std::function<t_Void(t_String)> tfvOnDisableBluetoothTrigger;

typedef std::function<t_Void(const t_String&)> tfvEvaluateInitialModes;

//Callbacks to update the session error status from BDCLConnmngr to Resource Mngr
typedef std::function<t_Void(t_U32, tenDeviceCategory, tenSessionStatus)> tfvUpdateSessionStatus;

//callbacks once the device connects to AP
typedef std::function<t_Void(const t_U32, t_Bool&)> tfvOnDeviceConnectsToWirelessAP;
typedef std::function<t_Void(const trUserContext&, t_String, tenDeviceCategory)> tfvInitiateWirelessDiscovery;

//! callbacks for HandlingInitiateWirelessDiscovery
typedef std::function<t_Void(trDeviceSelectionStateDetails &)> tfvGetDeviceSelectorCurrentSelectionState;

//! callbacks to set the selection state to Selected on Retrail
typedef std::function<t_Void(const t_U32)> tfvOnRetrailSetDeviceSelectionState;

typedef std::function<t_Void(const t_U32)> tfvDeviceDisconnectCb;

/******************************************************************************
 | variable definition (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/
/*!
 * \brief Structure holding the callbacks to be registered by the
 * Creator of this class object
 */
struct trSelectDeviceCallbacks
{
    /*lint -esym(40,fvOnSelectDeviceRes)fvOnSelectDeviceRes Undeclared identifier */
      //! Informs Result of the select device
      tfvOnSelectDeviceRes fvOnSelectDeviceRes;

      //! Informs when a connected device is disconnected
      tfvOnDeviceDisconnection fvOnDeviceDisconnection;

      //! Informs new device connection
      tfvOnDeviceConnection fvOnDeviceConnection;

      //! informs when a device is automatically selected
      tfvAutoSelectDevice fvAutoSelectDevice;

      //! informs user device deactivation
      tfvSetUserDeselect fvSetUserDeselect;

      //! informas when device selection is applied
      tfvApplySelStrategy fvApplySelStrategy;

      //! informs when the Device update is received from mediaplayer for CPW_NOT_FEASIBLE
      tfvDeviceChanged fvDeviceChanged;

      //! triggered on WiFi state change on HU
      tfvOnHUWiFiAPStateChange fvOnHUWiFiAPStateChange;

      //! triggered which iphone device connects to carplay wireless AP
      tfvOnDeviceConnectsToWirelessAP fvOnDeviceConnectsToWirelessAP;

      //! triggered on InitiateWirelessDiscoverycb from HMI when there is already Session active or Selection is in Progress
      tfvGetDeviceSelectorCurrentSelectionState fvGetDeviceSelectorCurrentSelectionState;

      //! Setting the Selection state
      tfvOnRetrailSetDeviceSelectionState fvOnRetrailSetDeviceSelectionState;

      trSelectDeviceCallbacks() :
         fvOnSelectDeviceRes(NULL),
         fvOnDeviceDisconnection(NULL),
         fvOnDeviceConnection(NULL),
         fvAutoSelectDevice(NULL),
         fvSetUserDeselect(NULL),
         fvApplySelStrategy(NULL),
         fvDeviceChanged(NULL),
         fvOnHUWiFiAPStateChange(NULL),
         fvOnDeviceConnectsToWirelessAP(NULL),
         fvGetDeviceSelectorCurrentSelectionState(NULL),
         fvOnRetrailSetDeviceSelectionState(NULL)
         {
            //Add code
         }
};


/*!
* \brief Structure holding the callbacks to be registered by the
* Creator of this class object
*/
struct trDevDiagnosisCallback
{
      /*lint -esym(40,fvSetBTDeviceInfo)fvSetBTDeviceInfo Undeclared identifier */

	  //! Informs new device connection to Diagnosis
	  tfvOnDeviceConnectionStatus fvOnDeviceConnectionStatus;

	  //! Informs when a connected device is disconnected to Diagnosis
      tfvOnDeviceDisconnectionStatus fvOnDeviceDisconnectionStatus;

	  
      trDevDiagnosisCallback() :
         fvOnDeviceConnectionStatus(NULL),
		   fvOnDeviceDisconnectionStatus(NULL)
      {
         //Add code
      }
};

/*!
* \brief Structure holding the callbacks to be registered by the
* Creator of this class object
*/
struct trConnMngrCallback
{
      /*lint -esym(40,fvSetBTDeviceInfo)fvSetBTDeviceInfo Undeclared identifier */

      //! informs BT Device info of active projection device
      tfvSetBTDeviceInfo fvSetBTDeviceInfo;

      //!Sets the selection progress state
      tfvSelectionProgressState fvSelectionProgressState;
	  
    	 trConnMngrCallback() :
         fvSetBTDeviceInfo(NULL),
		 fvSelectionProgressState(NULL)
      {
         //Add code
      }
};

/*!
 * \brief Structure holding the callbacks to be registered by the
 * Creator of this class object
 */
struct trAppLauncherCallbacks
{
    /*lint -esym(40,fpvTerminateAppResult)fpvTerminateAppResult Undeclared identifier */
   //! Result of Terminate App request
   tvTerminateAppResult fpvTerminateAppResult;

   //! Result of Launch App request
   tvLaunchAppResult   fpvLaunchAppResult;

   trAppLauncherCallbacks():fpvTerminateAppResult(NULL),
      fpvLaunchAppResult(NULL)
   {
      //Add code
   }

};

/*!
 * \brief Structure holding the callbacks to be registered by the
 * Creator of this class object
 */
struct trAAPSensorCallback
{
      /*lint -esym(40,fvSetDayNightMode)fvSetDayNightMode Undeclared identifier */
      //! informs user about day/night mode
      tfvSetDayNightMode fvSetDayNightMode;

      trAAPSensorCallback() :
         fvSetDayNightMode(NULL)
      {
         //Add code
      }
};

/*!
 * \brief Structure holding the callbacks for OnCar to be registered by the
 * Creator of this class object
 */
struct trOnCarSensorCallback
{
      tfvSetDayNightMode fvSetDayNightMode;

      trOnCarSensorCallback() :
         fvSetDayNightMode(NULL)
      {
         //Add code
      }
};

/*!
 * \brief Structure holding the callbacks to be registered by the
 * Creator of this class object
 */
struct trWiFiSetupHndlrCallbacks
{
	tfvInitiateWirelessDiscoveryResult fvInitiateWirelessDiscoveryResult;
	tfvBTLimitationModeStatus fvBTLimitationModeStatus;
	tfvSendWiFiCredentials fvSendWiFiCredentials;
	tfvSetBTLimModeResult fvSetBTLimModeResult;
	tfvInitiateWirelessDiscovery fvInitiateWirelessDiscovery;

	trWiFiSetupHndlrCallbacks() :
		 fvInitiateWirelessDiscoveryResult(NULL),
		 fvBTLimitationModeStatus(NULL),
		 fvSendWiFiCredentials(NULL),
		 fvSetBTLimModeResult(NULL),
		 fvInitiateWirelessDiscovery(NULL)
	{

	}
};


/*!
* \brief Structure holding the callbacks to be registered by the
* Creator of this class object
*/
struct trNotifyDevAppStateCallbacks
{
   tfvAppStateStatus fvAppStateStatus;

   trNotifyDevAppStateCallbacks():
      fvAppStateStatus(NULL)

   {

   }
};

struct trNotifyRsrcMngrCbs
{
      tfvOnDisableBluetoothTrigger fvOnDisableBluetoothTrigger;
      tfvEvaluateInitialModes fvEvaluateInitialModes;
      tfvUpdateSessionStatus fvUpdateSessionStatus;
      trNotifyRsrcMngrCbs() :
      fvOnDisableBluetoothTrigger(nullptr), fvEvaluateInitialModes(nullptr), fvUpdateSessionStatus(NULL)
      {

      }
};

struct trDeviceDisconnectCb
{
    tfvDeviceDisconnectCb fvDeviceDisconnectCb;
    trDeviceDisconnectCb(): fvDeviceDisconnectCb(NULL)
    {
    }
};

class spi_tclMediatorIntf
{
   public:

      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/


      spi_tclMediatorIntf(){}
      /***************************************************************************
       ** FUNCTION:  spi_tclMediatorIntf::~spi_tclMediatorIntf
       ***************************************************************************/
      /*!
       * \fn     ~spi_tclMediatorIntf()
       * \brief  Destructor
       **************************************************************************/
      virtual ~spi_tclMediatorIntf(){}

      /***************************************************************************
       ** FUNCTION:  spi_tclMediatorIntf::vRegisterCallbacks(const trConnMngrCallback &rfrConnMngrCb)
       ***************************************************************************/
      /*!
       * \fn     vRegisterCallbacks(const trConnMngrCallback &rfrConnMngrCb)
       * \brief  Register for connection manager callbacks
       * \param  rfrConnMngrCb structure holding connection manager callbacks
       **************************************************************************/
      virtual t_Void vRegisterCallbacks(const trConnMngrCallback &rfrConnMngrCb) = 0;

      /***************************************************************************
       ** FUNCTION:  spi_tclMediatorIntf::vRegisterCallbacks(const trSelectDeviceCallbacks &rSelDevCb)
       ***************************************************************************/
      /*!
       * \fn     vRegisterCallbacks(const trSelectDeviceCallbacks &rSelDevCb)
       * \brief  Register for connection management callbacks
       * \param  rSelDevCb structure holding select device callbacks
       **************************************************************************/
      virtual t_Void vRegisterCallbacks(const trSelectDeviceCallbacks &rSelDevCb) = 0;

      /***************************************************************************
       ** FUNCTION:  spi_tclMediatorIntf::vRegisterCallbacks(const trDevDiagnosisCallback &rDevDiagnosisCb)
       ***************************************************************************/
      /*!
       * \fn     vRegisterCallbacks(const trDevDiagnosisCallback &rDevDiagnosisCb)
       * \brief  Register for connection management callbacks
       * \param  rDevDiagnosisCb structure holding device diagnosis callbacks
       **************************************************************************/
      virtual t_Void vRegisterCallbacks(const trDevDiagnosisCallback &rDevDiagnosisCb) = 0;	  

      /***************************************************************************
       ** FUNCTION:  spi_tclMediatorIntf::vRegisterCallbacks(const trAppLauncherCallbacks &corfrAppLauncherCb)
       ***************************************************************************/
      /*!
       * \fn     vRegisterCallbacks(const trAppLauncherCallbacks &corfrAppLauncherCb)
       * \brief  Register for Launch App callbacks
       * \param  corfrAppLauncherCb: [IN] structure holding AppLauncher callbacks
       **************************************************************************/
      virtual t_Void vRegisterCallbacks(const trAppLauncherCallbacks& corfrAppLauncherCb) = 0;

      /***************************************************************************
       ** FUNCTION:  spi_tclMediatorIntf::vRegisterCallbacks(const trAAPSensorCallback& corfrDayNightModeCb)
       ***************************************************************************/
      /*!
       * \fn     vRegisterCallbacks(const trAAPSensorCallback& corfrDayNightModeCb)
       * \brief  Register for DayNight callbacks
       * \param  corfrDayNightModeCb: [IN] structure holding DayNight callbacks
       **************************************************************************/
      virtual t_Void vRegisterCallbacks(const trAAPSensorCallback& corfrDayNightModeCb) = 0;

      /***************************************************************************
       ** FUNCTION:  spi_tclMediatorIntf::vRegisterCallbacks(const trWiFiSetupHndlrCallbacks& corfrDayNightModeCb)
       ***************************************************************************/
      /*!
       * \fn     vRegisterCallbacks(const trWiFiSetupHndlrCallbacks& corfrWiFiSetupHndlrCb)
       * \brief  Register for WiFiSetupHndlrCallbacks callbacks
       * \param  corfrWiFiSetupHndlrCb: [IN] structure holding WiFiSetupHndlr callbacks
       **************************************************************************/
      virtual t_Void vRegisterCallbacks(const trWiFiSetupHndlrCallbacks& corfrWiFiSetupHndlrCb) = 0;

      /***************************************************************************
       ** FUNCTION:  spi_tclMediatorIntf::vRegisterCallbacks(const trNotifyDevAppStateCallbacks &rAppStateCb)
       ***************************************************************************/
      /*!
       * \fn     vRegisterCallbacks(const trNotifyDevAppStateCallbacks &rAppStateCb)
       * \brief  Register for App State Callbacks
       * \param  rAppStateCb structure holding AppState callbacks
       **************************************************************************/
      virtual t_Void vRegisterCallbacks(const trNotifyDevAppStateCallbacks &corfrAppStateCb) = 0;

      /***************************************************************************
       ** FUNCTION:  spi_tclMediatorIntf::vRegisterCallbacks(const trNotifyRsrcMngrCbs
       ***************************************************************************/
      /*!
       * \fn     vRegisterCallbacks(const trNotifyRsrcMngrCbs &rNotifyRsrcMngrCbs)
       * \brief  Register for ResourceMngr related callbacks
       * \param  rNotifyRsrcMngrCbs structure holding callbacks
       **************************************************************************/
      virtual t_Void vRegisterCallbacks(const trNotifyRsrcMngrCbs &rNotifyRsrcMngrCbs) = 0;
      
      /***************************************************************************
       ** FUNCTION:  spi_tclMediatorIntf::vRegisterCallbacks(const trDeviceDisconnectCb& corfrDeviceDisconnectCb)
       ***************************************************************************/
      /*!
       * \fn     vRegisterCallbacks(const trDeviceDisconnectCb& corfrDeviceDisconnectCb)
       * \brief  Register for Device disconnect callback
       * \param  corfrDeviceDisconnectCb: [IN] structure holding Device disconnect callbacks
       **************************************************************************/
      virtual t_Void vRegisterCallbacks(const trDeviceDisconnectCb& corfrDeviceDisconnectCb) = 0;      

      /***************************************************************************
       ** FUNCTION: virtual t_Void spi_tclMediatorIntf::vPostSelectDeviceResult
       ***************************************************************************/
      /*!
       * \fn     vPostSelectDeviceResult
       * \brief  Called by SPI Component to post result for select device request
       * \param  enCompID : SPI component posting select device response
       * \param  enErrorCode   : Result of select device request
       * \sa     spi_tclCmdInterface::vSelectDevice
       **************************************************************************/
       virtual t_Void vPostSelectDeviceRes(tenCompID enCompID, tenErrorCode enErrorCode) = 0;

       /***************************************************************************
        ** FUNCTION:  spi_tclMediatorIntf::vPostDeviceConnection
        ***************************************************************************/
       /*!
        * \fn     vPostDeviceConnection()
        * \brief  Called by SPI component when a device is Connected
        * \param u32DeviceHandle: Device Handle of the device Connected
        **************************************************************************/
       virtual t_Void vPostDeviceConnection(const t_U32 u32DeviceHandle) = 0;

      /***************************************************************************
       ** FUNCTION:  spi_tclMediatorIntf::vPostDeviceDisconnection
       ***************************************************************************/
      /*!
       * \fn     vPostDeviceDisconnection()
       * \brief  Called by SPI component when a device is disconnected
       * \param u32DeviceHandle: Device Handle of the device disconnected
       **************************************************************************/
      virtual t_Void vPostDeviceDisconnection(const t_U32 u32DeviceHandle) = 0;

      /***************************************************************************
       ** FUNCTION:  spi_tclMediator::vPostDeviceDisconnectionStatus
       ***************************************************************************/
      /*!
       * \fn     vPostDeviceDisconnectionStatus()
       * \brief  Called by SPI component to inform Diagnosis when a device is disconnected
       * \param u32DeviceHandle: Device Handle of the device disconnected
       **************************************************************************/
      virtual t_Void vPostDeviceDisconnectionStatus(const t_U32 u32DeviceHandle) = 0;

      /***************************************************************************
       ** FUNCTION:  spi_tclMediator::vPostDeviceConnection
       ***************************************************************************/
      /*!
       * \fn     vPostDeviceConnection()
       * \brief  Called by SPI component to inform Diagnosis when a device is Connected
       * \param u32ProductID: ProductId of the device
       * \param u32VendorID: VendorId of the device
       * \param u32DeviceHandle: Device Handle of the device Connected
       **************************************************************************/
      virtual t_Void vPostDeviceConnectionStatus(const t_U32 u32ProductID, const t_U32 u32VendorID, const t_U32 u32DeviceHandle) = 0;

      /***************************************************************************
       ** FUNCTION:  spi_tclMediatorIntf::vPostAutoDeviceSelection
       ***************************************************************************/
      /*!
       * \fn     vPostAutoDeviceSelection()
       * \brief  Called by SPI component when a device is selected automatically
       *         by applying selection strategy
       * \param u32DeviceHandle: Device Handle
	   * \param enConnReq : SELECT/DESELECT
	   * \param enSelectReason : Reason for Trigger
	   * \param enDevCategory : Device Category
       **************************************************************************/
      virtual t_Void vPostAutoDeviceSelection(const t_U32 cou32DeviceHandle,
               tenDeviceConnectionReq enConnReq,
			   tenSelectReason enSelectReason = e8_REASON_UNKNOWN,
			   tenDeviceCategory enDevCategory = e8DEV_TYPE_UNKNOWN) = 0;

      /***************************************************************************
       ** FUNCTION:  spi_tclMediatorIntf::vPostSetUserDeselect
       ***************************************************************************/
      /*!
       * \fn     vPostSetUserDeselect()
       * \brief  Called by SPI component when a device is deselected as a result of
       *         user action
       * \param u32DeviceHandle: Device Handle
       **************************************************************************/
      virtual t_Void vPostSetUserDeselect(const t_U32 cou32DeviceHandle, t_Bool bUserDeselect) = 0;


      /***************************************************************************
       ** FUNCTION:  spi_tclMediatorIntf::vPostDayNightMode
       ***************************************************************************/
      /*!
       * \fn     vPostDayNightMode()
       * \brief  Called by SPI component to set Day/Night
       * \param enVehicleConfig: contains day/night
       **************************************************************************/
      virtual t_Void vPostDayNightMode(tenVehicleConfiguration enVehicleConfig) = 0;

      /***************************************************************************
       ** FUNCTION: virtual t_Void spi_tclMediatorIntf::vPostLaunchAppResult
       ***************************************************************************/
      /*!
       * \fn     vPostLaunchAppResult(
       *              cons tenCompID coenCompID
       *              const t_U32 cou32DevId,
       *              const t_U32 cou32AppId,
       *              const tenDiPOAppType coenDiPOAppType,
       *              tenErrorCode enErrorCode,
       *              const trUserContext& rfrCUsrCntxt)
       * \brief  To send the Terminate applications response to the registered
       *          classes
       * \param  coenCompID       : Uniquely identifies the target Device.
       * \param  cou32DevId       : Unique Device Id
       * \param  cou32AppId       : Application Id
       * \param  coenDiPOAppType  : DiPo App Type
       * \param  enErrorCode      : Error code
       * \param  rfrCUsrCntxt     : User Context
       **************************************************************************/
       virtual t_Void vPostLaunchAppResult(const tenCompID coenCompID,
          const t_U32 cou32DevId,
          const t_U32 cou32AppId,
          const tenDiPOAppType coenDiPOAppType,
          tenErrorCode enErrorCode,
          const trUserContext& rfrCUsrCntxt) = 0;

      /***************************************************************************
       ** FUNCTION: virtual t_Void spi_tclMediatorIntf::vPostTerminateAppResult
       ***************************************************************************/
      /*!
       * \fn     vPostTerminateAppResult(
       *              cons tenCompID coenCompID
       *              const t_U32 cou32DevId,
       *              const t_U32 cou32AppId,
       *              tenErrorCode enErrorCode,
       *              const trUserContext& rfrCUsrCntxt)
       * \brief  To send the Terminate applications response to the registered
       *          classes
       * \param  coenCompID       : Uniquely identifies the target Device.
       * \param  cou32DevId       : Unique Device Id
       * \param  cou32AppId       : Application Id
       * \param  enErrorCode      : Error code
       * \param  rfrCUsrCntxt     : User Context
       **************************************************************************/
       virtual t_Void vPostTerminateAppResult(const tenCompID coenCompID,
          const t_U32 cou32DevId,
          const t_U32 cou32AppId,
          tenErrorCode enErrorCode,
          const trUserContext& rfrCUsrCntxt) = 0;

       /***************************************************************************
        ** FUNCTION:  spi_tclMediatorIntf::vApplySelectionStrategy
        ***************************************************************************/
       /*!
        * \fn     vApplySelectionStrategy()
        * \brief  Called to trigger device selection automatically
        **************************************************************************/
       virtual t_Void vApplySelectionStrategy(tenDeviceCategory enDeviceCategory = e8DEV_TYPE_UNKNOWN) = 0;

       /***************************************************************************
        ** FUNCTION:  spi_tclMediatorIntf::vPostBTDeviceInfo
        ***************************************************************************/
       /*!
        * \fn     vPostBTDeviceInfo()
        * \brief  Called by SPI component when BT device info of active projection
        *         device becomes available
        * \param  u32DeviceHandle: Unique handle of projection device
        * \param  szBTDeviceName: BT Device name of projection device
        * \param  szBTAddress: BT Address of projection device
        **************************************************************************/
       virtual t_Void vPostBTDeviceInfo(t_U32 u32DeviceHandle, t_String szBTDeviceName,
             t_String szBTAddress) = 0;

       /***************************************************************************
        ** FUNCTION:  spi_tclMediatorIntf::vPostInitiateWirelessDiscoveryResult
        ***************************************************************************/
       /*!
        * \fn     vPostInitiateWirelessDiscoveryResult()
        * \brief  Called by SPI component when result of InitiateWirelessDiscovery
        *         operation is available
        * \param  bResult: true or false
        **************************************************************************/
       virtual t_Void vPostInitiateWirelessDiscoveryResult(t_Bool bResult) = 0;

       /***************************************************************************
        ** FUNCTION:  spi_tclMediatorIntf::vPostBTLimitationModeResult
        ***************************************************************************/
       /*!
        * \fn     vPostWiFiConfigResult()
        * \brief  Called by SPI component when BT Lim mode info is available
        * \param  corfrBTLimitationModeInfo: BT Lim mode info
        **************************************************************************/
       virtual t_Void vPostBTLimitationModeResult(const trBTLimitationModeInfo &corfrBTLimitationModeInfo) = 0;
	   
       /***************************************************************************
        ** FUNCTION:  t_Void spi_tclMediatorIntf::vPostWiFiCredentials
        ***************************************************************************/
       /*!
        * \fn     vPostWiFiCredentials(t_String szBTMACAddress)
        * \brief  Trigger to provide Wi-Fi Credentials to clients after the required BTLimitationMode is set.
        * \param  szBTMACAddress: Unique ID of the device
		* \retval t_Void
        **************************************************************************/	 	   
	   virtual t_Void vPostWiFiCredentials(t_String szBTMACAddress)=0;

	   /***************************************************************************
	    ** FUNCTION:  t_Void spi_tclMediatorIntf::vPostSelectionProgressState
	    *****************************************************************************/
	   /*!
	    * \fn     vPostSelectionProgressState(const t_U32 cou32DeviceHandle, tenDeviceSelectionProgressState enDeviceSelectionProgressState)
	    * \brief  Updates device selection progress state.
	    * \param  cou32DeviceHandle: [IN] Device ID
	    * \param  enDeviceSelectionProgressState : [IN] Selection Progress state
	    * \retval t_Void
	    **************************************************************************/
      virtual t_Void vPostSelectionProgressState(const t_U32 cou32DeviceHandle, tenDeviceSelectionProgressState enDeviceSelectionProgressState)=0;

      /***************************************************************************
       ** FUNCTION:  spi_tclMediatorIntf::vPostDevAppState
       ***************************************************************************/
      /*!
       * \fn     vPostAppStateSpeechStatus()
       * \brief  Called by SPI component to send speech app status
       * \param enSpeechAppState: Speech  states
       * \param  enPhoneAppState: phone states
       * \param enNavAppState: Navigation states
       **************************************************************************/
      virtual t_Void vPostDevAppState(tenSpeechAppState enSpeechAppState,
                                         tenPhoneAppState enPhoneAppState,
                                         tenNavAppState enNavAppState) = 0;
		
	   /***************************************************************************
	    ** FUNCTION:  spi_tclMediatorIntf::vPostDeviceChanged
	    ***************************************************************************/
	   /*!
	    * \fn     vPostDeviceChanged()
	    * \brief  Called by SPI component when a device is disconnected
	    * \param u32DeviceHandle: Device Handle of the device disconnected
	    **************************************************************************/
	   virtual t_Void vPostDeviceChanged(const t_U32 u32DeviceHandle) = 0;
	   
	   
	   /***************************************************************************
	    ** FUNCTION:  spi_tclMediatorIntf::vOnHUWiFiAPStateChange
	    ***************************************************************************/
	   /*!
	    * \fn     vOnHUWiFiAPStateChange(t_Bool bIsSetToOn)
       * \brief  Called when WiFi state changes.
	   * \param  enSelectReason : Reason for Trigger
	   * \retval t_Void
       **************************************************************************/ 
	   virtual t_Void vOnHUWiFiAPStateChange(t_Bool bIsSetToOn)=0;

	   /***************************************************************************
	   ** FUNCTION:  t_Void spi_tclMediatorIntf::vOnDisableBluetoothTrigger(
	   ***************************************************************************/
	   /*!
	   * \fn      t_Void vOnDisableBluetoothTrigger(t_String szBTAddress)
	   * \brief   Method to notify that DisableBT request is received
	   * \param   [IN] szBTAddress: Unique Devcie ID
	   * \retval  t_Void
	   **************************************************************************/
	   virtual t_Void vOnDisableBluetoothTrigger(t_String szBTAddress) = 0;

      /***************************************************************************
      ** FUNCTION:  t_Void spi_tclMediatorIntf::vOnEvaluateInitalModes()
      ***************************************************************************/
      /*!
      * \fn      t_Void vOnEvaluateInitalModes
      * \brief   Method to check and set inital modes before session is started
      * \param   [IN] corfszBTAddress: Unique Device ID
      * \retval  t_Void
      **************************************************************************/
	   virtual t_Void vOnEvaluateInitalModes(const t_String& corfszBTAddress) = 0;

      /***************************************************************************
       ** FUNCTION:  spi_tclMediatorIntf::vOnDeviceConnectstoWirelessAP
       ***************************************************************************/
      /*!
       * \fn     vOnDeviceConnectstoWirelessAP(const t_U32 cou32DeviceHandle, t_Bool &rfrbIsPreselectionValid)
       * \brief  Called when iphone Device connects to Carplay wireless AP
       * \brief  Returns boolean value, True : if the pre-selection request is valid for the device selection request once the device is connects to carplaywirless AP
       * \param  cou32DeviceHandle           : [IN] Device handle
       * \param  rfrbIsPreSelectionValid     : [OUT] boolean value
       **************************************************************************/
      virtual t_Void vOnDeviceConnectstoWirelessAP(const t_U32 cou32DeviceHandle, t_Bool &rfrbIsPreselectionValid)=0;

      /***************************************************************************
       ** FUNCTION: t_Void spi_tclWiFiSetupHndlr::vPostInitiateWirelessDiscovery()
       ***************************************************************************/
      /*!
       * \fn      vPostInitiateWirelessDiscovery(t_String szBTMACAddress,tenDeviceCategory enDevCategory)
      * \param   szBTMACAddress : [IN] BTMACAddress
      * \param   enDevCategory : Device Category
      * \param   bIsKnownDevice: [IN] FALSE- Fresh device, TRUE - Known device
       * \brief   vPostInitiateWirelessDiscovery Method. Invoked internally when the device appears over carplay wireless AP.
       **************************************************************************/
      virtual t_Void vPostInitiateWirelessDiscovery(const trUserContext& rfcorUsrCntxt,
                                        t_String szBTMACAddress,
                                        tenDeviceCategory enDevCategory) = 0;

      /***************************************************************************
       ** FUNCTION:  spi_tclMediatorIntf::vGetDeviceSelectorCurrentSelectionState
       ***************************************************************************/
      /*!
       * \fn     vGetDeviceSelectorCurrentSelectionState(trDeviceSelectionStateDetails& rfrDeviceSelectionDetails)
       * \brief  Triggered When there is InitiateWirelesssDiscovery MethodStart from HMI
       * \param  rfrDeviceSelectionDetails   : [OUT] Device Selection Details
       **************************************************************************/
      virtual t_Void vGetDeviceSelectorCurrentSelectionState(trDeviceSelectionStateDetails& rfrDeviceSelectionDetails)=0;

      /***************************************************************************
      ** FUNCTION: t_Void spi_tclMediator::vReportSessionErrorStatus()
      ***************************************************************************/
      /*!
       * \fn     vReportSessionErrorStatus
       * \param   t_U32 : cou32DevId
       * \param   enDevCategory : Device Category
       * \param   tenSessionStatus : Session status
       * \brief   vReportSessionErrorStatus reports session error status to resource manager
       **************************************************************************/
      virtual t_Void vReportSessionErrorStatus(t_U32 cou32DevId,tenDeviceCategory coenDevCat,tenSessionStatus coenSessionStatus) = 0;

      /***************************************************************************
       ** FUNCTION:  spi_tclMediatorIntf::vOnRetrailSetDeviceSelectionState
       ***************************************************************************/
      /*!
       * \fn     vOnRetrailSetDeviceSelectionState()
       * \brief  Called by SPI component when a device is selected automatically
       *         by applying retrail strategy
       * \param u32DeviceHandle: Device Handle
       **************************************************************************/
      virtual t_Void vOnRetrailSetDeviceSelectionState(const t_U32 cou32DeviceHandle)= 0;
};

#endif /* SPI_TCLMEDIATORINTF_H_ */
