/*!
 *******************************************************************************
 * \file             spi_tclMediator.cpp
 * \brief            Mediator to distribute messages among SPI components
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Mediator to distribute messages among SPI components
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 17.01.2014 |  Pruthvi Thej Nagaraju       | Initial Version

 \endverbatim
 ******************************************************************************/

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/
#include "spi_tclMediator.h"

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_TCLSERVICE
#include "trcGenProj/Header/spi_tclMediator.cpp.trc.h"
#endif
#endif
//lint -save -e1055 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1013 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1401 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e601 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e19 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e10 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e55 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e58 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e48 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e808 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e63 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e40 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e64 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
/***************************************************************************
 ** FUNCTION:  spi_tclMediator::~spi_tclMediator
 ***************************************************************************/
spi_tclMediator::~spi_tclMediator()
{

}
/***************************************************************************
 ** FUNCTION:  spi_tclMediator::vRegisterCallbacks(const trConnMngrCallback &rfrConnMngrCb)
 ***************************************************************************/
t_Void spi_tclMediator::vRegisterCallbacks(const trConnMngrCallback &rfrConnMngrCb)
{
   ETG_TRACE_USR1(("spi_tclMediator::vRegisterCallbacks for device selection"));
   m_rConnMngrCb = rfrConnMngrCb;
}

/***************************************************************************
 ** FUNCTION:  spi_tclMediator::vRegisterCallbacks
 ***************************************************************************/
t_Void spi_tclMediator::vRegisterCallbacks(const trSelectDeviceCallbacks &rSelDevCb)
{
   ETG_TRACE_USR1(("spi_tclMediator::vRegisterCallbacks for connection management"));
   m_vecrSelDevCbs.push_back(rSelDevCb);
}

/***************************************************************************
 ** FUNCTION:  spi_tclMediator::vRegisterCallbacks
 ***************************************************************************/
t_Void spi_tclMediator::vRegisterCallbacks(const trDevDiagnosisCallback &rDevDiagnosisCb)
{
   ETG_TRACE_USR1(("spi_tclMediator::vRegisterCallbacks for connection management"));
   m_vecrDevDiagnosisCbs.push_back(rDevDiagnosisCb);
}

/***************************************************************************
** FUNCTION:  spi_tclMediator::vRegisterCallbacks
***************************************************************************/
t_Void spi_tclMediator::vRegisterCallbacks(const trAppLauncherCallbacks& corfrAppLauncherCb)
{
   ETG_TRACE_USR1(("spi_tclMediator::vRegisterCallbacks for app launcher"));
   m_rAppLauncherCb = corfrAppLauncherCb;
}

/***************************************************************************
** FUNCTION:  spi_tclMediator::vRegisterCallbacks
***************************************************************************/
t_Void spi_tclMediator::vRegisterCallbacks(const trAAPSensorCallback& corfrDayNightModeCb)
{
   ETG_TRACE_USR1(("spi_tclMediator::vRegisterCallbacks for sensor"));
   m_rDayNightCb = corfrDayNightModeCb;
}

/***************************************************************************
** FUNCTION:  spi_tclMediator::vRegisterCallbacks
***************************************************************************/
t_Void spi_tclMediator::vRegisterCallbacks(const trOnCarSensorCallback& corfrDayNightModeCbOnCar)
{
   ETG_TRACE_USR1(("spi_tclMediator::vRegisterCallbacks for sensor"));
   m_rDayNightCbOnCar = corfrDayNightModeCbOnCar;
}

/***************************************************************************
** FUNCTION:  spi_tclMediator::vRegisterCallbacks
***************************************************************************/
t_Void spi_tclMediator::vRegisterCallbacks(const trWiFiSetupHndlrCallbacks& corfrWiFiSetupHndlrCb)
{
   ETG_TRACE_USR1(("spi_tclMediator::vRegisterCallbacks for WiFiSetupHndlr"));
   m_rWiFiSetupHndlrCallbacks = corfrWiFiSetupHndlrCb;
}

/***************************************************************************
** FUNCTION:  spi_tclMediator::vRegisterCallbacks
***************************************************************************/
t_Void spi_tclMediator::vRegisterCallbacks(const trNotifyDevAppStateCallbacks &corfrAppStateCb)
{
   ETG_TRACE_USR1(("spi_tclMediator::vRegisterCallbacks for app states"));
   m_vecrAppStateCbs.push_back(corfrAppStateCb);
}

/***************************************************************************
** FUNCTION:  spi_tclMediator::vRegisterCallbacks
***************************************************************************/
t_Void spi_tclMediator::vRegisterCallbacks(const trDeviceDisconnectCb& corfrDeviceDisconnectCb)
{
   ETG_TRACE_USR1(("spi_tclMediator::vRegisterCallbacks for Device"));
   m_rDeviceDisconnectCb = corfrDeviceDisconnectCb;
}

/***************************************************************************
 ** FUNCTION:  spi_tclMediator::vPostSelectDeviceRes
 ***************************************************************************/
t_Void spi_tclMediator::vPostSelectDeviceRes(tenCompID enCompID, tenErrorCode enErrorCode)
{
   ETG_TRACE_USR1((" %s entered \n", __PRETTY_FUNCTION__));
   std::vector<trSelectDeviceCallbacks>::iterator itCbs;
   for (itCbs = m_vecrSelDevCbs.begin(); itCbs != m_vecrSelDevCbs.end();
            itCbs++)
   {
      if (NULL != itCbs->fvOnSelectDeviceRes)
      {
         itCbs->fvOnSelectDeviceRes(enCompID, enErrorCode);
      }
   }
}

/***************************************************************************
 ** FUNCTION:  spi_tclMediator::vPostDeviceDisconnection
 ***************************************************************************/
t_Void spi_tclMediator::vPostDeviceDisconnection(const t_U32 u32DeviceHandle)
{
	/*lint -esym(40,fvOnDeviceDisconnection) fvOnDeviceDisconnection Undeclared identifier */
   ETG_TRACE_USR1((" %s entered \n", __PRETTY_FUNCTION__));
   std::vector<trSelectDeviceCallbacks>::iterator itCbs;
   for (itCbs = m_vecrSelDevCbs.begin(); itCbs != m_vecrSelDevCbs.end();
            itCbs++)
   {
      if (NULL != itCbs->fvOnDeviceDisconnection)
      {
         itCbs->fvOnDeviceDisconnection(u32DeviceHandle);
      }
   }
}

/***************************************************************************
 ** FUNCTION:  spi_tclMediator::vPostDeviceConnection
 ***************************************************************************/
t_Void spi_tclMediator::vPostDeviceConnection(const t_U32 u32DeviceHandle)
{
	/*lint -esym(40,fvOnDeviceConnection) fvOnDeviceConnection Undeclared identifier */
   ETG_TRACE_USR1((" %s entered \n", __PRETTY_FUNCTION__));
   std::vector<trSelectDeviceCallbacks>::iterator itCbs;
   for (itCbs = m_vecrSelDevCbs.begin(); itCbs != m_vecrSelDevCbs.end();
            itCbs++)
   {
      if (NULL != itCbs->fvOnDeviceConnection)
      {
         itCbs->fvOnDeviceConnection(u32DeviceHandle);
      }
   }
}

/***************************************************************************
 ** FUNCTION:  spi_tclMediator::vPostDeviceDisconnectionStatus
 ***************************************************************************/
t_Void spi_tclMediator::vPostDeviceDisconnectionStatus(const t_U32 u32DeviceHandle)
{
   /*lint -esym(40,fvOnDeviceDisconnectionStatus) fvOnDeviceDisconnectionStatus Undeclared identifier */
   ETG_TRACE_USR1((" %s entered \n", __PRETTY_FUNCTION__));
   std::vector<trDevDiagnosisCallback>::iterator itCbs;
   for (itCbs = m_vecrDevDiagnosisCbs.begin(); itCbs != m_vecrDevDiagnosisCbs.end();
            itCbs++)
   {
      if (NULL != itCbs->fvOnDeviceDisconnectionStatus)
      {
         itCbs->fvOnDeviceDisconnectionStatus(u32DeviceHandle);
      }
   }
   if(NULL != m_rDeviceDisconnectCb.fvDeviceDisconnectCb)
   {
       (m_rDeviceDisconnectCb.fvDeviceDisconnectCb)(u32DeviceHandle);
   }//if(NULL != m_rDeviceDisconnectCb.fvDeviceDisconnectCb)
}

/***************************************************************************
 ** FUNCTION:  spi_tclMediator::vPostDeviceConnectionStatus
 ***************************************************************************/
t_Void spi_tclMediator::vPostDeviceConnectionStatus(const t_U32 u32ProductID, const t_U32 u32VendorID, const t_U32 u32DeviceHandle)
{
   /*lint -esym(40,fvOnDeviceConnectionStatus) fvOnDeviceConnectionStatus Undeclared identifier */
   ETG_TRACE_USR1((" %s entered \n", __PRETTY_FUNCTION__));
   std::vector<trDevDiagnosisCallback>::iterator itCbs;
   for (itCbs = m_vecrDevDiagnosisCbs.begin(); itCbs != m_vecrDevDiagnosisCbs.end();
            itCbs++)
   {
      if (NULL != itCbs->fvOnDeviceConnectionStatus)
      {
         itCbs->fvOnDeviceConnectionStatus(u32ProductID, u32VendorID, u32DeviceHandle);
      }
   }
}

/***************************************************************************
** FUNCTION: t_Void spi_tclMediator::vPostLaunchAppResult
***************************************************************************/
t_Void spi_tclMediator::vPostLaunchAppResult(const tenCompID coenCompID,
                                             const t_U32 cou32DevId,
                                             const t_U32 cou32AppId,
                                             const tenDiPOAppType coenDiPOAppType,
                                             tenErrorCode enErrorCode,
                                             const trUserContext& rfrcUsrCntxt)
{
	/*lint -esym(40,fpvLaunchAppResult) fpvLaunchAppResult Undeclared identifier */
    ETG_TRACE_USR1(("spi_tclMediator::vPostLaunchAppResult:Dev-0x%x App-0x%x",
      cou32DevId,cou32AppId));

   if(NULL != m_rAppLauncherCb.fpvLaunchAppResult)
   {
      (m_rAppLauncherCb.fpvLaunchAppResult)(coenCompID,cou32DevId,cou32AppId,
         coenDiPOAppType,enErrorCode,rfrcUsrCntxt);
   }//if(NULL != m_rAppLauncherCb.fpvLaunchAppResult)
}

/***************************************************************************
** FUNCTION: t_Void spi_tclMediator::vPostTerminateAppResult
***************************************************************************/
t_Void spi_tclMediator::vPostTerminateAppResult(const tenCompID coenCompID,
                                                const t_U32 cou32DevId,
                                                const t_U32 cou32AppId,
                                                tenErrorCode enErrorCode,
                                                const trUserContext& rfrCUsrCntxt)
{
	/*lint -esym(40,fpvTerminateAppResult) fpvTerminateAppResult Undeclared identifier */
   ETG_TRACE_USR1(("spi_tclMediator::vPostTerminateAppResult:Dev-0x%x App-0x%x",
      cou32DevId,cou32AppId));

   if(NULL != m_rAppLauncherCb.fpvTerminateAppResult)
   {
      (m_rAppLauncherCb.fpvTerminateAppResult)(coenCompID,cou32DevId,cou32AppId,
         enErrorCode,rfrCUsrCntxt);
   }//if(NULL != m_rAppLauncherCb.fpvTerminateAppResult)
}

/***************************************************************************
 ** FUNCTION:  spi_tclMediator::vPostAutoDeviceSelection
 ***************************************************************************/
t_Void spi_tclMediator::vPostAutoDeviceSelection(const t_U32 cou32DeviceHandle,
         tenDeviceConnectionReq enConnReq,
		 tenSelectReason enSelectReason,
		 tenDeviceCategory enDevCategory)
{
	/*lint -esym(40,fvAutoSelectDevice) fvAutoSelectDevice Undeclared identifier */
   ETG_TRACE_USR1((" spi_tclMediator::vPostAutoDeviceSelection:DevID:0x%x,ConnReq:%d,SelectReadon:%d",
   cou32DeviceHandle,ETG_ENUM(CONNECTION_REQ, enConnReq),ETG_ENUM(SELECT_REASON,enSelectReason)));
   
   std::vector<trSelectDeviceCallbacks>::iterator itCbs;
   for (itCbs = m_vecrSelDevCbs.begin(); itCbs != m_vecrSelDevCbs.end();
            itCbs++)
   {
      if (NULL != itCbs->fvAutoSelectDevice)
      {
         itCbs->fvAutoSelectDevice(cou32DeviceHandle,
                  enConnReq, enDevCategory,enSelectReason);
      }
   }
}

/***************************************************************************
 ** FUNCTION:  spi_tclMediator::vPostSetUserDeselect
 ***************************************************************************/
t_Void spi_tclMediator::vPostSetUserDeselect(const t_U32 cou32DeviceHandle, t_Bool bUserDeselect)
{
	/*lint -esym(40,fvSetUserDeselect) fvSetUserDeselect Undeclared identifier */
   ETG_TRACE_USR1((" %s entered \n", __PRETTY_FUNCTION__));
   std::vector<trSelectDeviceCallbacks>::iterator itCbs;
   for (itCbs = m_vecrSelDevCbs.begin(); itCbs != m_vecrSelDevCbs.end();
            itCbs++)
   {
      if (NULL != itCbs->fvSetUserDeselect)
      {
         itCbs->fvSetUserDeselect(cou32DeviceHandle, bUserDeselect);
      }
   }
}

/***************************************************************************
 ** FUNCTION:  spi_tclMediator::vPostBTDeviceInfo
 ***************************************************************************/
t_Void spi_tclMediator::vPostBTDeviceInfo(t_U32 u32DeviceHandle,
         t_String szBTDeviceName, t_String szBTAddress)
{
   /*lint -esym(40,fvSetBTDeviceInfo) fvSetBTDeviceInfo Undeclared identifier */
   ETG_TRACE_USR1((" %s entered \n", __PRETTY_FUNCTION__));
   if (NULL != m_rConnMngrCb.fvSetBTDeviceInfo)
   {
      m_rConnMngrCb.fvSetBTDeviceInfo(u32DeviceHandle, szBTDeviceName, szBTAddress);
   }
}

/***************************************************************************
 ** FUNCTION:  spi_tclMediator::vApplySelectionStrategy
 ***************************************************************************/
t_Void spi_tclMediator::vApplySelectionStrategy(tenDeviceCategory enDeviceCategory)
{

	/*lint -esym(40,fvApplySelStrategy)fvApplySelStrategy Undeclared identifier */
   ETG_TRACE_USR1((" vApplySelectionStrategy entered \n"));
   std::vector<trSelectDeviceCallbacks>::iterator itCbs;
   for (itCbs = m_vecrSelDevCbs.begin(); itCbs != m_vecrSelDevCbs.end();
            itCbs++)
   {
      if (NULL != itCbs->fvApplySelStrategy)
      {
         itCbs->fvApplySelStrategy(enDeviceCategory);
      }
   }
}

/***************************************************************************
 ** FUNCTION:  spi_tclMediator::vPostDayNightMode
 ***************************************************************************/
t_Void spi_tclMediator::vPostDayNightMode(tenVehicleConfiguration enVehicleConfig)
{

	/*lint -esym(40,fvSetDayNightMode)fvSetDayNightMode Undeclared identifier */
   ETG_TRACE_USR1((" %s entered \n", __PRETTY_FUNCTION__));

   if (NULL != m_rDayNightCb.fvSetDayNightMode)
   {
      m_rDayNightCb.fvSetDayNightMode(enVehicleConfig);
   }
}

/***************************************************************************
 ** FUNCTION:  spi_tclMediator::vPostInitiateWirelessDiscoveryResult
 ***************************************************************************/
t_Void spi_tclMediator::vPostInitiateWirelessDiscoveryResult(t_Bool bResult)
{
   ETG_TRACE_USR1((" %s entered \n", __PRETTY_FUNCTION__));

   if (NULL != m_rWiFiSetupHndlrCallbacks.fvInitiateWirelessDiscoveryResult)
   {
	   m_rWiFiSetupHndlrCallbacks.fvInitiateWirelessDiscoveryResult(bResult);
   }
}

/***************************************************************************
 ** FUNCTION:  spi_tclMediator::vPostBTLimitationModeResult
 ***************************************************************************/
t_Void spi_tclMediator::vPostBTLimitationModeResult(const trBTLimitationModeInfo &corfrBTLimitationModeInfo)
{
   ETG_TRACE_USR1((" %s entered \n", __PRETTY_FUNCTION__));

   if (NULL != m_rWiFiSetupHndlrCallbacks.fvBTLimitationModeStatus)
   {
       m_rWiFiSetupHndlrCallbacks.fvBTLimitationModeStatus(corfrBTLimitationModeInfo);
   }
}
/***************************************************************************
 ** FUNCTION:  spi_tclMediator::vPostSetBTLimitationModeResult
 ***************************************************************************/
t_Void spi_tclMediator::vPostSetBTLimitationModeResult(t_Bool bSetBTLimitationModeResult)
{
   ETG_TRACE_USR1(("spi_tclMediator::vPostSetBTLimitationModeResult:Result:%d",bSetBTLimitationModeResult));

   if(NULL != m_rWiFiSetupHndlrCallbacks.fvSetBTLimModeResult)
   {
	   m_rWiFiSetupHndlrCallbacks.fvSetBTLimModeResult(bSetBTLimitationModeResult);
   }
}

/***************************************************************************
 ** FUNCTION:  spi_tclMediator::vPostSelectionProgressState
 ***************************************************************************/
t_Void spi_tclMediator::vPostSelectionProgressState(const t_U32 cou32DeviceHandle, tenDeviceSelectionProgressState enDeviceSelectionProgressState)
{
   /*lint -esym(40,fvSetBTDeviceInfo) fvSetBTDeviceInfo Undeclared identifier */
   ETG_TRACE_USR1((" %s entered \n", __PRETTY_FUNCTION__));
   if (NULL != m_rConnMngrCb.fvSelectionProgressState)
   {
      (m_rConnMngrCb.fvSelectionProgressState)(cou32DeviceHandle, enDeviceSelectionProgressState);
   }
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclMediator::vPostWiFiCredentials
***************************************************************************/
t_Void spi_tclMediator::vPostWiFiCredentials(t_String szBTMACAddress)
{
	ETG_TRACE_USR1(("spi_tclMediator::vPostWiFiCredentials():%s",szBTMACAddress.c_str()));
   if (NULL != m_rWiFiSetupHndlrCallbacks.fvSendWiFiCredentials)
   {
       m_rWiFiSetupHndlrCallbacks.fvSendWiFiCredentials(szBTMACAddress);
   } //if (NULL != m_rWiFiSetupHndlrCallbacks.fvSendWiFiCredentials)
}
/***************************************************************************
 ** FUNCTION:  spi_tclMediator::vPostAppStateSpeechStatus
 ***************************************************************************/
t_Void spi_tclMediator:: vPostDevAppState(tenSpeechAppState enSpeechAppState,
                                             tenPhoneAppState enPhoneAppState,
                                             tenNavAppState enNavAppState)
{

   /*lint -esym(40,fvAppStateStatus)fvAppStateStatus Undeclared identifier */
   ETG_TRACE_USR1((" %s entered \n", __PRETTY_FUNCTION__));
   std::vector<trNotifyDevAppStateCallbacks>::iterator itCbs;
   for (itCbs = m_vecrAppStateCbs.begin(); itCbs != m_vecrAppStateCbs.end();
               itCbs++)
     {
        if (NULL != itCbs->fvAppStateStatus)
        {
           itCbs->fvAppStateStatus(enSpeechAppState, enPhoneAppState,enNavAppState);
        }
     }
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclMediator::vPostDeviceChanged
***************************************************************************/
t_Void spi_tclMediator::vPostDeviceChanged(const t_U32 u32DeviceHandle)
{
	ETG_TRACE_USR1((" %s entered \n", __PRETTY_FUNCTION__));
	std::vector<trSelectDeviceCallbacks>::iterator itCbs;
	for (itCbs = m_vecrSelDevCbs.begin(); itCbs != m_vecrSelDevCbs.end(); itCbs++)
	{
		if(NULL != itCbs->fvDeviceChanged)
		{
			itCbs->fvDeviceChanged(u32DeviceHandle);
		}
	}

}


/***************************************************************************
 ** FUNCTION:  spi_tclMediator::vOnHUWiFiAPStateChange
 ***************************************************************************/
t_Void spi_tclMediator::vOnHUWiFiAPStateChange(t_Bool bIsSetToOn)
{
   ETG_TRACE_USR1(("spi_tclMediator::vOnHUWiFiAPStateChange():bIsSetToOn:%d",ETG_ENUM(BOOL,bIsSetToOn)));
   
   std::vector<trSelectDeviceCallbacks>::iterator itCbs;
   for (itCbs = m_vecrSelDevCbs.begin(); itCbs != m_vecrSelDevCbs.end();itCbs++)
   {
      if (NULL != itCbs->fvOnHUWiFiAPStateChange)
      {
         itCbs->fvOnHUWiFiAPStateChange(bIsSetToOn);
      }
   }
}

/***************************************************************************
  ** FUNCTION:  spi_tclMediator::vRegisterCallbacks(const trNotifyRsrcMngrCbs
***************************************************************************/
t_Void spi_tclMediator::vRegisterCallbacks(const trNotifyRsrcMngrCbs &rNotifyRsrcMngrCbs)
{
	ETG_TRACE_USR1(("spi_tclMediator::vRegisterCallbacks(const trNotifyRsrcMngrCbs &rNotifyRsrcMngrCbs)"));
	m_rNotifyRsrcMngrCbs = rNotifyRsrcMngrCbs;
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclMediator::vOnDisableBluetoothTrigger(
***************************************************************************/
t_Void spi_tclMediator::vOnDisableBluetoothTrigger(t_String szBTAddress)
{
	ETG_TRACE_USR1(("spi_tclMediator:vOnDisableBluetoothTrigger():BTAddress-%s",szBTAddress.c_str()));

	if (NULL != m_rNotifyRsrcMngrCbs.fvOnDisableBluetoothTrigger)
	{
		(m_rNotifyRsrcMngrCbs.fvOnDisableBluetoothTrigger)(szBTAddress);
	}
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclMediator::vOnEvaluateInitalModes()
***************************************************************************/
t_Void spi_tclMediator::vOnEvaluateInitalModes(const t_String& corfszBTAddress)
{
   ETG_TRACE_USR1(("spi_tclMediator:vOnEvaluateInitalModes():BTAddress-%s", corfszBTAddress.c_str()));

   if (NULL != m_rNotifyRsrcMngrCbs.fvEvaluateInitialModes)
   {
      (m_rNotifyRsrcMngrCbs.fvEvaluateInitialModes)(corfszBTAddress);
   }
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclMediator::vOnDeviceConnectstoWirelessAP(
***************************************************************************/
t_Void spi_tclMediator::vOnDeviceConnectstoWirelessAP(const t_U32 cou32DeviceHandle, t_Bool &rfrbIsPreselectionValid)
{
   ETG_TRACE_USR1((" spi_tclMediator::vOnDeviceConnectstoWirelessAP:DevID:%d",cou32DeviceHandle));

   std::vector<trSelectDeviceCallbacks>::iterator itCbs;
   for (itCbs = m_vecrSelDevCbs.begin(); itCbs != m_vecrSelDevCbs.end();
            itCbs++)
   {
      if (NULL != itCbs->fvOnDeviceConnectsToWirelessAP)
      {
         itCbs->fvOnDeviceConnectsToWirelessAP(cou32DeviceHandle,rfrbIsPreselectionValid);
      }
   }
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclMediator::vPostInitiateWirelessDiscovery(
***************************************************************************/
t_Void spi_tclMediator::vPostInitiateWirelessDiscovery(const trUserContext& rfcorUsrCntxt, t_String szBTMACAddress, tenDeviceCategory enDevCategory)
{
   ETG_TRACE_USR1((" spi_tclMediator::vPostInitiateWirelessDiscovery:BTMac address:%s",szBTMACAddress.c_str()));
   if (NULL != m_rWiFiSetupHndlrCallbacks.fvInitiateWirelessDiscovery)
   {
       m_rWiFiSetupHndlrCallbacks.fvInitiateWirelessDiscovery(rfcorUsrCntxt, szBTMACAddress, enDevCategory);
   } //if (NULL != m_rWiFiSetupHndlrCallbacks.fvSendWiFiCredentials)
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclMediator::vGetDeviceSelectorCurrentSelectionState(
***************************************************************************/
t_Void spi_tclMediator::vGetDeviceSelectorCurrentSelectionState(trDeviceSelectionStateDetails& rfrDeviceSelectionDetails)
{
   ETG_TRACE_USR1((" spi_tclMediator::vGetDeviceSelectorCurrentSelectionState Entered"));

   std::vector<trSelectDeviceCallbacks>::iterator itCbs;
   for (itCbs = m_vecrSelDevCbs.begin(); itCbs != m_vecrSelDevCbs.end();
            itCbs++)
   {
      if (NULL != itCbs->fvGetDeviceSelectorCurrentSelectionState)
      {
         itCbs->fvGetDeviceSelectorCurrentSelectionState(rfrDeviceSelectionDetails);
      }
   }
}


/***************************************************************************
** FUNCTION: t_Void spi_tclMediator::vReportSessionErrorStatus()
**************************************************************************/
t_Void spi_tclMediator::vReportSessionErrorStatus(const t_U32 cou32DevId,
                                                  const tenDeviceCategory coenDevCat,
                                                  const tenSessionStatus coenSessionStatus)
{
   //lint -esym(40,fvUpdateSessionStatus) fvUpdateSessionStatus Undeclared identifier
   ETG_TRACE_USR1(("spi_tclMediator::vReportSessionErrorStatus:Dev-0x%x Cat-%d Status-%d",
      cou32DevId,ETG_ENUM(DEVICE_CATEGORY,coenDevCat),ETG_ENUM(SESSION_STATUS,coenSessionStatus)));

   if (NULL != m_rNotifyRsrcMngrCbs.fvUpdateSessionStatus)
   {
      (m_rNotifyRsrcMngrCbs.fvUpdateSessionStatus)(cou32DevId, e8DEV_TYPE_CARLIFE, coenSessionStatus);
   }
}

/***************************************************************************
 ** FUNCTION:  spi_tclMediator::vOnRetrailSetDeviceSelectionState
 ***************************************************************************/
t_Void spi_tclMediator::vOnRetrailSetDeviceSelectionState(const t_U32 cou32DeviceHandle)
{
   /*lint -esym(40,fvAutoSelectDevice) fvAutoSelectDevice Undeclared identifier */
   ETG_TRACE_USR1((" spi_tclMediator::vOnRetrailSetDeviceSelectionState:DevID:0x%x ",cou32DeviceHandle));

   std::vector<trSelectDeviceCallbacks>::iterator itCbs;
   for (itCbs = m_vecrSelDevCbs.begin(); itCbs != m_vecrSelDevCbs.end();
            itCbs++)
   {
      if (NULL != itCbs->fvOnRetrailSetDeviceSelectionState)
      {
         itCbs->fvOnRetrailSetDeviceSelectionState(cou32DeviceHandle);
      }
   }
}
/***************************************************************************
 *********************************PRIVATE***********************************
 ***************************************************************************/

/***************************************************************************
 ** FUNCTION:  spi_tclMediator::spi_tclMediator
 ***************************************************************************/
spi_tclMediator::spi_tclMediator()
{

}
//lint –restore
