/*!
 *******************************************************************************
 * \file             spi_tclDeviceIDDataIntf.h
 * \brief
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 25.05.2017 |  Pruthvi Thej Nagaraju       | Initial Version
 \endverbatim
 ******************************************************************************/

#ifndef GENERIC_COMMON_SPI_TCLDEVICEIDDATAINTF_H_
#define GENERIC_COMMON_SPI_TCLDEVICEIDDATAINTF_H_

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/
#include "SPITypes.h"
/******************************************************************************
 | defines and macros and constants(scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/*!
 * \class spi_tclDeviceIDDataIntf
 * \brief
 */
class spi_tclDeviceIDDataIntf
{
   public:

      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclDeviceIDDataIntf::spi_tclDeviceIDDataIntf
       ***************************************************************************/
      /*!
       * \fn     spi_tclMediator()
       * \brief  Default Constructor
       **************************************************************************/
      spi_tclDeviceIDDataIntf();
      /***************************************************************************
       ** FUNCTION:  spi_tclDeviceIDDataIntf::~spi_tclDeviceIDDataIntf
       ***************************************************************************/
      /*!
       * \fn     ~spi_tclDeviceIDDataIntf()
       * \brief  Destructor
       **************************************************************************/
      ~spi_tclDeviceIDDataIntf();

      /***************************************************************************
       ** FUNCTION:  spi_tclDeviceIDDataIntf::u32GetDeviceIDFromBTAddress
       ***************************************************************************/
      /*!
       * \fn     u32GetDeviceIDFromBTAddress(coszBTAddress)
       **************************************************************************/
      t_U32 u32GetDeviceIDFromBTAddress(const t_String &coszBTAddress);

      /***************************************************************************
       ** FUNCTION:  spi_tclDeviceIDDataIntf::u32GetDeviceIDFromName
       ***************************************************************************/
      /*!
       * \fn     u32GetDeviceIDFromName(coszBTAddress)
       **************************************************************************/
      t_U32 u32GetDeviceIDFromName(const t_String &coszDeviceName);

      /***************************************************************************
       ** FUNCTION:  spi_tclDeviceIDDataIntf::u32GetDeviceIDFromSerialNo
       ***************************************************************************/
      /*!
       * \fn     u32GetDeviceIDFromSerialNo(coszBTAddress)
       **************************************************************************/
      t_U32 u32GetDeviceIDFromSerialNo(const t_String &coszSerialNo);

      /***************************************************************************
       ** FUNCTION:  spi_tclDeviceIDDataIntf::vGetBTAddress
       ***************************************************************************/
      /*!
       * \fn     vGetBTAddress(coszBTAddress)
       **************************************************************************/
      t_Void vGetBTAddress(t_String &coszBTAddress, const t_U32 cou32DeviceID);

      /***************************************************************************
       ** FUNCTION:  spi_tclDeviceIDDataIntf::vGetSerialNumber
       ***************************************************************************/
      /*!
       * \fn     vGetSerialNumber(coszBTAddress)
       **************************************************************************/
      t_Void vGetSerialNumber(t_String &coszSerialNo, const t_U32 cou32DeviceID);


      /***************************************************************************
       ** FUNCTION:  spi_tclDeviceIDDataIntf::vGetSessionTransport
       ***************************************************************************/
      /*!
       * \fn     vGetSessionTransport(coszBTAddress)
       **************************************************************************/
      t_Void vGetSessionTransport(const t_U32 cou32DeviceID,tenSessionTransport& enSessionTransport);

      /***************************************************************************
       ** FUNCTION:  spi_tclDeviceIDDataIntf::enGetDeviceCategory
       ***************************************************************************/
      /*!
       * \fn     enGetDeviceCategory(const t_U32 cou32DeviceID)
       **************************************************************************/
      tenDeviceCategory enGetDeviceCategory(const t_U32 cou32DeviceID);

      /***************************************************************************
       ** FUNCTION:  spi_tclDeviceIDDataIntf::u32GetDeviceIDFromIPAddress
       ***************************************************************************/
      /*!
       * \fn     u32GetDeviceIDFromIPAddress(coszIPAddress)
       **************************************************************************/
      t_U32 u32GetDeviceIDFromIPAddress(const t_String &coszIPAddress);
      
      /***************************************************************************
       ** FUNCTION:  spi_tclDeviceIDDataIntf::vGetBTDeviceName
       ***************************************************************************/
      /*!
       * \fn     vGetBTDeviceName
       * \brief  To get the device name of the device identified by device handle
       * \param cou32DeviceHandle: Device Handle of the device
       * \param rfrszDeviceName : Device Name to be get
       **************************************************************************/      
      t_Void vGetBTDeviceName(t_U32 cou32DeviceHandle, t_String &rfszDeviceName);


   private:

      /***************************************************************************
       *********************************PRIVATE***********************************
       ***************************************************************************/

};



#endif /* GENERIC_COMMON_SPI_TCLDEVICEIDDATAINTF_H_ */
