/*!
 *******************************************************************************
 * \file             spi_tclDeviceIDDataIntf.cpp
 * \brief
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 25.05.2017 |  Pruthvi Thej Nagaraju       | Initial Version
 \endverbatim
 ******************************************************************************/

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/
#include "spi_tclDeviceIDDataIntf.h"
#include "spi_tclDeviceIDUtility.h"
//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_CONNECTIVITY
#include "trcGenProj/Header/spi_tclDeviceIDDataIntf.cpp.trc.h"
#endif
#endif

/******************************************************************************
 | defines and macros and constants(scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/***************************************************************************
 *********************************PUBLIC*************************************
 ***************************************************************************/

/***************************************************************************
 ** FUNCTION:  spi_tclDeviceIDDataIntf::spi_tclDeviceIDDataIntf
 ***************************************************************************/
spi_tclDeviceIDDataIntf::spi_tclDeviceIDDataIntf()
{

}

/***************************************************************************
 ** FUNCTION:  spi_tclDeviceIDDataIntf::~spi_tclDeviceIDDataIntf
 ***************************************************************************/
spi_tclDeviceIDDataIntf::~spi_tclDeviceIDDataIntf()
{

}

/***************************************************************************
 ** FUNCTION:  spi_tclDeviceIDDataIntf::u32GetDeviceIDFromBTAddress
 ***************************************************************************/
t_U32 spi_tclDeviceIDDataIntf::u32GetDeviceIDFromBTAddress(const t_String& coszBTAddress)
{
   t_U32 u32DeviceID = 0;
   spi_tclDeviceIDUtility *poDeviceIDUtil = spi_tclDeviceIDUtility::getInstance();
   if(NULL != poDeviceIDUtil)
   {
      u32DeviceID = poDeviceIDUtil->u32GetDeviceIDFromBTAddress(coszBTAddress);
   }
   return u32DeviceID;
}

/***************************************************************************
 ** FUNCTION:  spi_tclDeviceIDDataIntf::u32GetDeviceIDFromSerialNo
 ***************************************************************************/
t_U32 spi_tclDeviceIDDataIntf::u32GetDeviceIDFromSerialNo(const t_String& coszSerialNo)
{
   t_U32 u32DeviceID = 0;
   spi_tclDeviceIDUtility *poDeviceIDUtil = spi_tclDeviceIDUtility::getInstance();
   if(NULL != poDeviceIDUtil)
   {
      u32DeviceID = poDeviceIDUtil->u32GetDeviceIDFromSerialNo(coszSerialNo);
   }
   return u32DeviceID;
}

/***************************************************************************
 ** FUNCTION:  spi_tclDeviceIDDataIntf::u32GetDeviceIDFromName
 ***************************************************************************/
t_U32 spi_tclDeviceIDDataIntf::u32GetDeviceIDFromName(const t_String &coszDeviceName)
{
   t_U32 u32DeviceID = 0;
   spi_tclDeviceIDUtility *poDeviceIDUtil = spi_tclDeviceIDUtility::getInstance();
   if(NULL != poDeviceIDUtil)
   {
      u32DeviceID = poDeviceIDUtil->u32GetDeviceIDFromName(coszDeviceName);
   }
   return u32DeviceID;
}

/***************************************************************************
 ** FUNCTION:  spi_tclDeviceIDDataIntf::vGetBTAddress
 ***************************************************************************/
t_Void spi_tclDeviceIDDataIntf::vGetBTAddress(t_String& coszBTAddress, const t_U32 cou32DeviceID)
{
   spi_tclDeviceIDUtility *poDeviceIDUtil = spi_tclDeviceIDUtility::getInstance();
   if(NULL != poDeviceIDUtil)
   {
      poDeviceIDUtil->vGetBTAddress(coszBTAddress, cou32DeviceID);
   }
}

/***************************************************************************
 ** FUNCTION:  spi_tclDeviceIDDataIntf::vGetSerialNumber
 ***************************************************************************/
t_Void spi_tclDeviceIDDataIntf::vGetSerialNumber(t_String& coszSerialNo, const t_U32 cou32DeviceID)
{
   spi_tclDeviceIDUtility *poDeviceIDUtil = spi_tclDeviceIDUtility::getInstance();
   if(NULL != poDeviceIDUtil)
   {
      poDeviceIDUtil->vGetSerialNumber(coszSerialNo, cou32DeviceID);
   }
}

/***************************************************************************
 ** FUNCTION:  spi_tclDeviceIDDataIntf::vGetSessionTransport
 ***************************************************************************/
t_Void spi_tclDeviceIDDataIntf::vGetSessionTransport(const t_U32 cou32DeviceID,tenSessionTransport& enSessionTransport)
{
   spi_tclDeviceIDUtility *poDeviceIDUtil = spi_tclDeviceIDUtility::getInstance();
   if(NULL != poDeviceIDUtil)
   {
      poDeviceIDUtil->vGetSessionTransport(cou32DeviceID, enSessionTransport);
   }
}

/***************************************************************************
 ** FUNCTION:  spi_tclDeviceIDDataIntf::enGetDeviceCategory
 ***************************************************************************/
tenDeviceCategory spi_tclDeviceIDDataIntf::enGetDeviceCategory(const t_U32 cou32DeviceID)
{
   tenDeviceCategory enDeviceCategory = e8DEV_TYPE_UNKNOWN;
   spi_tclDeviceIDUtility *poDeviceIDUtil = spi_tclDeviceIDUtility::getInstance();
   if(NULL != poDeviceIDUtil)
   {
      enDeviceCategory = poDeviceIDUtil->enGetDeviceCategory(cou32DeviceID);
   }
   return enDeviceCategory;
}

/***************************************************************************
 ** FUNCTION:  spi_tclDeviceIDDataIntf::u32GetDeviceIDFromIPAddress
 ***************************************************************************/
t_U32 spi_tclDeviceIDDataIntf::u32GetDeviceIDFromIPAddress(const t_String &coszIPAddress)
{
   t_U32 u32DeviceID = 0;
   spi_tclDeviceIDUtility *poDeviceIDUtil = spi_tclDeviceIDUtility::getInstance();
   if(NULL != poDeviceIDUtil)
   {
      u32DeviceID = poDeviceIDUtil->u32GetDeviceIDFromIPAddress(coszIPAddress);
   }
   return u32DeviceID;
}

/***************************************************************************
 ** FUNCTION:  spi_tclDeviceIDDataIntf::vGetBTDeviceName
 ***************************************************************************/
t_Void spi_tclDeviceIDDataIntf::vGetBTDeviceName(t_U32 cou32DeviceHandle, t_String &rfszDeviceName)
{
    spi_tclDeviceIDUtility *poDeviceIDUtil = spi_tclDeviceIDUtility::getInstance();
    if (NULL != poDeviceIDUtil)
    {
        poDeviceIDUtil->vGetDeviceName(cou32DeviceHandle, rfszDeviceName);
    }
    ETG_TRACE_USR1(("spi_tclDeviceIDDataIntf::vGetBTDeviceName: Device = %d  with device name = %s ",
         cou32DeviceHandle, rfszDeviceName.c_str()));
}
