/***********************************************************************/
/*!
* \file  spi_tclVideoIntf.h
* \brief 
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    
AUTHOR:         Shiva Kumar Gurija
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
18.10.2013  | Shiva Kumar Gurija    | Initial Version
21.01.2014  | Shiva Kumar Gurija    | Added interface to set the Video rendering

\endverbatim
*************************************************************************/

#ifndef _SPI_TCLVIDEOINTF_H_
#define _SPI_TCLVIDEOINTF_H_

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "SPITypes.h"

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/


/****************************************************************************/
/*!
* \class spi_tclVideoIntf
* \brief 
****************************************************************************/
class spi_tclVideoIntf 
{
public:

   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  spi_tclVideoIntf::spi_tclVideoIntf()
   ***************************************************************************/
   /*!
   * \fn      spi_tclVideoIntf()
   * \brief   Default Constructor
   * \sa      ~spi_tclVideoIntf()
   **************************************************************************/
   spi_tclVideoIntf()
   {
      //Add code
   }

   /***************************************************************************
   ** FUNCTION:  spi_tclVideoIntf::~spi_tclVideoIntf()
   ***************************************************************************/
   /*!
   * \fn      virtual ~spi_tclVideoIntf()
   * \brief   Destructor
   * \sa      spi_tclVideoIntf()
   **************************************************************************/
   virtual ~spi_tclVideoIntf()
   {
      //Add code
   }

   /***************************************************************************
   ** FUNCTION:  t_Void  spi_tclVideoIntf::vStartVideoRendering()
   ***************************************************************************/
   /*!
   * \fn      t_Void vStartVideoRendering(const t_Bool cobStartVideoRendering)
   * \brief   Interface send request to ML/DiPo Video either to start or stop
   *          Video Rendering
   * \pram    cobStartVideoRendering : [IN] True - Start Video rendering
   *                                      False - Stop Video rendering
   * \retval  t_Void 
   **************************************************************************/
   virtual t_Void vStartVideoRendering(const t_Bool cobStartVideoRendering)=0;

   /***************************************************************************
   ****************************END OF PUBLIC***********************************
   ***************************************************************************/

protected:

   /***************************************************************************
   *********************************PROTECTED**********************************
   ***************************************************************************/



   /***************************************************************************
   ****************************END OF PROTECTED********************************
   ***************************************************************************/

private:

   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/


   /***************************************************************************
   ****************************END OF PRIVATE *********************************
   ***************************************************************************/

}; //spi_tclVideoIntf

#endif //_SPI_TCLVIDEOINTF_H_


///////////////////////////////////////////////////////////////////////////////
// <EOF>



