/***********************************************************************/
/*!
* \file  spi_tclResourceMngrBase.h
* \brief Base class for MirrorLink and DiPo Resource Mngr 
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Base class for MirrorLink and DiPo Resource Mngr 
AUTHOR:         Priju K Padiyath
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
05.04.2014  | Priju K Padiyath      | Initial Version
20.03.2015  | Shiva Kumar G         | updated with the elements to Android Auto
15.06.2015  | Shihabudheen P M      | added vSetVehicleBTAddress()
10.07.2015  | Shihabudheen P M		| Removed vOnCarPlayPluginLoaded.
29.11.2016  |  Noopur R K           | HMI Synchronization


\endverbatim
*************************************************************************/
#ifndef _SPI_TCL_RSRCMNGRBASE_
#define _SPI_TCL_RSRCMNGRBASE_

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include <list>
#include "Lock.h"
#include "SPITypes.h"
#include "spi_BluetoothTypedefs.h"
#include "spi_tclResorceMngrDefines.h"
#include "spi_tclResourceMngrSettingsIntf.h"

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

struct trRsrcSettings
{
   t_U32 u32StartTimeInterval;
   
   tenETCInfo m_enETCSupport;
   
   t_Bool m_bIsLastModeSupported;

   trRsrcSettings():u32StartTimeInterval(0),
    m_enETCSupport(e8ETCInfo_NotSupported), m_bIsLastModeSupported(false)
   {
   }

};
/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/****************************************************************************/
/*!
* \class spi_tclResourceMngrBase
* \brief Base class for MirrorLink and DiPo Resource Manager 
****************************************************************************/
class spi_tclResourceMngrBase
{
   public:

      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclResourceMngrBase::spi_tclResourceMngrBase()
       ***************************************************************************/
      /*!
       * \fn      spi_tclResourceMngrBase()
       * \brief   Default Constructor
       * \sa      ~spi_tclResourceMngrBase()
       **************************************************************************/
      spi_tclResourceMngrBase():m_poResourceMngrSettings(NULL)
      {
         //Add code
      }

      /***************************************************************************
       ** FUNCTION:  spi_tclResourceMngrBase::~spi_tclResourceMngrBase()
       ***************************************************************************/
      /*!
       * \fn      virtual ~spi_tclResourceMngrBase()
       * \brief   Destructor
       * \sa      spi_tclResourceMngrBase()
       **************************************************************************/
      virtual ~spi_tclResourceMngrBase()
      {
         m_poResourceMngrSettings = NULL;
      }

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclResourceMngrBase::bInitialize()
       ***************************************************************************/
      /*!
       * \fn      t_Bool bInitialize()
       * \brief   To Initialize all the Resource Manager related classes
       * \retval  t_Bool
       * \sa      vUninitialize()
       **************************************************************************/
      virtual t_Bool bInitialize()
      {
         return true;
      }

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclResourceMngrBase::vUninitialize()
       ***************************************************************************/
      /*!
       * \fn      t_Void vUninitialize()
       * \brief   To Uninitialize all the Resource Manager related classes
       * \retval  t_Void
       * \sa      bInitialize()
       **************************************************************************/
      virtual t_Void vUnInitialize()
      {
         //add code
      }

      /***************************************************************************
       ** FUNCTION:  t_Void  spi_tclResourceMngrBase::vRegRsrcMngrCallBack()
       ***************************************************************************/
      /*!
       * \fn      t_Void vRegRsrcMngrCallBack()
       * \brief   To Register for the asynchronous responses that are required from
       *          ML/DiPo Resource Manager
       * \param   rRsrcMngrCallback : [IN] Resource Manager callbacks structure
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vRegRsrcMngrCallBack(trRsrcMngrCallback rRsrcMngrCallback) = 0;

      /***************************************************************************
       ** FUNCTION: t_Void spi_tclResourceMngrBase::vSelectDevice()
       ***************************************************************************/
      /*!
       * \fn     t_Void vSelectDevice(const t_U32 cou32DevId, tenDeviceConnectionReq enConnReq,
       *              tenDeviceCategory enDevCat)
       * \brief  method to send the select device request to resouce manager
       * \param  cou32DevId : [IN] Uniquely identifies the target Device.
       * \param  enConnReq  : [IN] Device selection type.
       * \param  enDevCat   : [IN] Device category.
       * \retval t_Void
       **************************************************************************/
      virtual t_Void vSelectDevice(const t_U32 /*cou32DevId*/, tenDeviceConnectionReq /*enConnReq*/,
               tenDeviceCategory /*enDevCat*/)
      {
      }

      /***************************************************************************
       ** FUNCTION:  t_Void  spi_tclResourceMngrBase::vOnSPISelectDeviceResult()
       ***************************************************************************/
      /*!
       * \fn      t_Void vOnSPISelectDeviceResult()
       * \brief   Interface to receive result of SPI device selection/deselection
       * \param   u32DevID : [IN] Resource Manager callbacks structure.
       * \param   enDeviceConnReq : [IN] Select/ deselect.
       * \param   enRespCode : [IN] Response code (success/failure)
       * \param   enErrorCode : [IN] Error
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vOnSPISelectDeviceResult(t_U32 u32DevID, tenDeviceConnectionReq enDeviceConnReq,
               tenResponseCode enRespCode, tenErrorCode enErrorCode) = 0;

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclResourceMngrBase::vSetAccessoryDisplayContext()
       ***************************************************************************/
      /*!
       * \fn      virtual t_Void vSetAccessoryDisplayContext(const t_U32 cou32DevId,
       *        t_Bool bDisplayFlag, tenDisplayContext enDisplayContext)
       * \brief   To send accessory display context related info .
       * \pram    cou32DevId  : [IN] Uniquely identifies the target Device.
       * \param   enDevConnType : [IN] Device connection Type USB/WIFI
       * \pram    rfrcUsrCntxt: [IN] User Context Details.
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vSetAccessoryDisplayContext(const t_U32 cou32DevId, t_Bool bDisplayFlag,
               tenDisplayContext enDisplayContext, const trUserContext& rfrcUsrCntxt) = 0;

      /***************************************************************************
       ** FUNCTION: t_Void spi_tclResourceMngrBase::vSetAccessoryDisplayMode(t_U32...
       ***************************************************************************/
      /*!
       * \fn     vSetAccessoryDisplayMode()
       * \brief  Accessory display mode update request.
       * \param  [IN] cu32DeviceHandle      : Uniquely identifies the target Device.
       * \param  [IN] corDisplayContext     : Display context info
       * \param  [IN] corDisplayConstraint  : DiDisplay constraint info
       * \param  [IN] coenDisplayInfo       : Display info flag
       * \sa
       **************************************************************************/
      virtual t_Void vSetAccessoryDisplayMode(const t_U32 /*cu32DeviceHandle*/,
               const trDisplayContext /*corDisplayContext*/,
               const trDisplayConstraint /*corDisplayConstraint*/,
               const tenDisplayInfo /*coenDisplayInfo*/)
      {
      }

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclResourceMngrBase::vSetAccessoryAudioContext()
       ***************************************************************************/
      /*!
       * \fn     vSetAccessoryAudioContext(const t_U32 cou32DevId, const t_U8 cu8AudioCntxt
       *       t_Bool bDisplayFlag, const trUserContext& rfrcUsrCntxt)
       * \brief   To send accessory audio context related info .
       * \pram    cou32DevId  : [IN] Uniquely identifies the target Device.
       * \param   cu8AudioCntxt : [IN] Audio Context
       * \pram    bReqFlag : [IN] Request/ Release flag
       * \pram    rfrcUsrCntxt: [IN] User Context Details.
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vSetAccessoryAudioContext(const t_U32 cou32DevId,
               const tenAudioContext coenAudioCntxt,
               t_Bool bReqFlag, const trUserContext& rfrcUsrCntxt) = 0;

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclResourceMngrBase::vSetAccessoryAppState()
       ***************************************************************************/
      /*!
       * \fn     t_Void vSetAccessoryAppState(tenSpeechAppState enSpeechAppState,
       *         tenPhoneAppState enPhoneAppState,
       *         tenNavAppState enNavAppState
       *
       * \brief   To set accessory app state realated info.
       * \pram    enSpeechAppState: [IN] Accessory speech state.
       * \param   enPhoneAppState : [IN] Accessory phone state
       * \pram    enNavAppState   : [IN] Accessory navigation app state
       * \pram    rfrcUsrCntxt    : [IN] User Context Details.
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vSetAccessoryAppState(const tenSpeechAppState enSpeechAppState,
               const tenPhoneAppState enPhoneAppState, const tenNavAppState enNavAppState,
               const trUserContext& rfrcUsrCntxt) = 0;


      /***************************************************************************
       ** FUNCTION:  spi_tclResourceMngrBase::vUpdateInitialSettings()
       ***************************************************************************/
      /*!
       * \fn     vUpdateInitialSettings()
       * \brief  Function to set the initial settings
       * \param  rRsrcSettings : [IN] Settings
       * \
       **************************************************************************/
      virtual t_Void vUpdateInitialSettings(trRsrcSettings /*rRsrcSettings*/)
      {
      }

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclResourceMngrBase::vSetVehicleBTAddress()
       ***************************************************************************/
      /*!
       * \fn      vSetVehicleBTAddress(t_Bool bLocDataAvailable)
       * \brief   Interface to update the vehicle BT address info update.
       * \param   szBtAddress: [IN] BT address.
       * \retval  None
       **************************************************************************/
      virtual t_Void vSetVehicleBTAddress(t_String /*szBtAddress*/)
      {
      }

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclResourceMngrBase::vSetFeatureRestrictions()
       ***************************************************************************/
      /*!
       * \fn      t_Void vSetFeatureRestrictions(const t_U8 cou8ParkModeRestrictionInfo,
       *          const t_U8 cou8DriveModeRestrictionInfo)
       * \brief   Method to set Vehicle Park/Drive Mode Restriction
       *          cou8ParkModeRestrictionInfo : Park mode restriction
       *          cou8DriveModeRestrictionInfo : Drive mode restriction
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vSetFeatureRestrictions(const t_U8 /*cou8ParkModeRestrictionInfo*/,
               const t_U8 /*cou8DriveModeRestrictionInfo*/)
      {
      }

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclResourceMngr::vRequestProjUI()
       ***************************************************************************/
      /*!
       * \fn      t_Void vRequestProjUI(t_U32 u32DevId,
       *                                t_U32 u32AppId)
       * \brief   To Launch the Video for the requested app
       * \pram    u32DevId  : [IN] Uniquely identifies the target Device.
       * \pram    u32AppId  : [IN] Application Id
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vRequestProjUI(t_U32 /*u32DevId*/, t_U32 /*u32AppId*/)
      {
      }

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclResourceMngrBase::vAcquireDevAppStateLock()
       ***************************************************************************/
      /*!
       * \fn      vAcquireDevAppStateLock()
       * \brief   Function to acquire Device App state lock.
       * \param   None
       * \retval  None
       **************************************************************************/
      t_Void vAcquireDevAppStateLock()
      {
         m_oDevAppStateLock.s16Lock();
      }

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclResourceMngrBase::vReleaseDevAppStateLock()
       ***************************************************************************/
      /*!
       * \fn      vReleaseDevAppStateLock()
       * \brief   Function to release Device App state lock.
       * \param   None
       * \retval  None
       **************************************************************************/
      t_Void vReleaseDevAppStateLock()
      {
         m_oDevAppStateLock.vUnlock();
      }

      /***************************************************************************
       ** FUNCTION: t_Void spi_tclResourceMngrBase::vUpdateVoiceSessionStatus(tenBTVoiceSessionStatus...
       ***************************************************************************/
      /*!
       * \fn     vUpdateVoiceSessionStatus()
       * \brief  Update the current voice session status
       * \param  szTelephoneNumber
       * \param  szDisplayText
       * \sa
       **************************************************************************/
      virtual t_Void vUpdateVoiceSessionStatus(tenBTVoiceSessionStatus /*enBTVoiceSessionStatus*/)
      {
      }

      /***************************************************************************
       ** FUNCTION: t_Void spi_tclResourceMngrBase::vOnSetNativeVideoRenderingStatus()
       ***************************************************************************/
      /*!
       * \fn     t_Void vOnSetNativeVideoRenderingStatus()
       * \brief  Method to inform the video playback status update.
       * \param  enNativeVideoRenderingStatus : TRUE when Native projection is ON
       *                                        FALSE when Native projection is OFF
       * \retval t_Void
       **************************************************************************/
      virtual t_Void vOnSetNativeVideoRenderingStatus(tenNativeVideoRenderingStatus /*enNativeVideoRenderingStatus*/)
      {
      }

      /***************************************************************************
       ** FUNCTION: t_Void spi_tclResourceMngrBase::vSetGeneralRestrictions
       ***************************************************************************/
      /*!
       * \fn     vSetGeneralRestriction
       * \brief  Interface to set the general restrictions for various technologies.
       * \param  u16GeneralRestrInfo : General Restriction Info for the technology.
       * \param  [OUT] void.
       **************************************************************************/
      virtual t_Void vSetGeneralRestrictions(const t_U16 /*u16GeneralRestrInfo*/)
      {
      }

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclResourceMngrBase::vSetETCStatus()
       ***************************************************************************/
      /*!
       * \fn      t_Void vSetETCStatus(t_Bool bETCStatus)
       * \brief   Method to set ETC Status
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vSetETCStatus(t_Bool /*bETCStatus*/)
      {
      }

      /***************************************************************************
      ** FUNCTION:  tVoid spi_tclResourceMngrBase::vOnTelephoneCallStatus()
      ***************************************************************************/
      /*!
      * \fn      vOnTelephoneCallStatus(
      *             const std::vector<trTelCallStatusInfo>& rfcoTelCallStatusList)
      * \brief   Interface to recieve info on each Telephone call
      * \param   [IN] rfcoTelCallStatusList : Telephone call info list
      **************************************************************************/
      virtual tVoid vOnTelephoneCallStatus(const std::vector<trTelCallStatusInfo>& /*rfcoTelCallStatusList*/)
      {}

      /***************************************************************************
      ** FUNCTION:  t_Void spi_tclResourceMngrBase::vOnDisableBluetoothTrigger(
      ***************************************************************************/
      /*!
      * \fn      t_Void vOnDisableBluetoothTrigger(t_String szBTAddress)
      * \brief   Method to notify component that DisableBT request is received
      * \param   [IN] szBTAddress: Unique Devcie ID
      * \retval  t_Void
      **************************************************************************/
      virtual t_Void vOnDisableBluetoothTrigger(t_String /*szBTAddress*/){}

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclResourceMngrBase::vSetResourceMngrSettingsInstance(spi_tclResourceMngrSettingsIntf* poResourceMngrSettingsIntf)
       ***************************************************************************/
      /*!
       * \fn      t_Void vSetResourceMngrSettingsInstance()
       * \brief   Method to set Resource manager settings instance.
       * \param   poResourceMngrSettingsIntf : pointer to InputHandlerSettingsIntf.
       * \retval  t_Void
       **************************************************************************/
      t_Void vSetResourceMngrSettingsInstance(spi_tclResourceMngrSettingsIntf* poResourceMngrSettingsIntf)
      {
         if( NULL != poResourceMngrSettingsIntf)
         {
            m_poResourceMngrSettings = poResourceMngrSettingsIntf;
         }
      }

      /***************************************************************************
      ** FUNCTION:  t_Void spi_tclResourceMngrBase::vOnEvaluateInitalModes(
      ***************************************************************************/
      /*!
      * \fn      t_Void vOnEvaluateInitalModes
      * \brief   Method to check and set inital modes before session is started
      * \param   [IN] corfszBTAddress: Unique Device ID
      * \retval  t_Void
      **************************************************************************/
      virtual t_Void vOnEvaluateInitalModes(const t_String& /*corfszBTAddress*/){}

      /***************************************************************************
      ** FUNCTION:  t_Void spi_tclResourceMngrBase::vOnExtVRStateUpdate(
      ***************************************************************************/
      /*!
      * \fn      t_Void vOnExtVRStateUpdate(t_String szBTAddress,
      *                        tenExtVRState e8ExtVRState,
      *                        tenVRErrorCode enVRErrorCode)
      * \brief   Method to notify VR state update for myspin
      * \param   enExtVRState : myspin VR state
      * \param   szBTAddress : BT address
      * \param   enVRErrorCode : VR error codes
      * \retval  t_Void
      **************************************************************************/
      virtual t_Void vOnExtVRStateUpdate(t_String /*szBTAddress*/,
                              tenExtVRState /*enExtVRState*/,
                              tenVRErrorCode /*enVRErrorCode*/){}

      /***************************************************************************
       ****************************END OF PUBLIC***********************************
       ***************************************************************************/

   protected:

      spi_tclResourceMngrSettingsIntf* m_poResourceMngrSettings;

      /***************************************************************************
       *********************************PROTECTED**********************************
       ***************************************************************************/

      /***************************************************************************
       ****************************END OF PROTECTED********************************
       ***************************************************************************/

   private:

      /***************************************************************************
       *********************************PRIVATE************************************
       ***************************************************************************/

      //! Lock for App states
      Lock m_oDevAppStateLock;

      /***************************************************************************
       ****************************END OF PRIVATE *********************************
       ***************************************************************************/
};
//spi_tclResourceMngrBase
typedef spi_tclResourceMngrBase* GetResourceMngr_t();
extern std::map<tenDeviceCategory,GetResourceMngr_t*> ResourceMngr;
#endif //_SPI_TCL_RSRCMNGRBASE_
