
/*!
 *******************************************************************************
 * \file    spi_tclResorceMngrDefines.h
 * \brief   SPI resource Manager Defines
 *******************************************************************************
 \verbatim
 PROJECT:       Gen3
 SW-COMPONENT:  Smart Phone Integration
 DESCRIPTION:   SPI resource Manager Defines
 COPYRIGHT:     &copy; RBEI

 HISTORY:
 Date       | Author                       | Modifications
 05.04.2014 | Priju K Padiyath             | Initial Version
 18.04.2014 | Shihabudheen P M             | Updated for response message handling 
 25.10.2014 | Shihabudheen P M             | updated for session status update
 29.11.2016 |  Noopur R K                  | HMI Synchronization

 \endverbatim
 ******************************************************************************/
#ifndef _SPI_TCLRSRCMNGRDEFINES_H_
#define _SPI_TCLRSRCMNGRDEFINES_H_

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include <functional>
#include "SPITypes.h"
#include "DiPOTypes.h"

//! function signature for callback functions from msgrcvr to dipo resource mngr
typedef std::function<t_Void(t_String)> tfvOnRequestUIReason;
typedef std::function<t_Void(trAudioAllocMsg*)> tfvAudioAllocation;
typedef std::function<t_Void(trDiPOModeState)> tfvOnModeChanged;
typedef std::function<t_Void(t_Double, t_Double)> tfvOnAudioDuckReq;
typedef std::function<t_Void(tenDiPOSessionState)> tfvOnSessionUpdate;

//! structure to hold the function callbacks. 
struct trDiPOResMngrCallback
{

   tfvOnRequestUIReason fvOnRequestUIReason;

   tfvAudioAllocation fvAudioAllocation;

   tfvOnModeChanged  fvOnModeChanged;

   tfvOnAudioDuckReq fvOnAudioDuckReq;

   tfvOnSessionUpdate fvOnSessionUpdate;

   trDiPOResMngrCallback():
      fvOnRequestUIReason(NULL),
      fvAudioAllocation(NULL),
      fvOnModeChanged(NULL),
      fvOnAudioDuckReq(NULL),
      fvOnSessionUpdate(NULL)
   {
   }
};

//!function signature for callback functions from DiPO/ML resource manager to common  resource manager
typedef std::function<t_Void(t_Bool, tenDisplayContextReason, tenDiPOEntity, const trUserContext)> tfvPostDeviceDisplayContext;
typedef std::function<t_Void(t_Bool, t_U8, tenDiPOEntity, const trUserContext)> tfvPostDeviceAudioContext;
typedef std::function<t_Void(tenSpeechAppState, tenPhoneAppState, tenNavAppState, const trUserContext)>
   tfvPostDeviceAppState;
typedef std::function<t_Void()> tfvPostInfoMsgRequest;
typedef std::function<t_Void(t_U32, tenDeviceCategory, tenSessionStatus)> tfvUpdateSessionStatus;
typedef std::function<t_Void(tenSpeechAppState, tenPhoneAppState, tenNavAppState)> tfvSetDeviceAppState;
typedef std::function<t_Void(tenSpmSubState, t_Bool)> tfvPostDeviceSpmSubState;

/*!
* \typedef - To update the device authorization and Access state
*/
typedef std::function<t_Void(const t_U32,const tenHandsetInteractionStatus)> tDeviceAuthAndAccess;

/*!
* \typedef - To update the select device result.
*/
typedef std::function<t_Void(t_Bool)> tSelectDeviceResult;

typedef std::function<t_Void(t_U32, t_String, t_String)> tfvInitiateCall;
typedef std::function<t_Void(t_U32, t_U8)> tfvVoiceSessionReq;

/*!
* \typedef - To update the projection video rendering status.
*/
typedef std::function<t_Void(tenProjVideoRenderingStatus)>tfvProjectionVideoRenderingStatus;

struct trRsrcMngrCallback
{
   tfvPostDeviceDisplayContext       fvPostDeviceDisplayContext;

   tfvPostDeviceAudioContext         fvPostDeviceAudioContext;

   tfvPostDeviceAppState             fvPostDeviceAppState;

   tfvPostInfoMsgRequest             fvPostInfoMsgRequest;

   tfvUpdateSessionStatus            fvUpdateSessionStatus;

   tfvSetDeviceAppState              fvSetDeviceAppState;

   tDeviceAuthAndAccess              fpvDeviceAuthAndAccessCb;

   tSelectDeviceResult               fvSelectDeviceResult;
   tfvInitiateCall fvInitiateCall;

   tfvVoiceSessionReq fvVoiceSessionReq;

   tfvProjectionVideoRenderingStatus fvProjectionVideoRenderingStatus;

   tfvPostDeviceSpmSubState fvPostDeviceSpmSubState;

   trRsrcMngrCallback() : fvPostDeviceDisplayContext(NULL),
      fvPostDeviceAudioContext(NULL),
      fvPostDeviceAppState(NULL),
      fvPostInfoMsgRequest(NULL),
      fvUpdateSessionStatus(NULL),
      fvSetDeviceAppState(NULL),
      fpvDeviceAuthAndAccessCb(NULL),
      fvSelectDeviceResult(NULL),
      fvInitiateCall(NULL),
      fvVoiceSessionReq(NULL),
      fvProjectionVideoRenderingStatus(NULL),
      fvPostDeviceSpmSubState(NULL)
   {
   }
};

typedef std::function<t_Void(tenSessionStatus)> tfvMySPINSessionStatus;
typedef std::function<t_Void(t_Bool, tenDisplayContextReason)> tfvMySPINDeviceDispCntxt;
typedef std::function<t_Void(t_String,t_String)> tfvMySPINInitiateCall;

struct trMySPINRsrcMngrCallback
{
   tfvMySPINSessionStatus fvSessionStatus;
   tfvMySPINDeviceDispCntxt fvDeviceDispCntxt;
   tfvMySPINInitiateCall fvMySPINInitiateCall;

   trMySPINRsrcMngrCallback():fvSessionStatus(NULL),fvDeviceDispCntxt(NULL),
                              fvMySPINInitiateCall(NULL){}
};

#endif //_SPI_TCLRSRCMNGRDEFINES_H_
