  /*!
 *******************************************************************************
 * \file         spi_tclDataServiceTypes.h
 * \brief        Data Service type defines
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Data Service type defines
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                           | Modifications
 01.04.2014 |  Ramya Murthy (RBEI/ECP2)         | Initial Version
 14.04.2014 |  Ramya Murthy (RBEI/ECP2)         | Updated & merged all DataService Manager
                                                  callbacks to a single structure.
 \endverbatim
 ******************************************************************************/

#ifndef _SPI_TCLDATASERVICETYPES_H
#define _SPI_TCLDATASERVICETYPES_H

/******************************************************************************
| includes:
|----------------------------------------------------------------------------*/
#include <functional>

#include "SPITypes.h"

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

//! Callback signature definitions
typedef std::function<t_Void(t_Bool, tenSensorDataType)> tvSubscribeForData;

//! \brief   Structure holding the callbacks to DataService manager.
struct trDataServiceCb
{
   //! Called by SPI DataService handler to subscribe for Data notifications.
   tvSubscribeForData     fvSubscribeForData;

   trDataServiceCb(): fvSubscribeForData(NULL)
   {
   }
};

/*!
 * \brief Index to various DataService handlers
 */
enum tenDataServicesIndex
{
   e8_DATASVC_ML_INDEX = 0,
   e8_DATASVC_DIPO_INDEX = 1,
   e8_DATASVC_ANDROIDAUTO_INDEX = 2,
   e8_DATASVC_MYSPIN_INDEX = 3,
   e8_DATASVC_BDCL_INDEX = 4,
   e8_DATASVC_ONCAR_INDEX = 5,

   //! Please add new device types above this in consecutive order
   //! This is required to maintain the size of enum
   e8_DATASVC_INDEX_SIZE
};


#endif // _SPI_TCLDATASERVICETYPES_H

