/*!
 *******************************************************************************
 * \file             spi_tclLegalDisclaimerResp.h
 * \brief            Response to HMI from LegalDisclaimer class
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Response  to HMI  from LegalDisclaimer class.
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 28.10.2016 |  Pruthvi Thej Nagaraju       | Initial Version
 \endverbatim
 ******************************************************************************/

#ifndef SPI_TCLLEGALDISCLAIMERRESP_H_
#define SPI_TCLLEGALDISCLAIMERRESP_H_

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/
#include "SPITypes.h"


/******************************************************************************
 | defines and macros and constants(scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/

/*!
 * \class spi_tclLegalDisclaimerResp
 * \brief Response  to HMI  from LegalDisclaimer class
 */
class spi_tclLegalDisclaimerResp
{

   public:
      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclLegalDisclaimerResp::spi_tclLegalDisclaimerResp
       ***************************************************************************/
      /*!
       * \fn     spi_tclLegalDisclaimerResp()
       * \brief  Default Constructor
       * \sa      ~spi_tclLegalDisclaimerResp()
       **************************************************************************/
      spi_tclLegalDisclaimerResp()
      {

      }

      /***************************************************************************
       ** FUNCTION:  spi_tclLegalDisclaimerResp::~spi_tclLegalDisclaimerResp
       ***************************************************************************/
      /*!
       * \fn     ~spi_tclLegalDisclaimerResp()
       * \brief  Virtual Destructor
       * \sa     spi_tclLegalDisclaimerResp()
       **************************************************************************/
      virtual ~spi_tclLegalDisclaimerResp()
      {

      }


      /***************************************************************************
       ** FUNCTION: t_Void spi_tclLegalDisclaimerResp::vPostDeviceStatusInfo
       ***************************************************************************/
      /*!
       * \fn     vUpdateDeviceAuthorizationStatus
       * \brief  It notifies the client when device authorization is required
       * \param  [IN] u32DeviceHandle : Uniquely identifies the target Device.
       * \param  [IN] enDeviceType   : Device type : Android/iPhone
       * \param  [IN] enAuthStatus  : Authorization status
       **************************************************************************/
      virtual t_Void vUpdateDeviceAuthorizationStatus(t_U32 /*u32DevHandle*/,
               tenDeviceType /*enDeviceType*/,
               tenUserAuthorizationStatus /*enAuthStatus*/)
      {

      }

};
#endif // SPI_TCLLEGALDISCLAIMERRESP_H_
