/*!
 *******************************************************************************
 * \file             spi_tclLegalDisclaimer.h
 * \brief            Implements Legal disclaimer requirements
 * \addtogroup       Connectivity
 * \{
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Implements Legal disclaimer requirements
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 11.01.2014 |  Pruthvi Thej Nagaraju       | Initial Version

 \endverbatim
 ******************************************************************************/

#ifndef SPI_TCLLEGALDISCLAIMER_H_
#define SPI_TCLLEGALDISCLAIMER_H_

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/
#include "Lock.h"
#include "spi_tclSelectionIntf.h"
#include "spi_tclDeviceListIntf.h"
#include "spi_tclLegalDisclaimerResp.h"
#include "spi_tclMediatorIntf.h"

/******************************************************************************
 | defines and macros and constants(scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/
/*!
 * \class spi_tclLegalDisclaimer
 * \brief Implements Legal disclaimer requirements
 */
class spi_tclLegalDisclaimer: public spi_tclSelectionIntf
{
   public:
      /***************************************************************************
       ** FUNCTION:  spi_tclLegalDisclaimer::spi_tclLegalDisclaimer
       ***************************************************************************/
      /*!
       * \fn     spi_tclLegalDisclaimer
       * \brief  Paramaterized Constructor
       * \param  poDeviceList : Pointer to devicelist
       * \param  pResp : Pointer to send async response sto the listener class
       * \param  poDeviceList : Pointer to devicelist
       * \param  poMediator : Pointer to Mediator instance
       **************************************************************************/
      spi_tclLegalDisclaimer(spi_tclDeviceListIntf* poDeviceList, spi_tclLegalDisclaimerResp* pResp,
               spi_tclMediatorIntf *poMediator);

      /***************************************************************************
       ** FUNCTION:  spi_tclLegalDisclaimer::~spi_tclLegalDisclaimer
       ***************************************************************************/
      /*!
       * \fn     ~spi_tclLegalDisclaimer
       * \brief  Destructor
       **************************************************************************/
      ~spi_tclLegalDisclaimer();

      /***************************************************************************
       ** FUNCTION:  spi_tclLegalDisclaimer::vSetDeviceAuthorization
       ***************************************************************************/
      /*!
       * \fn     vSetDeviceAuthorization
       * \brief  To set the device authorization based on user action
       * \param  u32DeviceHandle : Uniquely identifies the target Device.
       * \param  enUserAuthStatus : Authorization status
       **************************************************************************/
      t_Void vSetDeviceAuthorization(const t_U32 cou32DeviceHandle, tenUserAuthorizationStatus enUserAuthStatus);

      /***************************************************************************
       ** FUNCTION:  spi_tclLegalDisclaimer::vSelectDevice
       ***************************************************************************/
      /*!
       * \fn     vSelectDevice
       * \brief  device selection request
       * \param  corfrSelectReq : Device selection request details
       **************************************************************************/
      virtual void vSelectDevice(const trSelectDeviceRequest& corfrSelectReq);

      /***************************************************************************
       ** FUNCTION:  spi_tclLegalDisclaimer::vSelectDeviceResult
       ***************************************************************************/
      /*!
       * \fn     vSelectDeviceResult
       * \brief  device selection result
       * \param  corfrSelectReq : Device selection result details
       **************************************************************************/
      virtual void vSelectDeviceResult(const trSelectDeviceRequest& corfrSelectReq, tenErrorCode enErrorCode);

   private:
      /***************************************************************************
       ** FUNCTION:  spi_tclLegalDisclaimer::vSendSelectDeviceResponse
       ***************************************************************************/
      /*!
       * \fn     vSendSelectDeviceResponse
       * \brief  send device selection response back to deviceselector
       * \param  enSelectResponse :Selection Response
       * \param  enErrorCode :Error code
       **************************************************************************/
      virtual void vSendSelectDeviceResponse(tenErrorCode enErrorCode);

      /***************************************************************************
       ** FUNCTION:  spi_tclLegalDisclaimer::bIsAuthorizationRequired
       ***************************************************************************/
      /*!
       * \fn     bIsAuthorizationRequired
       * \brief  Function to check if device authorization is required for a particular device
       * \param  u32DeviceHandle : Uniquely identifies the target Device.
       * \param  enDeviceType: [IN}Device type. Android,Apple etc
       **************************************************************************/
      t_Bool bIsAuthorizationRequired(const t_U32 cou32DeviceHandle, tenDeviceType enDeviceType);

      /***************************************************************************
       ** FUNCTION:  spi_tclLegalDisclaimer::vUpdateDeviceAuthorization
       ***************************************************************************/
      /*!
       * \fn     vUpdateDeviceAuthorization
       * \brief  Helper function to update device authorization status to listner class
       * \param  cou32DeviceHandle : Uniquely identifies the target Device.
       * \param  enUserAuthStatus: Authorization status
       **************************************************************************/
      t_Void vUpdateDeviceAuthorization(const t_U32 cou32DeviceHandle, tenUserAuthorizationStatus enUserAuthStatus);

      /***************************************************************************
       ** FUNCTION:  spi_tclLegalDisclaimer::bIsProjectionEnabled
       ***************************************************************************/
      /*!
       * \fn     bIsProjectionEnabled
       * \brief  Checks if projection is enabled for the given device type
       * \param  enDeviceType : Device type
       **************************************************************************/
      t_Bool bIsProjectionEnabled(tenDeviceType enDeviceType);

      /***************************************************************************
       ** FUNCTION:  spi_tclLegalDisclaimer::bValidateAuthorization
       ***************************************************************************/
      /*!
       * \fn     bValidateAuthorization
       * \brief  Validates device authorization request received from HMI
       * \param  cou32DeviceHandle : Uniquely identifies the target Device.
       **************************************************************************/
      t_Bool bValidateAuthorization(const t_U32 cou32DeviceHandle);

      //! Stores pointer to devicelist handler
      spi_tclDeviceListIntf* m_pDeviceList;
      //! Stores Response pointer to send back asynchronous responses
      spi_tclLegalDisclaimerResp* m_pLegalDiscResp;
      //! Stores mediator pointer
      spi_tclMediatorIntf* m_pMediator;
      //! Stores Authorization updates in progress
      std::map<t_U32, tenUserAuthorizationStatus> m_mapAuthorizationStatus;
      //! protects m_mapAuthorizationStatus
      Lock m_oDeviceAuthLock;
};



#endif /* SPI_TCLLEGALDISCLAIMER_H_ */
