/*!
 *******************************************************************************
 * \file             spi_tclDeviceIDUtility.h
 * \brief
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 25.05.2017 |  Pruthvi Thej Nagaraju       | Initial Version
 \endverbatim
 ******************************************************************************/

#ifndef GENERIC_COMMON_SPI_TCLDEVICEIDUTILITY_H_
#define GENERIC_COMMON_SPI_TCLDEVICEIDUTILITY_H_

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/
#include "GenericSingleton.h"
#include "spi_tclDeviceListIntf.h"

/******************************************************************************
 | defines and macros and constants(scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/*!
 * \class spi_tclDeviceIDUtility
 * \brief
 */
class spi_tclDeviceIDUtility: public GenericSingleton<spi_tclDeviceIDUtility>
{
   public:

      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclDeviceIDUtility::~spi_tclDeviceIDUtility
       ***************************************************************************/
      /*!
       * \fn     ~spi_tclDeviceIDUtility()
       * \brief  Destructor
       **************************************************************************/
      ~spi_tclDeviceIDUtility();

      /***************************************************************************
       ** FUNCTION:  spi_tclDeviceIDUtility::u32GetDeviceIDFromBTAddress
       ***************************************************************************/
      /*!
       * \fn     u32GetDeviceIDFromBTAddress(coszBTAddress)
       **************************************************************************/
      t_U32 u32GetDeviceIDFromBTAddress(const t_String &coszBTAddress);

      /***************************************************************************
       ** FUNCTION:  spi_tclDeviceIDUtility::u32GetDeviceIDFromSerialNo
       ***************************************************************************/
      /*!
       * \fn     u32GetDeviceIDFromSerialNo(coszBTAddress)
       **************************************************************************/
      t_U32 u32GetDeviceIDFromSerialNo(const t_String &coszSerialNo);

      /***************************************************************************
       ** FUNCTION:  spi_tclDeviceIDDataIntf::u32GetDeviceIDFromName
       ***************************************************************************/
      /*!
       * \fn     u32GetDeviceIDFromName(coszBTAddress)
       **************************************************************************/
      t_U32 u32GetDeviceIDFromName(const t_String &coszDeviceName);

      /***************************************************************************
       ** FUNCTION:  spi_tclDeviceIDUtility::vGetBTAddress
       ***************************************************************************/
      /*!
       * \fn     vGetBTAddress(coszBTAddress)
       **************************************************************************/
      t_Void vGetBTAddress(t_String &coszBTAddress, const t_U32 cou32DeviceID);

      /***************************************************************************
       ** FUNCTION:  spi_tclDeviceIDUtility::vGetSerialNumber
       ***************************************************************************/
      /*!
       * \fn     vGetSerialNumber(coszBTAddress)
       **************************************************************************/
      t_Void vGetSerialNumber(t_String &coszSerialNo, const t_U32 cou32DeviceID);

      /***************************************************************************
       ** FUNCTION:  spi_tclDeviceIDUtility::vGetSessionTransport
       ***************************************************************************/
      /*!
       * \fn     vGetSessionTransport(const t_U32 cou32DeviceID,tenSessionTransport& enSessionTransport)
       **************************************************************************/

      t_Void vGetSessionTransport(const t_U32 cou32DeviceID,tenSessionTransport& enSessionTransport);

      /***************************************************************************
       ** FUNCTION:  spi_tclDeviceIDUtility::vGetDeviceCategory
       ***************************************************************************/
      /*!
       * \fn     enGetDeviceCategory(const t_U32 cou32DeviceID,tenDeviceCategory& enDeviceCategory)
       **************************************************************************/

      tenDeviceCategory enGetDeviceCategory(const t_U32 cou32DeviceID);

      /***************************************************************************
       ** FUNCTION:  spi_tclDeviceIDDataIntf::u32GetDeviceIDFromIPAddress
       ***************************************************************************/
      /*!
       * \fn     u32GetDeviceIDFromIPAddress(coszIPAddress)
       **************************************************************************/
      t_U32 u32GetDeviceIDFromIPAddress(const t_String &coszIPAddress);
      
      /***************************************************************************
       ** FUNCTION:  spi_tclDeviceIDUtility::vGetDeviceName
       ***************************************************************************/
      /*!
       * \fn     vGetDeviceName
       * \brief  To get the device name of the device identified by device handle
       * \param cou32DeviceHandle: Device Handle of the device
       * \param rfrszDeviceName : Device Name to be get
       **************************************************************************/      
      t_Void vGetDeviceName(t_U32 cou32DeviceHandle, t_String &rfszDeviceName);      

   private:

      /***************************************************************************
       *********************************PRIVATE***********************************
       ***************************************************************************/

      friend class GenericSingleton<spi_tclDeviceIDUtility>;

      spi_tclDeviceListIntf *m_pDeviceList;

      /***************************************************************************
       ** FUNCTION:  spi_tclDeviceIDUtility::spi_tclDeviceIDUtility
       ***************************************************************************/
      /*!
       * \fn     spi_tclMediator()
       * \brief  Default Constructor
       **************************************************************************/
      spi_tclDeviceIDUtility();

      /***************************************************************************
       ** FUNCTION:  spi_tclDeviceIDUtility::spi_tclDeviceIDUtility
       ***************************************************************************/
      /*!
       * \fn     spi_tclMediator()
       * \brief  Default Constructor
       **************************************************************************/
      spi_tclDeviceIDUtility(spi_tclDeviceListIntf *poDeviceList);
};



#endif /* GENERIC_COMMON_SPI_TCLDEVICEIDUTILITY_H_ */
