/*!
 *******************************************************************************
 * \file             spi_tclDevSelResp.h
 * \brief            Response to HMI from DeviceSelector class
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Response to HMI from DeviceSelector class
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 16.01.2014 |  Pruthvi Thej Nagaraju       | Initial Version
 27.09.2014 |  Shihabudheen P M            | Added vPostDeviceSelectStatus()

 \endverbatim
 ******************************************************************************/

#ifndef SPI_TCLDEVSELRESP_H_
#define SPI_TCLDEVSELRESP_H_

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/
#include "SPITypes.h"
#include "spi_ConnMngrTypeDefines.h"
/******************************************************************************
 | defines and macros and constants(scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/

/*!
 * \class spi_tclConnSettings
 * \brief Response to HMI from DeviceSelector class
 */
class spi_tclDevSelResp
{
   public:
      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclDevSelResp::spi_tclDevSelResp
       ***************************************************************************/
      /*!
       * \fn     spi_tclDevSelResp()
       * \brief  Default Constructor
       * \sa      ~spi_tclDevSelResp()
       **************************************************************************/
      spi_tclDevSelResp()
      {

      }

      /***************************************************************************
       ** FUNCTION:  spi_tclDevSelResp::~spi_tclDevSelResp
       ***************************************************************************/
      /*!
       * \fn     ~spi_tclDevSelResp()
       * \brief  Destructor
       * \sa     spi_tclDevSelResp()
       **************************************************************************/
      virtual ~spi_tclDevSelResp()
      {

      }

      /***************************************************************************
       ** FUNCTION: t_Void spi_tclDevSelResp::vPostSelectDeviceResult
       ***************************************************************************/
      /*!
       * \fn     vPostSelectDeviceResult
       * \brief  It provides the result of  select device request
       * \param  [IN] corfrSelectReq : Selection request details
       * \param  [IN] enErrorCode : Provides the Error Code in case ResponseCode==FAILURE.
       *              Set to NO_ERROR for successful operation.
       * \param  [IN] rcUsrCntxt  : User Context Details.
       * \sa     spi_tclCmdInterface::vSelectDevice
       **************************************************************************/
      virtual t_Void vPostSelectDeviceResult(const trSelectDeviceRequest& /*corfrSelectReq*/, tenErrorCode /*enErrorCode*/,
               const trUserContext /*rcUsrCntxt*/)
      {

      }


      /***************************************************************************
       ** FUNCTION: t_Void spi_tclDevSelResp::vPostDeviceSelectStatus
       ***************************************************************************/
      /*!
       * \fn     vPostDeviceSelectStatus
       * \brief  Respond with the device selection status.
       * \param  [IN] u32DeviceHandle : Uniquely identifies the target Device.
       * \param  [IN] enDevCategory   : Device category.
       * \param  [IN] enDevConnReq	  : Identifies the Connection Request.
       * \param  [IN] enRespCode      : Response code
       **************************************************************************/
      virtual t_Void vPostDeviceSelectStatus(t_U32 /*u32DeviceHandle*/,
         tenDeviceCategory /*enDevCategory*/,
         tenDeviceConnectionReq /*enDevConnReq*/,
         tenResponseCode /*enRespCode*/)
      {
      }

      /***************************************************************************
       ** FUNCTION: t_Void spi_tclDevSelResp::vClearPrivateDataOnfactoryReset
       ***************************************************************************/
      /*!
       * \fn     vClearPrivateDataOnfactoryReset
       * \brief  Triggering ClearPrivateData on Factory Reset when SPI session is active
       * \Param  None
       **************************************************************************/
      virtual t_Void vClearPrivateDataOnfactoryReset()
      {
      }
};


#endif /* SPI_TCLDEVSELRESP_H_ */
