/***********************************************************************/
/*!
* \file  spi_tclDiscoveryMsgQThreadable.cpp
* \brief implements MsgQthreader for SPI Commands
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    implements MsgQthreader for SPI Commands
AUTHOR:         Pruthvi Thej Nagaraju
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
17.03.2016  | Pruthvi Thej Nagaraju | Initial Version

\endverbatim
*************************************************************************/

/******************************************************************************
| includes:
|----------------------------------------------------------------------------*/
#include "SPITypes.h"
#include "spi_tclDiscoveryMsgQThreadable.h"
#include "spi_tclDiscoveryDispatcher.h"

//! Includes for Trace files
#include "Trace.h"
   #ifdef TARGET_BUILD
      #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_MSGQTHREADER
      #include "trcGenProj/Header/spi_tclDiscoveryMsgQThreadable.cpp.trc.h"
   #endif
#endif

#define COMMAND_ACTION(COMMAND_ID, COMMAND_MESSAGE)                           \
   case COMMAND_ID:                                                           \
   {                                                                          \
      COMMAND_MESSAGE *poDiscoveryMsg = static_cast<COMMAND_MESSAGE*> (prMsgBase);  \
      poDiscoveryMsg->vDispatchMsg(m_poDiscoveryDispatcher);                              \
      break;                                                                  \
   }



/***************************************************************************
 ** FUNCTION:  spi_tclDiscoveryMsgQThreadable::spi_tclDiscoveryMsgQThreadable()
 ***************************************************************************/
spi_tclDiscoveryMsgQThreadable::spi_tclDiscoveryMsgQThreadable(): m_poDiscoveryDispatcher(NULL)
{
   ETG_TRACE_USR1((" %s entered \n", __PRETTY_FUNCTION__));
   m_poDiscoveryDispatcher = new spi_tclDiscoveryDispatcher();
   SPI_NORMAL_ASSERT(NULL == m_poDiscoveryDispatcher);
}

/***************************************************************************
 ** FUNCTION:  spi_tclDiscoveryMsgQThreadable::~spi_tclDiscoveryMsgQThreadable()
 ***************************************************************************/

spi_tclDiscoveryMsgQThreadable::~spi_tclDiscoveryMsgQThreadable()
{
   ETG_TRACE_USR1((" %s entered \n", __PRETTY_FUNCTION__));
   RELEASE_MEM(m_poDiscoveryDispatcher);
}

/***************************************************************************
 ** FUNCTION:  spi_tclDiscoveryMsgQThreadable::vExecute
 ***************************************************************************/

t_Void spi_tclDiscoveryMsgQThreadable::vExecute(tShlMessage *poMessage)
{
   ETG_TRACE_USR1((" %s entered \n", __PRETTY_FUNCTION__));
   if ((NULL != poMessage) && (NULL != poMessage->pvBuffer))
   {
      //! Cast the received message buffer to Base message type
      trMsgBase *prMsgBase = static_cast<trMsgBase*>(poMessage->pvBuffer);
      if (NULL != prMsgBase)
      {
         t_U32 u32MessageID = prMsgBase->u32GetServiceID();
         ETG_TRACE_USR1(("spi_tclDiscoveryMsgQThreadable::vExecute: COMMAND ID = %d \n", u32MessageID));

         //! Dispatch the message based on Command ID
         switch (u32MessageID)
         {
                COMMAND_ACTION(e32MESSAGEID_DISCOVERER_DEVICEINFO, DeviceInfoMsg);
                COMMAND_ACTION(e32MESSAGEID_DISCOVERER_DEVICEDISCONNECTION, DeviceDisconnectionMsg);
                COMMAND_ACTION(e32MESSAGEID_DISCOVERER_AUTHENTICATIONSTATUS, AuthenticationStatusMsg);
                COMMAND_ACTION(e32MESSAGEID_DISCOVERER_DEVICENAMEUPDATE, UpdateDeviceNameMsg);
                COMMAND_ACTION(e32MESSAGEID_DISCOVERER_DEVICEPROFILE, DeviceProfileMsg);
                COMMAND_ACTION(e32MESSAGEID_DISCOVERER_BTLIMITATIONSTATE, BTLimitationStateMsg);

            default:
            	break;
         } // switch (u32MessageID)
      } // if (NULL != prMsgBase)

      t_U8 *pU8Buffer = static_cast<t_PU8> (poMessage->pvBuffer);
      RELEASE_ARRAY_MEM(pU8Buffer);
   }
   RELEASE_MEM(poMessage);
}

/***************************************************************************
 ** FUNCTION:  spi_tclDiscoveryMsgQThreadable::~spi_tclDiscoveryMsgQThreadable()
 ***************************************************************************/
tShlMessage* spi_tclDiscoveryMsgQThreadable::poGetMsgBuffer(size_t siBuffer)
{
   ETG_TRACE_USR1((" %s entered \n", __PRETTY_FUNCTION__));
   tShlMessage* poMessage = new tShlMessage;

   if (NULL != poMessage)
   {
      if(0 < siBuffer)
      {
         //! Allocate the requested memory
         poMessage->pvBuffer = new (std::nothrow) t_U8[siBuffer];
      }
      else
      {
         poMessage->pvBuffer = NULL;
      } // if(0 < siBuffer)

      if (NULL != poMessage->pvBuffer)
      {
         poMessage->size = siBuffer;
      }
      else
      {
         //! Free the message as internal allocation failed.
         delete poMessage;
         poMessage = NULL;
      } //   if (NULL != poMessage->pvBuffer)
   } // if (NULL != poMessage)

   return poMessage;
}
