/***********************************************************************/
/*!
* \file  spi_tclDiscoveryMsgQThreadable.h
* \brief implements MsgQthreader for Discoverer Messages
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    implements MsgQthreader for Discoverer Messages
AUTHOR:         Pruthvi Thej Nagaraju
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
17.06.2016  | Pruthvi Thej Nagaraju | Initial Version

\endverbatim
*************************************************************************/

#ifndef SPI_TCLDISCOVERYMSGQTHREADER_H_
#define SPI_TCLDISCOVERYMSGQTHREADER_H_


/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "MsgQThreadable.h"
#include "BaseTypes.h"


using namespace shl::thread;

//!Forward declarations
class spi_tclDiscoveryDispatcher;

/****************************************************************************/
/*!
* \class spi_tclDiscoveryMsgQThreadable
* \brief implements threading based on MsgQthreader for Discoverer
*
* Responsible for calling the respective dispatchers and to allocate memory
* when a message arrives on Q
*
****************************************************************************/

class spi_tclDiscoveryMsgQThreadable : public MsgQThreadable
{
   public:

      /***************************************************************************
      ** FUNCTION:  spi_tclDiscoveryMsgQThreadable::spi_tclDiscoveryMsgQThreadable()
      ***************************************************************************/
      /*!
      * \fn      spi_tclDiscoveryMsgQThreadable()
      * \brief   Default Constructor
      * \sa      ~spi_tclDiscoveryMsgQThreadable()
      **************************************************************************/
      spi_tclDiscoveryMsgQThreadable();

      /***************************************************************************
      ** FUNCTION:  spi_tclDiscoveryMsgQThreadable::~spi_tclDiscoveryMsgQThreadable()
      ***************************************************************************/
      /*!
      * \fn      ~spi_tclDiscoveryMsgQThreadable()
      * \brief   Destructor
      * \sa      spi_tclDiscoveryMsgQThreadable()
      **************************************************************************/
      ~spi_tclDiscoveryMsgQThreadable();

   protected:
      /***************************************************************************
      ** FUNCTION:  spi_tclDiscoveryMsgQThreadable::vExecute
      ***************************************************************************/
      /*!
      * \fn      t_Void vExecute(tShlMessage *poMessage)
      * \brief   Responsible for posting the message to respective dispatchers
      * \param   poMessage : message received from MsgQ for dispatching
      **************************************************************************/
      virtual t_Void vExecute(tShlMessage *poMessage);

      /***************************************************************************
      ** FUNCTION:  spi_tclDiscoveryMsgQThreadable::tShlMessage* poGetMsgBuffer(size_t )
      ***************************************************************************/
      /*!
      * \fn      tShlMessage* poGetMsgBuffer(size_t )
      * \brief  This function will be called for requesting the storage allocation for received
      *           message
      * \param siBuffer: size of the buffer to be allocated for the received message
      **************************************************************************/
      virtual tShlMessage* poGetMsgBuffer(size_t siBuffer);

   private:
   
      /***************************************************************************
       ** FUNCTION:  spi_tclDiscoveryMsgQThreadable(const spi_tclDiscoveryMsgQThreadable...
       ***************************************************************************/
      /*!
       * \fn      spi_tclDiscoveryMsgQThreadable(
       *                             const spi_tclDiscoveryMsgQThreadable& corfoSrc)
       * \brief   Copy constructor - Do not allow the creation of copy constructor
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclDiscoveryMsgQThreadable()
       ***************************************************************************/
       spi_tclDiscoveryMsgQThreadable(const spi_tclDiscoveryMsgQThreadable& corfoSrc);


      /***************************************************************************
       ** FUNCTION:  spi_tclDiscoveryMsgQThreadable& operator=( const spi_tclAAP...
       ***************************************************************************/
      /*!
       * \fn      spi_tclDiscoveryMsgQThreadable& operator=(
       *                          const spi_tclDiscoveryMsgQThreadable& corfoSrc))
       * \brief   Assignment operator
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclDiscoveryMsgQThreadable(const spi_tclDiscoveryMsgQThreadable& otrSrc)
       ***************************************************************************/
       spi_tclDiscoveryMsgQThreadable& operator=(const spi_tclDiscoveryMsgQThreadable& corfoSrc);   

      //! Pointers to Message Dispatchers
      spi_tclDiscoveryDispatcher *m_poDiscoveryDispatcher;
};


#endif /* SPI_TCLDISCOVERYMSGQTHREADER_H_ */
