/***********************************************************************/
/*!
 * \file  spi_tclDiscoveryMsgQInterface.h
 * \brief interface for writing discoverer messages to Message Q to use the MsgQ based
 *        threading model for Dispatching messages received by Discoverer
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    interface for writing discoverer messages to Message Q to use the MsgQ based
                 threading model for Dispatching messages received by Discoverer
 AUTHOR:         Pruthvi Thej Nagaraju
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 17.06.2016  | Pruthvi Thej Nagaraju | Initial Version

 \endverbatim
 *************************************************************************/

#ifndef SPI_TCLDISCOVERYMSGQINTERFACE_H_
#define SPI_TCLDISCOVERYMSGQINTERFACE_H_

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "BaseTypes.h"
#include "GenericSingleton.h"
#include "MsgQThreader.h"

//!Forward declarations
class spi_tclDiscoveryMsgQThreadable;
class trMsgBase;

/****************************************************************************/
/*!
* \class spi_tclDiscoveryMsgQInterface
* \brief interface for writing commands to Message Q to use the MsgQ based
         threading model for Dispatching commands received by SPI
****************************************************************************/
class spi_tclDiscoveryMsgQInterface : public GenericSingleton<spi_tclDiscoveryMsgQInterface>
{
   public:

      /***************************************************************************
      ** FUNCTION:  spi_tclDiscoveryMsgQInterface::~spi_tclDiscoveryMsgQInterface()
      ***************************************************************************/
      /*!
      * \fn      ~spi_tclDiscoveryMsgQInterface()
      * \brief   Destructor
      * \sa      spi_tclDiscoveryMsgQInterface()
      **************************************************************************/
      ~spi_tclDiscoveryMsgQInterface();

      /***************************************************************************
      ** FUNCTION:  spi_tclDiscoveryMsgQInterface::bWriteMsgToQ
      ***************************************************************************/
      /*!
      * \fn      bWriteMsgToQ(trMsgBase *prMsgBase, t_U32 u32MsgSize)
      * \brief   Write Message to Q for dispatching the message by a seperate thread
      * \param   prMsgBase : Pointer to Base Message type
      * \param   u32MsgSize :  size of the message to be written to the MsgQ
      **************************************************************************/
      t_Bool bWriteMsgToQ(trMsgBase *prMsgBase, t_U32 u32MsgSize);

      //! Base Singleton class
      friend class GenericSingleton<spi_tclDiscoveryMsgQInterface> ;

   private:

      /***************************************************************************
      ** FUNCTION:  spi_tclDiscoveryMsgQInterface::spi_tclDiscoveryMsgQInterface()
      ***************************************************************************/
      /*!
      * \fn      spi_tclDiscoveryMsgQInterface()
      * \brief   Default Constructor
      * \sa      ~spi_tclDiscoveryMsgQInterface()
      **************************************************************************/
      spi_tclDiscoveryMsgQInterface();
	  
      /***************************************************************************
       ** FUNCTION:  spi_tclDiscoveryMsgQInterface(const spi_tclDiscoveryMsgQInterface...
       ***************************************************************************/
      /*!
       * \fn      spi_tclDiscoveryMsgQInterface(
       *                             const spi_tclDiscoveryMsgQInterface& corfoSrc)
       * \brief   Copy constructor - Do not allow the creation of copy constructor
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclDiscoveryMsgQInterface()
       ***************************************************************************/
       spi_tclDiscoveryMsgQInterface(const spi_tclDiscoveryMsgQInterface& corfoSrc);


      /***************************************************************************
       ** FUNCTION:  spi_tclDiscoveryMsgQInterface& operator=( const spi_tclAAP...
       ***************************************************************************/
      /*!
       * \fn      spi_tclDiscoveryMsgQInterface& operator=(
       *                          const spi_tclDiscoveryMsgQInterface& corfoSrc))
       * \brief   Assignment operator
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclDiscoveryMsgQInterface(const spi_tclDiscoveryMsgQInterface& otrSrc)
       ***************************************************************************/
       spi_tclDiscoveryMsgQInterface& operator=(const spi_tclDiscoveryMsgQInterface& corfoSrc);	  

      //! Pointer to the overridden MsgQThreadable class
      spi_tclDiscoveryMsgQThreadable *m_poDiscoveryMsgQThreadable;

      //! pointer to MsgQThreader
      ::shl::thread::MsgQThreader *m_poDiscoveryMsgQThreader;

};


#endif /* SPI_TCLDISCOVERYMSGQINTERFACE_H_ */
