/***********************************************************************/
/*!
 * \file  spi_tclDiscoveryDispatcher.h
 * \brief Message Dispatcher for SPI Discoverer Messages.
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Message Dispatcher for SPI Discoverer Messages. Implemented using
 double dispatch mechanism
 AUTHOR:         Pruthvi Thej Nagaraju
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                			| Modification
 17.06.2016  | Pruthvi Thej Nagaraju 			| Initial Version


 \endverbatim
 *************************************************************************/
#ifndef SPI_TCLDISCOVERYDISPATCHER_H_
#define SPI_TCLDISCOVERYDISPATCHER_H_

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/
#include "SPITypes.h"
#include "spi_ConnMngrTypeDefines.h"

/**************Forward Declarations******************************************/
class spi_tclDiscoveryDispatcher;
class spi_tclConnMngr;

/*! \note : Dynamic memory allocation is required where non basic types such as
 *  STL containers are used because these types are not allocated on stack and hence
 *  data held by these types are not passed via message queue. To avoid illegal
 *  memory access, such types can be allocated memory in vAllocateMsg() and released
 *  in vDeAllocateMsg(). If only basic types are used, these function can be left
 *  blank.
 */
//lint -save -e1401 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e64 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported

/****************************************************************************/
/*!
 * \class DeviceInfoMsg
 * \brief Discoverer attestation response message
 ****************************************************************************/
class DeviceInfoMsg: public trMsgBase
{
   public:

      trDeviceInfo *m_prDeviceInfo;
      tenDiscovererType m_enDiscovererType;

      /***************************************************************************
       ** FUNCTION:  DeviceInfoMsg::DeviceInfoMsg
       ***************************************************************************/
      /*!
       * \fn      DeviceInfoMsg()
       * \brief   Default constructor
       **************************************************************************/
      DeviceInfoMsg();

      /***************************************************************************
       ** FUNCTION:  DeviceInfoMsg::~DeviceInfoMsg
       ***************************************************************************/
      /*!
       * \fn      ~DeviceInfoMsg()
       * \brief   Destructor
       **************************************************************************/
      virtual ~DeviceInfoMsg(){}

      /***************************************************************************
       ** FUNCTION:  DeviceInfoMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclDiscoveryDispatcher* poDiscovererDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
      * \param  poDiscovererDispatcher : pointer to Message dispatcher for Discoverer
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclDiscoveryDispatcher* poDiscovererDispatcher);

      /***************************************************************************
       ** FUNCTION:  DeviceInfoMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       **************************************************************************/
      t_Void vAllocateMsg();

      /***************************************************************************
       ** FUNCTION:  DeviceInfoMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       **************************************************************************/
      t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class DeviceDisconnectionMsg
 * \brief
 ****************************************************************************/
class DeviceDisconnectionMsg: public trMsgBase
{
   public:
      t_U32 m_u32DeviceHandle;
      tenDiscovererType m_enDiscovererType;
      tenDeviceConnectionType m_enDeviceConnectionType;
      tenSPISupport m_enCarplaySupport ;
      /***************************************************************************
       ** FUNCTION:  DeviceDisconnectionMsg::DeviceDisconnectionMsg
       ***************************************************************************/
      /*!
       * \fn      DeviceDisconnectionMsg()
       * \brief   Default constructor
       **************************************************************************/
      DeviceDisconnectionMsg();

      /***************************************************************************
       ** FUNCTION:  DeviceDisconnectionMsg::~DeviceDisconnectionMsg
       ***************************************************************************/
      /*!
       * \fn      ~DeviceDisconnectionMsg()
       * \brief   Destructor
       **************************************************************************/
      virtual ~DeviceDisconnectionMsg(){}

      /***************************************************************************
       ** FUNCTION:  DeviceDisconnectionMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclDiscoveryDispatcher* poDiscovererDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
      * \param  poDiscovererDispatcher : pointer to Message dispatcher for Discoverer
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclDiscoveryDispatcher* poDiscovererDispatcher);

      /***************************************************************************
       ** FUNCTION:  DeviceDisconnectionMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       **************************************************************************/
      t_Void vAllocateMsg(){}

      /***************************************************************************
       ** FUNCTION:  DeviceDisconnectionMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       **************************************************************************/
      t_Void vDeAllocateMsg(){}
};


/****************************************************************************/
/*!
 * \class AuthenticationStatusMsg
 * \brief
 ****************************************************************************/
class AuthenticationStatusMsg: public trMsgBase
{
   public:
      t_U32 m_u32DeviceHandle;
      tenDAPStatus m_enDAPStatus;
      /***************************************************************************
       ** FUNCTION:  AuthenticationStatusMsg::AuthenticationStatusMsg
       ***************************************************************************/
      /*!
       * \fn      AuthenticationStatusMsg()
       * \brief   Default constructor
       **************************************************************************/
      AuthenticationStatusMsg();

      /***************************************************************************
       ** FUNCTION:  AuthenticationStatusMsg::~AuthenticationStatusMsg
       ***************************************************************************/
      /*!
       * \fn      ~AuthenticationStatusMsg()
       * \brief   Destructor
       **************************************************************************/
      virtual ~AuthenticationStatusMsg(){}

      /***************************************************************************
       ** FUNCTION:  AuthenticationStatusMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclDiscoveryDispatcher* poDiscovererDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
      * \param  poDiscovererDispatcher : pointer to Message dispatcher for Discoverer
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclDiscoveryDispatcher* poDiscovererDispatcher);

      /***************************************************************************
       ** FUNCTION:  AuthenticationStatusMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       **************************************************************************/
      t_Void vAllocateMsg(){}

      /***************************************************************************
       ** FUNCTION:  AuthenticationStatusMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       **************************************************************************/
      t_Void vDeAllocateMsg(){}
};

/****************************************************************************/
/*!
 * \class UpdateDeviceNameMsg
 * \brief Discoverer attestation response message
 ****************************************************************************/
class UpdateDeviceNameMsg: public trMsgBase
{
   public:

      t_U32 m_u32DeviceHandle;
      t_String *m_szDeviceName;
      tenDiscovererType m_enDiscovererType;

      /***************************************************************************
       ** FUNCTION:  UpdateDeviceNameMsg::UpdateDeviceNameMsg
       ***************************************************************************/
      /*!
       * \fn      UpdateDeviceNameMsg()
       * \brief   Default constructor
       **************************************************************************/
      UpdateDeviceNameMsg();

      /***************************************************************************
       ** FUNCTION:  UpdateDeviceNameMsg::UpdateDeviceNameMsg
       ***************************************************************************/
      /*!
       * \fn      UpdateDeviceNameMsg()
       * \brief   Parameterised constructor
       **************************************************************************/
      UpdateDeviceNameMsg(t_U32 u32DeviceHandle, t_String szDeviceName, tenDiscovererType enDiscovererType);

      /***************************************************************************
       ** FUNCTION:  UpdateDeviceNameMsg::~UpdateDeviceNameMsg
       ***************************************************************************/
      /*!
       * \fn      ~UpdateDeviceNameMsg()
       * \brief   Destructor
       **************************************************************************/
      virtual ~UpdateDeviceNameMsg(){}

      /***************************************************************************
       ** FUNCTION:  UpdateDeviceNameMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclDiscoveryDispatcher* poDiscovererDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
      * \param  poDiscovererDispatcher : pointer to Message dispatcher for Discoverer
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclDiscoveryDispatcher* poDiscovererDispatcher);

      /***************************************************************************
       ** FUNCTION:  UpdateDeviceNameMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       **************************************************************************/
      t_Void vAllocateMsg();

      /***************************************************************************
       ** FUNCTION:  UpdateDeviceNameMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       **************************************************************************/
      t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class DeviceProfileMsg
 * \brief
 ****************************************************************************/
class DeviceProfileMsg: public trMsgBase
{
   public:
      t_U32 m_u32DeviceHandle;
      tenDiscovererType m_enDiscovererType;
      tenDeviceProfile m_enDeviceProfile;

      /***************************************************************************
       ** FUNCTION:  DeviceProfileMsg::DeviceProfileMsg
       ***************************************************************************/
      /*!
       * \fn      DeviceProfileMsg()
       * \brief   Default constructor
       **************************************************************************/
      DeviceProfileMsg();

      /***************************************************************************
       ** FUNCTION:  DeviceProfileMsg::~DeviceProfileMsg
       ***************************************************************************/
      /*!
       * \fn      ~DeviceProfileMsg()
       * \brief   Destructor
       **************************************************************************/
      virtual ~DeviceProfileMsg(){}

      /***************************************************************************
       ** FUNCTION:  DeviceProfileMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclDiscoveryDispatcher* poDiscovererDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
      * \param  poDiscovererDispatcher : pointer to Message dispatcher for Discoverer
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclDiscoveryDispatcher* poDiscovererDispatcher);

      /***************************************************************************
       ** FUNCTION:  DeviceProfileMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       **************************************************************************/
      t_Void vAllocateMsg(){}

      /***************************************************************************
       ** FUNCTION:  DeviceProfileMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       **************************************************************************/
      t_Void vDeAllocateMsg(){}
};


/****************************************************************************/
/*!
 * \class BTLimitationStateMsg
 * \brief
 ****************************************************************************/
class BTLimitationStateMsg: public trMsgBase
{
   public:
      t_U32 m_u32DeviceHandle;
      tenDiscovererType m_enDiscovererType;
      t_Bool m_bIsDeviceBTFunctionalityLimited;

      /***************************************************************************
       ** FUNCTION:  BTLimitationStateMsg::BTLimitationStateMsg
       ***************************************************************************/
      /*!
       * \fn      BTLimitationStateMsg()
       * \brief   Default constructor
       **************************************************************************/
      BTLimitationStateMsg();

      /***************************************************************************
       ** FUNCTION:  BTLimitationStateMsg::~BTLimitationStateMsg
       ***************************************************************************/
      /*!
       * \fn      ~BTLimitationStateMsg()
       * \brief   Destructor
       **************************************************************************/
      virtual ~BTLimitationStateMsg(){}

      /***************************************************************************
       ** FUNCTION:  BTLimitationStateMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclDiscoveryDispatcher* poDiscovererDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
      * \param  poDiscovererDispatcher : pointer to Message dispatcher for Discoverer
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclDiscoveryDispatcher* poDiscovererDispatcher);

      /***************************************************************************
       ** FUNCTION:  BTLimitationStateMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       **************************************************************************/
      t_Void vAllocateMsg(){}

      /***************************************************************************
       ** FUNCTION:  BTLimitationStateMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       **************************************************************************/
      t_Void vDeAllocateMsg(){}
};


/****************************************************************************/
/*!
 * \class spi_tclDiscoveryDispatcher
 * \brief Message Dispatcher for Discoverer Messages
 ****************************************************************************/
class spi_tclDiscoveryDispatcher
{
   public:
      /***************************************************************************
       ** FUNCTION:  spi_tclDiscoveryDispatcher::spi_tclDiscoveryDispatcher
       ***************************************************************************/
      /*!
       * \fn      spi_tclDiscoveryDispatcher()
       * \brief   Default constructor
       **************************************************************************/
      spi_tclDiscoveryDispatcher();

      /***************************************************************************
       ** FUNCTION:  spi_tclDiscoveryDispatcher::~spi_tclDiscoveryDispatcher
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclDiscoveryDispatcher()
       * \brief   Destructor
       **************************************************************************/
      ~spi_tclDiscoveryDispatcher();


      /***************************************************************************
       ** FUNCTION:  spi_tclDiscoveryDispatcher::vHandleDiscovererMsg(DeviceInfoMsg* poDeviceInfoMsg)
       ***************************************************************************/
      /*!
       * \fn      vHandleDiscovererMsg(DeviceInfoMsg* poDeviceInfoMsg)
       * \brief   Handles Messages of DeviceInfoMsg type
      * \param   poLaunchDiscovererMsg : pointer to DeviceInfoMsg.
       **************************************************************************/
      t_Void vHandleDiscovererMsg(DeviceInfoMsg* poDeviceInfoMsg)const;

      /***************************************************************************
       ** FUNCTION:  spi_tclDiscoveryDispatcher::vHandleDiscovererMsg(DeviceDisconnectionMsg* poDeviceDisconnMsg)
       ***************************************************************************/
      /*!
       * \fn      vHandleDiscovererMsg(DeviceDisconnectionMsg* poDeviceDisconnMsg)
       * \brief   Handles Messages of DeviceDisconnectionMsg type
      * \param   poLaunchDiscovererMsg : pointer to DeviceDisconnectionMsg.
       **************************************************************************/
      t_Void vHandleDiscovererMsg(DeviceDisconnectionMsg* poDeviceDisconnMsg)const;

      /***************************************************************************
       ** FUNCTION:  spi_tclDiscoveryDispatcher::vHandleDiscovererMsg(AuthenticationStatusMsg* poDeviceDisconnMsg)
       ***************************************************************************/
      /*!
       * \fn      vHandleDiscovererMsg(AuthenticationStatusMsg* poDeviceDisconnMsg)
       * \brief   Handles Messages of DeviceDisconnectionMsg type
      * \param   poLaunchDiscovererMsg : pointer to DeviceDisconnectionMsg.
       **************************************************************************/
      t_Void vHandleDiscovererMsg(AuthenticationStatusMsg* poDeviceDisconnMsg)const;

      /***************************************************************************
       ** FUNCTION:  spi_tclDiscoveryDispatcher::vHandleDiscovererMsg(UpdateDeviceNameMsg* poUpdateDeviceNameMsg)
       ***************************************************************************/
      /*!
       * \fn      vHandleDiscovererMsg(UpdateDeviceNameMsg* poUpdateDeviceNameMsg)
       * \brief   Handles Messages of UpdateDeviceNameMsg type
      * \param   poUpdateDeviceNameMsg : pointer to UpdateDeviceNameMsg.
       **************************************************************************/
      t_Void vHandleDiscovererMsg(UpdateDeviceNameMsg* poUpdateDeviceNameMsg)const;

      /***************************************************************************
       ** FUNCTION:  spi_tclDiscoveryDispatcher::vHandleDiscovererMsg(DeviceProfileMsg* poDeviceProfileMsg)
       ***************************************************************************/
      /*!
       * \fn      vHandleDiscovererMsg(DeviceProfileMsg* poDeviceDisconnMsg)
       * \brief   Handles Messages of DeviceProfileMsg type
      * \param   poDeviceProfileMsg : pointer to DeviceDisconnectionMsg.
       **************************************************************************/
      t_Void vHandleDiscovererMsg(DeviceProfileMsg* poDeviceProfileMsg)const;

      /***************************************************************************
       ** FUNCTION:  spi_tclDiscoveryDispatcher::vHandleDiscovererMsg(BTLimitationStateMsg* poDeviceProfileMsg)
       ***************************************************************************/
      /*!
       * \fn      vHandleDiscovererMsg(BTLimitationStateMsg* poDeviceDisconnMsg)
       * \brief   Handles Messages of BTLimitationStateMsg type
      * \param   poBTLimitationStateMsg : pointer to BTLimitationStateMsg.
       **************************************************************************/
      t_Void vHandleDiscovererMsg(BTLimitationStateMsg* poBTLimitationStateMsg)const;

      private:

      /***************************************************************************
      *********************************PRIVATE************************************
      ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclDiscoveryDispatcher(const spi_tclDiscoveryDispatcher...
       ***************************************************************************/
      /*!
       * \fn      spi_tclDiscoveryDispatcher(
       *                             const spi_tclDiscoveryDispatcher& corfoSrc)
       * \brief   Copy constructor - Do not allow the creation of copy constructor
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclDiscoveryDispatcher()
       ***************************************************************************/
       spi_tclDiscoveryDispatcher(const spi_tclDiscoveryDispatcher& corfoSrc);


      /***************************************************************************
       ** FUNCTION:  spi_tclDiscoveryDispatcher& operator=( const spi_tclAAP...
       ***************************************************************************/
      /*!
       * \fn      spi_tclDiscoveryDispatcher& operator=(
       *                          const spi_tclDiscoveryDispatcher& corfoSrc))
       * \brief   Assignment operator
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclDiscoveryDispatcher(const spi_tclDiscoveryDispatcher& otrSrc)
       ***************************************************************************/
       spi_tclDiscoveryDispatcher& operator=(const spi_tclDiscoveryDispatcher& corfoSrc);   

      /***************************************************************************
      ****************************END OF PRIVATE *********************************
      ***************************************************************************/		  

};
#endif /* SPI_TCLDISCOVERYDISPATCHER_H_ */
